/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.PDPType;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.PDPTypeValue;
import org.mobicents.protocols.ss7.map.primitives.OctetStringBase;

public class PDPTypeImpl
extends OctetStringBase
implements PDPType {
    public static final int _VALUE_ETSI = 240;
    public static final int _VALUE_IETF = 241;
    public static final int _VALUE_PPP = 1;
    public static final int _VALUE_IPv4 = 33;
    public static final int _VALUE_IPv6 = 87;

    public PDPTypeImpl() {
        super(2, 2, "PDPType");
    }

    public PDPTypeImpl(byte[] data) {
        super(2, 2, "PDPType", data);
    }

    public PDPTypeImpl(PDPTypeValue value) {
        super(2, 2, "PDPType");
        this.setPDPTypeValue(value);
    }

    protected void setPDPTypeValue(PDPTypeValue value) {
        this.data = new byte[2];
        switch (value) {
            case PPP: {
                this.data[0] = -16;
                this.data[1] = 1;
                break;
            }
            case IPv4: {
                this.data[0] = -15;
                this.data[1] = 33;
                break;
            }
            case IPv6: {
                this.data[0] = -15;
                this.data[1] = 87;
            }
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public PDPTypeValue getPDPTypeValue() {
        if (this.data != null && this.data.length == 2) {
            if ((this.data[0] & 0xFF) == 240) {
                if (this.data[1] == 1) {
                    return PDPTypeValue.PPP;
                }
            } else if ((this.data[0] & 0xFF) == 241) {
                if (this.data[1] == 33) {
                    return PDPTypeValue.IPv4;
                }
                if (this.data[1] == 87) {
                    return PDPTypeValue.IPv6;
                }
            }
        }
        return null;
    }

    public String toString() {
        PDPTypeValue value = this.getPDPTypeValue();
        if (value != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this._PrimitiveName);
            sb.append(" [PDPTypeValue=");
            sb.append(value);
            sb.append("]");
            return sb.toString();
        }
        return super.toString();
    }
}

