/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SupportedFeatures;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtBearerServiceCode;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtTeleserviceCode;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.InsertSubscriberDataResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ODBGeneralData;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.OfferedCamel4CSIs;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.RegionalSubscriptionResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.SupportedCamelPhases;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSCode;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.SupportedFeaturesImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtBearerServiceCodeImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtTeleserviceCodeImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ODBGeneralDataImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.OfferedCamel4CSIsImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.SupportedCamelPhasesImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSCodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertSubscriberDataResponseImpl
extends MobilityMessageImpl
implements InsertSubscriberDataResponse {
    public static final String _PrimitiveName = "InsertSubscriberDataResponse";
    protected static final int _TAG_teleserviceList = 1;
    protected static final int _TAG_bearerServiceList = 2;
    protected static final int _TAG_SS_List = 3;
    protected static final int _TAG_odb_GeneralData = 4;
    protected static final int _TAG_regionalSubscriptionResponse = 5;
    protected static final int _TAG_supportedCamelPhases = 6;
    protected static final int _TAG_extContainer = 7;
    protected static final int _TAG_offeredCamel4CSIs = 8;
    protected static final int _TAG_supportedFeatures = 9;
    private ArrayList<ExtTeleserviceCode> teleserviceList = null;
    private ArrayList<ExtBearerServiceCode> bearerServiceList = null;
    private ArrayList<SSCode> ssList = null;
    private ODBGeneralData odbGeneralData = null;
    private RegionalSubscriptionResponse regionalSubscriptionResponse = null;
    private SupportedCamelPhases supportedCamelPhases = null;
    private MAPExtensionContainer extensionContainer = null;
    private OfferedCamel4CSIs offeredCamel4CSIs = null;
    private SupportedFeatures supportedFeatures = null;
    private long mapProtocolVersion;

    public InsertSubscriberDataResponseImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public InsertSubscriberDataResponseImpl(long mapProtocolVersion, ArrayList<ExtTeleserviceCode> teleserviceList, ArrayList<ExtBearerServiceCode> bearerServiceList, ArrayList<SSCode> ssList, ODBGeneralData odbGeneralData, RegionalSubscriptionResponse regionalSubscriptionResponse) {
        this.mapProtocolVersion = mapProtocolVersion;
        this.teleserviceList = teleserviceList;
        this.bearerServiceList = bearerServiceList;
        this.ssList = ssList;
        this.odbGeneralData = odbGeneralData;
        this.regionalSubscriptionResponse = regionalSubscriptionResponse;
    }

    public InsertSubscriberDataResponseImpl(long mapProtocolVersion, ArrayList<ExtTeleserviceCode> teleserviceList, ArrayList<ExtBearerServiceCode> bearerServiceList, ArrayList<SSCode> ssList, ODBGeneralData odbGeneralData, RegionalSubscriptionResponse regionalSubscriptionResponse, SupportedCamelPhases supportedCamelPhases, MAPExtensionContainer extensionContainer, OfferedCamel4CSIs offeredCamel4CSIs, SupportedFeatures supportedFeatures) {
        this.mapProtocolVersion = mapProtocolVersion;
        this.teleserviceList = teleserviceList;
        this.bearerServiceList = bearerServiceList;
        this.ssList = ssList;
        this.odbGeneralData = odbGeneralData;
        this.regionalSubscriptionResponse = regionalSubscriptionResponse;
        if (mapProtocolVersion >= 3L) {
            this.supportedCamelPhases = supportedCamelPhases;
            this.extensionContainer = extensionContainer;
            this.offeredCamel4CSIs = offeredCamel4CSIs;
            this.supportedFeatures = supportedFeatures;
        }
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.insertSubscriberData_Response;
    }

    public int getOperationCode() {
        return 7;
    }

    public ArrayList<ExtTeleserviceCode> getTeleserviceList() {
        return this.teleserviceList;
    }

    public ArrayList<ExtBearerServiceCode> getBearerServiceList() {
        return this.bearerServiceList;
    }

    public ArrayList<SSCode> getSSList() {
        return this.ssList;
    }

    public ODBGeneralData getODBGeneralData() {
        return this.odbGeneralData;
    }

    public RegionalSubscriptionResponse getRegionalSubscriptionResponse() {
        return this.regionalSubscriptionResponse;
    }

    public SupportedCamelPhases getSupportedCamelPhases() {
        return this.supportedCamelPhases;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public OfferedCamel4CSIs getOfferedCamel4CSIs() {
        return this.offeredCamel4CSIs;
    }

    public SupportedFeatures getSupportedFeatures() {
        return this.supportedFeatures;
    }

    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding InsertSubscriberDataResponse: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding InsertSubscriberDataResponse: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding InsertSubscriberDataResponse: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding InsertSubscriberDataResponse: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        ExtTeleserviceCodeImpl teleserviceItem = null;
        this.teleserviceList = null;
        this.extensionContainer = null;
        this.bearerServiceList = null;
        this.ssList = null;
        this.odbGeneralData = null;
        this.regionalSubscriptionResponse = null;
        this.supportedCamelPhases = null;
        this.offeredCamel4CSIs = null;
        this.supportedFeatures = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (ais.getTagClass()) {
                case 2: {
                    switch (tag) {
                        case 1: {
                            int tag2;
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse.teleserviceList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            AsnInputStream ais2 = ais.readSequenceStream();
                            this.teleserviceList = new ArrayList();
                            while (ais2.available() != 0) {
                                tag2 = ais2.readTag();
                                if (tag2 != 4 || ais2.getTagClass() != 0 || !ais2.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse: bad teleserviceCode element tag or tagClass or is not primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                teleserviceItem = new ExtTeleserviceCodeImpl();
                                teleserviceItem.decodeAll(ais2);
                                this.teleserviceList.add(teleserviceItem);
                            }
                            if (this.teleserviceList.size() >= 1 && this.teleserviceList.size() <= 20) break block0;
                            throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse: Parameter teleserviceList size must be from 1 to 20, found: " + this.teleserviceList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 2: {
                            int tag2;
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse.bearerServiceList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            AsnInputStream ais2 = ais.readSequenceStream();
                            this.bearerServiceList = new ArrayList();
                            while (ais2.available() != 0) {
                                tag2 = ais2.readTag();
                                if (tag2 != 4 || ais2.getTagClass() != 0 || !ais2.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse: bad bearerServiceList element tag or tagClass or is not primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ExtBearerServiceCodeImpl extBearerServiceCode = new ExtBearerServiceCodeImpl();
                                extBearerServiceCode.decodeAll(ais2);
                                this.bearerServiceList.add(extBearerServiceCode);
                            }
                            if (this.bearerServiceList.size() >= 1 && this.bearerServiceList.size() <= 50) break block0;
                            throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse: Parameter bearerServiceList size must be from 1 to 50, found: " + this.bearerServiceList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 3: {
                            int tag2;
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse.ssList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            AsnInputStream ais2 = ais.readSequenceStream();
                            this.ssList = new ArrayList();
                            while (ais2.available() != 0) {
                                tag2 = ais2.readTag();
                                if (tag2 != 4 || ais2.getTagClass() != 0 || !ais2.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse: bad ssListList element tag or tagClass or is not primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                SSCodeImpl ssCode = new SSCodeImpl();
                                ssCode.decodeAll(ais2);
                                this.ssList.add(ssCode);
                            }
                            if (this.ssList.size() >= 1 && this.ssList.size() <= 30) break block0;
                            throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse: Parameter ssList size must be from 1 to 30, found: " + this.ssList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 4: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse.odbGeneralData: Parameter odbGeneralData is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.odbGeneralData = new ODBGeneralDataImpl();
                            ((ODBGeneralDataImpl)this.odbGeneralData).decodeAll(ais);
                            break;
                        }
                        case 5: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse.regionalSubscriptionResponse: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.regionalSubscriptionResponse = RegionalSubscriptionResponse.getInstance((int)((int)ais.readInteger()));
                            break;
                        }
                        case 6: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse.supportedCamelPhases: Parameter supportedCamelPhases is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.supportedCamelPhases = new SupportedCamelPhasesImpl();
                            ((SupportedCamelPhasesImpl)this.supportedCamelPhases).decodeAll(ais);
                            break;
                        }
                        case 7: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse.extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            break;
                        }
                        case 8: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse.offeredCamel4CSIs: Parameter offeredCamel4CSIs is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.offeredCamel4CSIs = new OfferedCamel4CSIsImpl();
                            ((OfferedCamel4CSIsImpl)this.offeredCamel4CSIs).decodeAll(ais);
                            break;
                        }
                        case 9: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse.supportedFeatures: Parameter supportedFeatures is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.supportedFeatures = new SupportedFeaturesImpl();
                            ((SupportedFeaturesImpl)this.supportedFeatures).decodeAll(ais);
                            break;
                        }
                        default: {
                            ais.advanceElement();
                            break;
                        }
                    }
                    break;
                }
                default: {
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num == 0) {
            throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse: Needs at least 1 parameter, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding InsertSubscriberDataResponse: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        int pos;
        if (this.teleserviceList != null && (this.teleserviceList.size() < 1 || this.teleserviceList.size() > 20)) {
            throw new MAPException("teleserviceList size must be from 1 to 20, found: " + this.teleserviceList.size());
        }
        if (this.bearerServiceList != null && (this.bearerServiceList.size() < 1 || this.bearerServiceList.size() > 50)) {
            throw new MAPException("bearerServiceList size must be from 1 to 50, found: " + this.bearerServiceList.size());
        }
        if (this.ssList != null && (this.ssList.size() < 1 || this.ssList.size() > 30)) {
            throw new MAPException("ssList size must be from 1 to 30, found: " + this.ssList.size());
        }
        if (this.teleserviceList != null) {
            try {
                asnOs.writeTag(2, false, 1);
                pos = asnOs.StartContentDefiniteLength();
                for (ExtTeleserviceCode extTeleserviceCode : this.teleserviceList) {
                    ((ExtTeleserviceCodeImpl)extTeleserviceCode).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding InsertSubscriberDataResponse.teleserviceList: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.bearerServiceList != null) {
            try {
                asnOs.writeTag(2, false, 2);
                pos = asnOs.StartContentDefiniteLength();
                for (ExtBearerServiceCode extBearerServiceCode : this.bearerServiceList) {
                    ((ExtBearerServiceCodeImpl)extBearerServiceCode).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding InsertSubscriberDataResponse.bearerServiceList: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.ssList != null) {
            try {
                asnOs.writeTag(2, false, 3);
                pos = asnOs.StartContentDefiniteLength();
                for (SSCode sSCode : this.ssList) {
                    ((SSCodeImpl)sSCode).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding InsertSubscriberDataResponse.ssList: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.odbGeneralData != null) {
            ((ODBGeneralDataImpl)this.odbGeneralData).encodeAll(asnOs, 2, 4);
        }
        if (this.mapProtocolVersion >= 2L && this.regionalSubscriptionResponse != null) {
            try {
                asnOs.writeInteger(2, 5, (long)this.regionalSubscriptionResponse.getCode());
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding InsertSubscriberDataResponse parameter regionalSubscriptionResponse", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("IOException while encoding InsertSubscriberDataResponse parameter regionalSubscriptionResponse", (Throwable)e);
            }
        }
        if (this.mapProtocolVersion >= 3L) {
            if (this.supportedCamelPhases != null) {
                ((SupportedCamelPhasesImpl)this.supportedCamelPhases).encodeAll(asnOs, 2, 6);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 7);
            }
            if (this.offeredCamel4CSIs != null) {
                ((OfferedCamel4CSIsImpl)this.offeredCamel4CSIs).encodeAll(asnOs, 2, 8);
            }
            if (this.supportedFeatures != null) {
                ((SupportedFeaturesImpl)this.supportedFeatures).encodeAll(asnOs, 2, 9);
            }
        }
    }

    public String toString() {
        boolean firstItem;
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.teleserviceList != null) {
            sb.append("teleserviceList=[");
            firstItem = true;
            for (ExtTeleserviceCode extTeleserviceCode : this.teleserviceList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(extTeleserviceCode.toString());
            }
            sb.append("], ");
        }
        if (this.bearerServiceList != null) {
            sb.append("bearerServiceList=[");
            firstItem = true;
            for (ExtBearerServiceCode extBearerServiceCode : this.bearerServiceList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(extBearerServiceCode.toString());
            }
            sb.append("], ");
        }
        if (this.ssList != null) {
            sb.append("ssList=[");
            firstItem = true;
            for (SSCode sSCode : this.ssList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(sSCode.toString());
            }
            sb.append("], ");
        }
        if (this.odbGeneralData != null) {
            sb.append("odbGeneralData=");
            sb.append(this.odbGeneralData.toString());
            sb.append(", ");
        }
        if (this.regionalSubscriptionResponse != null) {
            sb.append("regionalSubscriptionResponse=");
            sb.append(this.regionalSubscriptionResponse.toString());
            sb.append(", ");
        }
        if (this.supportedCamelPhases != null) {
            sb.append("supportedCamelPhases=");
            sb.append(this.supportedCamelPhases.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.offeredCamel4CSIs != null) {
            sb.append("offeredCamel4CSIs=");
            sb.append(this.offeredCamel4CSIs.toString());
            sb.append(", ");
        }
        if (this.supportedFeatures != null) {
            sb.append("supportedFeatures=");
            sb.append(this.supportedFeatures.toString());
            sb.append(", ");
        }
        sb.append("mapProtocolVersion=");
        sb.append(this.mapProtocolVersion);
        sb.append("]");
        return sb.toString();
    }
}

