/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSClientExternalID;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExternalClient;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.GMLCRestriction;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.NotificationToMSUser;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.lsm.LCSClientExternalIDImpl;

public class ExternalClientImpl
extends SequenceBase
implements ExternalClient {
    private static final int _TAG_gmlcRestriction = 0;
    private static final int _TAG_notificationToMSUser = 1;
    private static final int _TAG_extensionContainer = 2;
    private LCSClientExternalID clientIdentity;
    private GMLCRestriction gmlcRestriction;
    private NotificationToMSUser notificationToMSUser;
    private MAPExtensionContainer extensionContainer;

    public ExternalClientImpl() {
        super("ExternalClient");
    }

    public ExternalClientImpl(LCSClientExternalID clientIdentity, GMLCRestriction gmlcRestriction, NotificationToMSUser notificationToMSUser, MAPExtensionContainer extensionContainer) {
        super("ExternalClient");
        this.clientIdentity = clientIdentity;
        this.gmlcRestriction = gmlcRestriction;
        this.notificationToMSUser = notificationToMSUser;
        this.extensionContainer = extensionContainer;
    }

    public LCSClientExternalID getClientIdentity() {
        return this.clientIdentity;
    }

    public GMLCRestriction getGMLCRestriction() {
        return this.gmlcRestriction;
    }

    public NotificationToMSUser getNotificationToMSUser() {
        return this.notificationToMSUser;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.clientIdentity = null;
        this.gmlcRestriction = null;
        this.notificationToMSUser = null;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (tag != 16 || ais.getTagClass() != 0 || ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".clientIdentity: Parameter bad tag, tag class or primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.clientIdentity = new LCSClientExternalIDImpl();
                    ((LCSClientExternalIDImpl)this.clientIdentity).decodeAll(ais);
                    break;
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 2: {
                            switch (tag) {
                                case 0: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".gmlcRestriction: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    int code = (int)ais.readInteger();
                                    this.gmlcRestriction = GMLCRestriction.getInstance((int)code);
                                    break block0;
                                }
                                case 1: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".notificationToMSUser: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    int code1 = (int)ais.readInteger();
                                    this.notificationToMSUser = NotificationToMSUser.getInstance((int)code1);
                                    break block0;
                                }
                                case 2: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break block0;
                        }
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (this.clientIdentity == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament clientIdentity is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.clientIdentity == null) {
                throw new MAPException("Error while encoding" + this._PrimitiveName + ": clientIdentity must not be null");
            }
            try {
                ((LCSClientExternalIDImpl)this.clientIdentity).encodeAll(asnOs);
                if (this.gmlcRestriction != null) {
                    asnOs.writeInteger(2, 0, (long)this.gmlcRestriction.getCode());
                }
                if (this.notificationToMSUser != null) {
                    asnOs.writeInteger(2, 1, (long)this.notificationToMSUser.getCode());
                }
                if (this.extensionContainer != null) {
                    ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 2);
                }
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.clientIdentity != null) {
            sb.append("clientIdentity=");
            sb.append(this.clientIdentity.toString());
            sb.append(", ");
        }
        if (this.gmlcRestriction != null) {
            sb.append("gmlcRestriction=");
            sb.append(this.gmlcRestriction.toString());
            sb.append(", ");
        }
        if (this.notificationToMSUser != null) {
            sb.append("notificationToMSUser=");
            sb.append(this.notificationToMSUser.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

