/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.EPSSubscriptionDataWithdraw;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPSSubscriptionDataWithdrawImpl
implements EPSSubscriptionDataWithdraw,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "EPSSubscriptionDataWithdraw";
    private boolean allEpsData;
    private ArrayList<Integer> contextIdList;

    public EPSSubscriptionDataWithdrawImpl() {
    }

    public EPSSubscriptionDataWithdrawImpl(boolean allEpsData) {
        this.allEpsData = allEpsData;
    }

    public EPSSubscriptionDataWithdrawImpl(ArrayList<Integer> contextIdList) {
        this.contextIdList = contextIdList;
    }

    public boolean getAllEpsData() {
        return this.allEpsData;
    }

    public ArrayList<Integer> getContextIdList() {
        return this.contextIdList;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.allEpsData) {
            return 5;
        }
        if (this.contextIdList != null) {
            return 16;
        }
        throw new MAPException("Error encoding EPSSubscriptionDataWithdraw: no choices are selected");
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return this.allEpsData;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding EPSSubscriptionDataWithdraw: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding EPSSubscriptionDataWithdraw: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding EPSSubscriptionDataWithdraw: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding EPSSubscriptionDataWithdraw: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        block10: {
            block9: {
                this.allEpsData = false;
                this.contextIdList = null;
                if (ansIS.getTagClass() != 0) break block9;
                switch (ansIS.getTag()) {
                    case 5: {
                        if (!ansIS.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding allGPRSData choice: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ansIS.readNullData(length);
                        this.allEpsData = true;
                        break;
                    }
                    case 16: {
                        if (ansIS.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding contextIdList choice: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        AsnInputStream ais2 = ansIS.readSequenceStreamData(length);
                        this.contextIdList = new ArrayList();
                        while (ais2.available() != 0) {
                            int tag2 = ais2.readTag();
                            if (tag2 != 2 || ais2.getTagClass() != 0 || !ais2.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding EPSSubscriptionDataWithdraw: bad contextIdList element tag or tagClass or is not primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            Integer i1 = (int)ais2.readInteger();
                            this.contextIdList.add(i1);
                        }
                        if (this.contextIdList.size() < 1 || this.contextIdList.size() > 50) {
                            throw new MAPParsingComponentException("Error while decoding EPSSubscriptionDataWithdraw: Parameter contextIdList size must be from 1 to 50, found: " + this.contextIdList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        break block10;
                    }
                    default: {
                        throw new MAPParsingComponentException("Error while decoding EPSSubscriptionDataWithdraw: bad tag for Universal TagClass: " + ansIS.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
                break block10;
            }
            throw new MAPParsingComponentException("Error while decoding EPSSubscriptionDataWithdraw: bad tagClass: " + ansIS.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding EPSSubscriptionDataWithdraw: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        block10: {
            try {
                if (!this.allEpsData && this.contextIdList == null) {
                    throw new MAPException("Error while encoding the EPSSubscriptionDataWithdraw: no choice is defined");
                }
                if (this.allEpsData && this.contextIdList != null) {
                    throw new MAPException("Error while encoding the EPSSubscriptionDataWithdraw: both choice is defined");
                }
                if (this.contextIdList != null && (this.contextIdList.size() < 1 || this.contextIdList.size() > 50)) {
                    throw new MAPException("Error while encoding the EPSSubscriptionDataWithdrawParameter contextIdList size must be from 1 to 50, found: " + this.contextIdList.size());
                }
                if (this.allEpsData) {
                    asnOs.writeNullData();
                    break block10;
                }
                try {
                    for (Integer I1 : this.contextIdList) {
                        if (I1 == null) {
                            throw new MAPException("Error while encoding the EPSSubscriptionDataWithdraw: contextIdList must not contain null Integer value");
                        }
                        asnOs.writeInteger((long)I1.intValue());
                    }
                }
                catch (AsnException e) {
                    throw new MAPException("AsnException when encoding EPSSubscriptionDataWithdraw.contextIdList: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding EPSSubscriptionDataWithdraw: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.allEpsData) {
            sb.append("allEpsData, ");
        }
        if (this.contextIdList != null) {
            sb.append("contextIdList=[");
            for (Integer i1 : this.contextIdList) {
                sb.append(i1);
                sb.append(", ");
            }
            sb.append("], ");
        }
        sb.append("]");
        return sb.toString();
    }
}

