/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.DestinationNumberCriteria;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.MatchType;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationNumberCriteriaImpl
extends SequenceBase
implements DestinationNumberCriteria {
    private static final int _TAG_matchType = 0;
    private static final int _TAG_destinationNumberList = 1;
    private static final int _TAG_destinationNumberLengthList = 2;
    private MatchType matchType;
    private ArrayList<ISDNAddressString> destinationNumberList;
    private ArrayList<Integer> destinationNumberLengthList;

    public DestinationNumberCriteriaImpl() {
        super("DestinationNumberCriteria");
    }

    public DestinationNumberCriteriaImpl(MatchType matchType, ArrayList<ISDNAddressString> destinationNumberList, ArrayList<Integer> destinationNumberLengthList) {
        super("DestinationNumberCriteria");
        this.matchType = matchType;
        this.destinationNumberList = destinationNumberList;
        this.destinationNumberLengthList = destinationNumberLengthList;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public ArrayList<ISDNAddressString> getDestinationNumberList() {
        return this.destinationNumberList;
    }

    public ArrayList<Integer> getDestinationNumberLengthList() {
        return this.destinationNumberLengthList;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.matchType = null;
        this.destinationNumberList = null;
        this.destinationNumberLengthList = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block8: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".matchType: Parameter is not primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            int code = (int)ais.readInteger();
                            this.matchType = MatchType.getInstance((int)code);
                            break;
                        }
                        case 1: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".destinationNumberList: Parameter is primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            ISDNAddressStringImpl isdnAddressString = null;
                            AsnInputStream ais2 = ais.readSequenceStream();
                            this.destinationNumberList = new ArrayList();
                            while (ais2.available() != 0) {
                                int tag2 = ais2.readTag();
                                if (tag2 != 4 || ais2.getTagClass() != 0 || !ais2.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bad tag or tagClass or is primitive when decoding destinationNumberList", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                isdnAddressString = new ISDNAddressStringImpl();
                                isdnAddressString.decodeAll(ais2);
                                this.destinationNumberList.add(isdnAddressString);
                            }
                            if (this.destinationNumberList.size() >= 1 || this.destinationNumberList.size() <= 10) continue block8;
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter destinationNumberList size must be from 1 to 10, found: " + this.destinationNumberList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 2: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".destinationNumberLengthList: Parameter is primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            Integer integer = null;
                            AsnInputStream ais3 = ais.readSequenceStream();
                            this.destinationNumberLengthList = new ArrayList();
                            while (ais3.available() != 0) {
                                int tag3 = ais3.readTag();
                                if (tag3 != 2 || ais3.getTagClass() != 0 || !ais3.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bad tag or tagClass or is primitive when decoding destinationNumberLengthList", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                int destNumberLength = (int)ais3.readInteger();
                                integer = new Integer(destNumberLength);
                                this.destinationNumberLengthList.add(integer);
                            }
                            if (this.destinationNumberLengthList.size() >= 1 || this.destinationNumberLengthList.size() <= 3) continue block8;
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter destinationNumberLengthList size must be from 1 to 3, found: " + this.destinationNumberLengthList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        default: {
                            ais.advanceElement();
                            break;
                        }
                    }
                    continue block8;
                }
                default: {
                    ais.advanceElement();
                }
            }
        }
        if (this.matchType == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament matchType is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.destinationNumberList == null && this.destinationNumberLengthList == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ". Parament destinationNumberList or " + "destinationNumberLengthList or both should be present but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.matchType == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter matchType is not defined");
        }
        if (this.destinationNumberList == null && this.destinationNumberLengthList == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ". one or both of destinationNumberList and " + "destinationNumberLengthList needs to be present");
        }
        if (this.destinationNumberList != null && (this.destinationNumberList.size() < 1 || this.destinationNumberList.size() > 10)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter destinationNumberList size must be from 1 to 10, found: " + this.destinationNumberList.size());
        }
        if (this.destinationNumberLengthList != null && (this.destinationNumberLengthList.size() < 1 || this.destinationNumberLengthList.size() > 3)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter destinationNumberLengthList size must be from 1 to 3, found: " + this.destinationNumberList.size());
        }
        try {
            int pos;
            asnOs.writeInteger(2, 0, (long)this.matchType.getCode());
            if (this.destinationNumberList != null) {
                asnOs.writeTag(2, false, 1);
                pos = asnOs.StartContentDefiniteLength();
                for (ISDNAddressString isdnAddressString : this.destinationNumberList) {
                    ((ISDNAddressStringImpl)isdnAddressString).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
            if (this.destinationNumberLengthList != null) {
                asnOs.writeTag(2, false, 2);
                pos = asnOs.StartContentDefiniteLength();
                for (Integer integer : this.destinationNumberLengthList) {
                    asnOs.writeInteger((long)integer.intValue());
                }
                asnOs.FinalizeContent(pos);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        boolean firstItem;
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.matchType != null) {
            sb.append("matchType=");
            sb.append(this.matchType.toString());
            sb.append(", ");
        }
        if (this.destinationNumberList != null) {
            sb.append("destinationNumberList=[");
            firstItem = true;
            for (ISDNAddressString iSDNAddressString : this.destinationNumberList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(iSDNAddressString.toString());
            }
            sb.append("], ");
        }
        if (this.destinationNumberLengthList != null) {
            sb.append("destinationNumberLengthList=[");
            firstItem = true;
            for (Integer n : this.destinationNumberLengthList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(n.toString());
            }
            sb.append("] ");
        }
        sb.append("]");
        return sb.toString();
    }
}

