/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.CUGFeature;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.CUGInfo;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.CUGSubscription;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.CUGFeatureImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.CUGSubscriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUGInfoImpl
extends SequenceBase
implements CUGInfo {
    private static final int _TAG_extensionContainer = 0;
    private ArrayList<CUGSubscription> cugSubscriptionList = null;
    private ArrayList<CUGFeature> cugFeatureList = null;
    private MAPExtensionContainer extensionContainer = null;

    public CUGInfoImpl() {
        super("CUGInfo");
    }

    public CUGInfoImpl(ArrayList<CUGSubscription> cugSubscriptionList, ArrayList<CUGFeature> cugFeatureList, MAPExtensionContainer extensionContainer) {
        super("CUGInfo");
        this.cugSubscriptionList = cugSubscriptionList;
        this.cugFeatureList = cugFeatureList;
        this.extensionContainer = extensionContainer;
    }

    public ArrayList<CUGSubscription> getCUGSubscriptionList() {
        return this.cugSubscriptionList;
    }

    public ArrayList<CUGFeature> getCUGFeatureList() {
        return this.cugFeatureList;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        CUGSubscriptionImpl subscriptionItem = null;
        CUGFeatureImpl featureItem = null;
        this.cugSubscriptionList = null;
        this.cugFeatureList = null;
        this.extensionContainer = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || tag != 16 || ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".cugSubscriptionList: Bad tag class, tag or parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.cugSubscriptionList = new ArrayList();
                    AsnInputStream ais2a = ais.readSequenceStream();
                    while (ais2a.available() != 0) {
                        int tag2a = ais2a.readTag();
                        if (tag2a != 16 || ais2a.getTagClass() != 0 || ais2a.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bad cugSubscriptionList tag or tagClass or is primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        subscriptionItem = new CUGSubscriptionImpl();
                        subscriptionItem.decodeAll(ais2a);
                        this.cugSubscriptionList.add(subscriptionItem);
                    }
                    break;
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 2: {
                            switch (tag) {
                                case 0: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break block0;
                        }
                        case 0: {
                            switch (tag) {
                                case 16: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".cugFeatureList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.cugFeatureList = new ArrayList();
                                    AsnInputStream ais2 = ais.readSequenceStream();
                                    while (ais2.available() != 0) {
                                        int tag2 = ais2.readTag();
                                        if (tag2 != 16 || ais2.getTagClass() != 0 || ais2.isTagPrimitive()) {
                                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bad cugFeatureList tag or tagClass or is primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                                        }
                                        featureItem = new CUGFeatureImpl();
                                        featureItem.decodeAll(ais2);
                                        this.cugFeatureList.add(featureItem);
                                    }
                                    break;
                                }
                                default: {
                                    ais.advanceElement();
                                    break;
                                }
                            }
                            break block0;
                        }
                        default: {
                            ais.advanceElement();
                        }
                    }
                }
            }
            ++num;
        }
        if (this.cugSubscriptionList == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": cugSubscriptionList required.", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.cugSubscriptionList.size() > 10) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter cugSubscriptionList size must be from 0 to 10, found: " + this.cugSubscriptionList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.cugFeatureList.size() < 1 || this.cugFeatureList.size() > 32) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter cugFeatureList size must be from 1 to 32, found: " + this.cugFeatureList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.cugSubscriptionList == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": cugSubscriptionList required.");
        }
        if (this.cugSubscriptionList.size() > 10) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter cugSubscriptionList size must be from 0 to 10, found: " + this.cugSubscriptionList.size());
        }
        if (this.cugFeatureList != null && (this.cugFeatureList.size() < 1 || this.cugFeatureList.size() > 32)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter cugFeatureList size must be from 1 to 32, found: " + this.cugFeatureList.size());
        }
        try {
            asnOs.writeTag(0, false, 16);
            int posa = asnOs.StartContentDefiniteLength();
            for (CUGSubscription subscriptionItem : this.cugSubscriptionList) {
                ((CUGSubscriptionImpl)subscriptionItem).encodeAll(asnOs);
            }
            asnOs.FinalizeContent(posa);
            if (this.cugFeatureList != null) {
                asnOs.writeTag(0, false, 16);
                int posb = asnOs.StartContentDefiniteLength();
                for (CUGFeature featureItem : this.cugFeatureList) {
                    ((CUGFeatureImpl)featureItem).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(posb);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 0);
            }
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        boolean firstItem;
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.cugSubscriptionList != null) {
            sb.append("cugSubscriptionList=[");
            firstItem = true;
            for (CUGSubscription cUGSubscription : this.cugSubscriptionList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(cUGSubscription.toString());
            }
            sb.append("], ");
        }
        if (this.cugFeatureList != null) {
            sb.append("cugFeatureList=[");
            firstItem = true;
            for (CUGFeature cUGFeature : this.cugFeatureList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(cUGFeature.toString());
            }
            sb.append("], ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

