/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.AllocationRetentionPriority;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;

public class AllocationRetentionPriorityImpl
extends SequenceBase
implements AllocationRetentionPriority {
    private static final int _TAG_priorityLevel = 0;
    private static final int _TAG_preEmptionCapability = 1;
    private static final int _TAG_preEmptionVulnerability = 2;
    private static final int _TAG_extensionContainer = 3;
    private int priorityLevel = -1;
    private Boolean preEmptionCapability = null;
    private Boolean preEmptionVulnerability = null;
    private MAPExtensionContainer extensionContainer = null;

    public AllocationRetentionPriorityImpl() {
        super("AllocationRetentionPriority");
    }

    public AllocationRetentionPriorityImpl(int priorityLevel, Boolean preEmptionCapability, Boolean preEmptionVulnerability, MAPExtensionContainer extensionContainer) {
        super("AllocationRetentionPriority");
        this.priorityLevel = priorityLevel;
        this.preEmptionCapability = preEmptionCapability;
        this.preEmptionVulnerability = preEmptionVulnerability;
        this.extensionContainer = extensionContainer;
    }

    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    public Boolean getPreEmptionCapability() {
        return this.preEmptionCapability;
    }

    public Boolean getPreEmptionVulnerability() {
        return this.preEmptionVulnerability;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.priorityLevel = -1;
        this.preEmptionCapability = null;
        this.preEmptionVulnerability = null;
        this.extensionContainer = null;
        boolean isPriorityLevelSet = false;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (tag != 0 || ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".priorityLevel: Parameter bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.priorityLevel = (int)ais.readInteger();
                    isPriorityLevelSet = true;
                    break;
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 2: {
                            switch (tag) {
                                case 1: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".preEmptionCapability: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.preEmptionCapability = ais.readBoolean();
                                    break block0;
                                }
                                case 2: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".preEmptionVulnerability: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.preEmptionVulnerability = ais.readBoolean();
                                    break block0;
                                }
                                case 3: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break block0;
                        }
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (!isPriorityLevelSet) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament priorityLevel is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            asnOs.writeInteger(2, 0, (long)this.priorityLevel);
            if (this.preEmptionCapability != null && this.preEmptionCapability.equals(Boolean.TRUE)) {
                asnOs.writeBoolean(2, 1, this.preEmptionCapability.booleanValue());
            }
            if (this.preEmptionVulnerability != null) {
                asnOs.writeBoolean(2, 2, this.preEmptionVulnerability.booleanValue());
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 3);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        sb.append("priorityLevel=");
        sb.append(this.priorityLevel);
        sb.append(", ");
        if (this.preEmptionCapability != null) {
            sb.append("preEmptionCapability=");
            sb.append(this.preEmptionCapability.toString());
            sb.append(", ");
        }
        if (this.preEmptionVulnerability != null) {
            sb.append("preEmptionVulnerability=");
            sb.append(this.preEmptionVulnerability.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

