/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.UserCSGInformation;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.CSGId;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.CSGIdImpl;

public class UserCSGInformationImpl
implements UserCSGInformation,
MAPAsnPrimitive {
    private static final String _PrimitiveName = "UserCSGInformation";
    public static final int _ID_csgId = 0;
    public static final int _ID_extensionContainer = 1;
    public static final int _ID_accessMode = 2;
    public static final int _ID_cmi = 3;
    private static final String CSG_ID = "csgId";
    private static final String EXTENSION_CONTAINER = "extensionContainer";
    private static final String ACCESS_MODE = "accessMode";
    private static final String CMI = "cmi";
    private CSGId csgId;
    private MAPExtensionContainer extensionContainer;
    private Integer accessMode;
    private Integer cmi;
    protected static final XMLFormat<UserCSGInformationImpl> USER_CSG_INFORMATION_XML = new XMLFormat<UserCSGInformationImpl>(UserCSGInformationImpl.class){

        public void read(XMLFormat.InputElement xml, UserCSGInformationImpl userCSGInformation) throws XMLStreamException {
            userCSGInformation.csgId = (CSGId)xml.get(UserCSGInformationImpl.CSG_ID, CSGIdImpl.class);
            userCSGInformation.extensionContainer = (MAPExtensionContainer)xml.get(UserCSGInformationImpl.EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
            userCSGInformation.accessMode = (Integer)xml.get(UserCSGInformationImpl.ACCESS_MODE, Integer.class);
            userCSGInformation.cmi = (Integer)xml.get(UserCSGInformationImpl.CMI, Integer.class);
        }

        public void write(UserCSGInformationImpl userCSGInformation, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (userCSGInformation.csgId != null) {
                xml.add((Object)((CSGIdImpl)userCSGInformation.csgId), UserCSGInformationImpl.CSG_ID, CSGIdImpl.class);
            }
            if (userCSGInformation.extensionContainer != null) {
                xml.add((Object)((MAPExtensionContainerImpl)userCSGInformation.extensionContainer), UserCSGInformationImpl.EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
            }
            if (userCSGInformation.accessMode != null) {
                xml.add((Object)userCSGInformation.accessMode, UserCSGInformationImpl.ACCESS_MODE, Integer.class);
            }
            if (userCSGInformation.cmi != null) {
                xml.add((Object)userCSGInformation.cmi, UserCSGInformationImpl.CMI, Integer.class);
            }
        }
    };

    public UserCSGInformationImpl() {
    }

    public UserCSGInformationImpl(CSGId csgId, MAPExtensionContainer extensionContainer, Integer accessMode, Integer cmi) {
        this.csgId = csgId;
        this.extensionContainer = extensionContainer;
        this.accessMode = accessMode;
        this.cmi = cmi;
    }

    public CSGId getCSGId() {
        return this.csgId;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public Integer getAccessMode() {
        return this.accessMode;
    }

    public Integer getCmi() {
        return this.cmi;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding UserCSGInformation: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding UserCSGInformation: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding UserCSGInformation: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding UserCSGInformation: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.csgId = null;
        this.extensionContainer = null;
        this.accessMode = null;
        this.cmi = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding UserCSGInformation csgId: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.csgId = new CSGIdImpl();
                        ((CSGIdImpl)this.csgId).decodeAll(ais);
                        break;
                    }
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding UserCSGInformation extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        break;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding UserCSGInformation accessMode: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        byte[] buf = ais.readOctetString();
                        if (buf.length != 1) {
                            throw new MAPParsingComponentException("Error while decoding UserCSGInformation accessMode: Parameter length must be 1, found: " + buf.length, MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.accessMode = buf[0];
                        break;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding UserCSGInformation cmi: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        byte[] buf = ais.readOctetString();
                        if (buf.length != 1) {
                            throw new MAPParsingComponentException("Error while decoding UserCSGInformation cmi: Parameter length must be 1, found: " + buf.length, MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.cmi = buf[0];
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.csgId == null) {
            throw new MAPParsingComponentException("Error when decoding UserCSGInformation: csgId is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding UserCSGInformation: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.csgId == null) {
            throw new MAPException("Parametr csgId must not be null");
        }
        try {
            ((CSGIdImpl)this.csgId).encodeAll(asnOs, 2, 0);
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 1);
            }
            byte[] buf = new byte[1];
            if (this.accessMode != null) {
                buf[0] = (byte)this.accessMode.intValue();
                asnOs.writeOctetString(2, 2, buf);
            }
            if (this.cmi != null) {
                buf[0] = (byte)this.cmi.intValue();
                asnOs.writeOctetString(2, 3, buf);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding UserCSGInformation: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding UserCSGInformation: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LocationInformation [");
        if (this.csgId != null) {
            sb.append("csgId=");
            sb.append(this.csgId);
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer);
        }
        if (this.accessMode != null) {
            sb.append(", accessMode=");
            sb.append(this.accessMode);
        }
        if (this.cmi != null) {
            sb.append(", cmi=");
            sb.append(this.cmi);
        }
        sb.append("]");
        return sb.toString();
    }
}

