/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.authentication;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AuthenticationSetList;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.EpsAuthenticationSetList;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.SendAuthenticationInfoResponse;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.AuthenticationSetListImpl;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.EpsAuthenticationSetListImpl;

public class SendAuthenticationInfoResponseImpl
extends MobilityMessageImpl
implements SendAuthenticationInfoResponse {
    public static final int _TAG_General = 3;
    protected static final int _TAG_eps_AuthenticationSetList = 2;
    public static final String _PrimitiveName = "SendAuthenticationInfoResponse";
    private AuthenticationSetList authenticationSetList;
    private MAPExtensionContainer extensionContainer;
    private EpsAuthenticationSetList epsAuthenticationSetList;
    private long mapProtocolVersion;

    public SendAuthenticationInfoResponseImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public SendAuthenticationInfoResponseImpl(long mapProtocolVersion, AuthenticationSetList authenticationSetList, MAPExtensionContainer extensionContainer, EpsAuthenticationSetList epsAuthenticationSetList) {
        this.mapProtocolVersion = mapProtocolVersion;
        this.authenticationSetList = authenticationSetList;
        this.extensionContainer = extensionContainer;
        this.epsAuthenticationSetList = epsAuthenticationSetList;
        if (authenticationSetList != null) {
            ((AuthenticationSetListImpl)authenticationSetList).setMapProtocolVersion(mapProtocolVersion);
        }
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.sendAuthenticationInfo_Response;
    }

    public int getOperationCode() {
        return 56;
    }

    public AuthenticationSetList getAuthenticationSetList() {
        return this.authenticationSetList;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public EpsAuthenticationSetList getEpsAuthenticationSetList() {
        return this.epsAuthenticationSetList;
    }

    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    public int getTag() throws MAPException {
        if (this.mapProtocolVersion >= 3L) {
            return 3;
        }
        return 16;
    }

    public int getTagClass() {
        if (this.mapProtocolVersion >= 3L) {
            return 2;
        }
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendAuthenticationInfoResponse: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendAuthenticationInfoResponse: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendAuthenticationInfoResponse: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendAuthenticationInfoResponse: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.authenticationSetList = null;
        this.extensionContainer = null;
        this.epsAuthenticationSetList = null;
        if (this.mapProtocolVersion >= 3L) {
            AsnInputStream ais = ansIS.readSequenceStreamData(length);
            block7: while (ais.available() != 0) {
                int tag = ais.readTag();
                if (ais.getTagClass() == 2) {
                    switch (tag) {
                        case 0: 
                        case 1: {
                            this.authenticationSetList = new AuthenticationSetListImpl();
                            ((AuthenticationSetListImpl)this.authenticationSetList).decodeAll(ais);
                            continue block7;
                        }
                        case 2: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding SendAuthenticationInfoResponse.epsAuthenticationSetList: Parameter epsAuthenticationSetList is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.epsAuthenticationSetList = new EpsAuthenticationSetListImpl();
                            ((EpsAuthenticationSetListImpl)this.epsAuthenticationSetList).decodeAll(ais);
                            continue block7;
                        }
                    }
                    ais.advanceElement();
                    continue;
                }
                if (ais.getTagClass() == 0) {
                    switch (tag) {
                        case 16: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding SendAuthenticationInfoResponse.extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            continue block7;
                        }
                    }
                    ais.advanceElement();
                    continue;
                }
                ais.advanceElement();
            }
        } else {
            this.authenticationSetList = new AuthenticationSetListImpl();
            ((AuthenticationSetListImpl)this.authenticationSetList).decodeData(ansIS, length);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SendAuthenticationInfoResponse: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.mapProtocolVersion <= 2L) {
            if (this.authenticationSetList == null) {
                throw new MAPException("authenticationSetList must not be null for MAP Version2");
            }
            ((AuthenticationSetListImpl)this.authenticationSetList).encodeData(asnOs);
        } else {
            if (this.authenticationSetList == null && this.extensionContainer == null && this.epsAuthenticationSetList == null) {
                throw new MAPException("At least one parameter must not be null for MAP Version3");
            }
            if (this.authenticationSetList != null) {
                ((AuthenticationSetListImpl)this.authenticationSetList).encodeAll(asnOs);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
            if (this.epsAuthenticationSetList != null) {
                ((EpsAuthenticationSetListImpl)this.epsAuthenticationSetList).encodeAll(asnOs, 2, 2);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SendAuthenticationInfoResponse [");
        if (this.authenticationSetList != null) {
            sb.append("authenticationSetList [");
            sb.append(this.authenticationSetList.toString());
            sb.append("], ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer [");
            sb.append(this.extensionContainer.toString());
            sb.append("], ");
        }
        if (this.epsAuthenticationSetList != null) {
            sb.append("epsAuthenticationSetList [");
            sb.append(this.epsAuthenticationSetList.toString());
            sb.append("], ");
        }
        sb.append("]");
        return sb.toString();
    }
}

