/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.authentication;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.PlmnId;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.ReSynchronisationInfo;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.RequestingNodeType;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.SendAuthenticationInfoRequest;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.PlmnIdImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.ReSynchronisationInfoImpl;

public class SendAuthenticationInfoRequestImpl
extends MobilityMessageImpl
implements SendAuthenticationInfoRequest {
    protected static final int _TAG_imsi = 0;
    protected static final int _TAG_immediateResponsePreferred = 1;
    protected static final int _TAG_extensionContainer = 2;
    protected static final int _TAG_requestingNodeType = 3;
    protected static final int _TAG_requestingPLMNId = 4;
    protected static final int _TAG_numberOfRequestedAdditionalVectors = 5;
    protected static final int _TAG_additionalVectorsAreForEPS = 6;
    public static final String _PrimitiveName = "SendAuthenticationInfoRequest";
    private IMSI imsi;
    private int numberOfRequestedVectors;
    private boolean segmentationProhibited;
    private boolean immediateResponsePreferred;
    private ReSynchronisationInfo reSynchronisationInfo;
    private MAPExtensionContainer extensionContainer;
    private RequestingNodeType requestingNodeType;
    private PlmnId requestingPlmnId;
    private Integer numberOfRequestedAdditionalVectors;
    private boolean additionalVectorsAreForEPS;
    private long mapProtocolVersion;

    public SendAuthenticationInfoRequestImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public SendAuthenticationInfoRequestImpl(long mapProtocolVersion, IMSI imsi, int numberOfRequestedVectors, boolean segmentationProhibited, boolean immediateResponsePreferred, ReSynchronisationInfo reSynchronisationInfo, MAPExtensionContainer extensionContainer, RequestingNodeType requestingNodeType, PlmnId requestingPlmnId, Integer numberOfRequestedAdditionalVectors, boolean additionalVectorsAreForEPS) {
        this.mapProtocolVersion = mapProtocolVersion;
        this.imsi = imsi;
        this.numberOfRequestedVectors = numberOfRequestedVectors;
        this.segmentationProhibited = segmentationProhibited;
        this.immediateResponsePreferred = immediateResponsePreferred;
        this.reSynchronisationInfo = reSynchronisationInfo;
        this.extensionContainer = extensionContainer;
        this.requestingNodeType = requestingNodeType;
        this.requestingPlmnId = requestingPlmnId;
        this.numberOfRequestedAdditionalVectors = numberOfRequestedAdditionalVectors;
        this.additionalVectorsAreForEPS = additionalVectorsAreForEPS;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.sendAuthenticationInfo_Request;
    }

    public int getOperationCode() {
        return 56;
    }

    public IMSI getImsi() {
        return this.imsi;
    }

    public int getNumberOfRequestedVectors() {
        return this.numberOfRequestedVectors;
    }

    public boolean getSegmentationProhibited() {
        return this.segmentationProhibited;
    }

    public boolean getImmediateResponsePreferred() {
        return this.immediateResponsePreferred;
    }

    public ReSynchronisationInfo getReSynchronisationInfo() {
        return this.reSynchronisationInfo;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public RequestingNodeType getRequestingNodeType() {
        return this.requestingNodeType;
    }

    public PlmnId getRequestingPlmnId() {
        return this.requestingPlmnId;
    }

    public Integer getNumberOfRequestedAdditionalVectors() {
        return this.numberOfRequestedAdditionalVectors;
    }

    public boolean getAdditionalVectorsAreForEPS() {
        return this.additionalVectorsAreForEPS;
    }

    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    public int getTag() throws MAPException {
        if (this.mapProtocolVersion >= 3L) {
            return 16;
        }
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return this.mapProtocolVersion < 3L;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendAuthenticationInfoRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendAuthenticationInfoRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendAuthenticationInfoRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendAuthenticationInfoRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imsi = null;
        this.numberOfRequestedVectors = 0;
        this.segmentationProhibited = false;
        this.immediateResponsePreferred = false;
        this.reSynchronisationInfo = null;
        this.extensionContainer = null;
        this.requestingNodeType = null;
        this.requestingPlmnId = null;
        this.numberOfRequestedAdditionalVectors = null;
        this.additionalVectorsAreForEPS = false;
        if (this.mapProtocolVersion >= 3L) {
            AsnInputStream ais = ansIS.readSequenceStreamData(length);
            int num = 0;
            while (ais.available() != 0) {
                int tag = ais.readTag();
                block0 : switch (num) {
                    case 0: {
                        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 0) {
                            throw new MAPParsingComponentException("Error while decoding SendAuthenticationInfoRequest.imsi: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.imsi = new IMSIImpl();
                        ((IMSIImpl)this.imsi).decodeAll(ais);
                        break;
                    }
                    case 1: {
                        if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 2) {
                            throw new MAPParsingComponentException("Error while decoding SendAuthenticationInfoRequest.numberOfRequestedVectors: Parameter 1 bad tag class or tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.numberOfRequestedVectors = (int)ais.readInteger();
                        break;
                    }
                    default: {
                        if (ais.getTagClass() == 2) {
                            switch (tag) {
                                case 1: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendAuthenticationInfoRequest.immediateResponsePreferred: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    ais.readNull();
                                    this.immediateResponsePreferred = true;
                                    break block0;
                                }
                                case 2: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendAuthenticationInfoRequest.extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                                case 3: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendAuthenticationInfoRequest.requestingNodeType: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    int i1 = (int)ais.readInteger();
                                    this.requestingNodeType = RequestingNodeType.getInstance((int)i1);
                                    break block0;
                                }
                                case 4: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendAuthenticationInfoRequest.requestingPlmnId: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.requestingPlmnId = new PlmnIdImpl();
                                    ((PlmnIdImpl)this.requestingPlmnId).decodeAll(ais);
                                    break block0;
                                }
                                case 5: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendAuthenticationInfoRequest.numberOfRequestedAdditionalVectors: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.numberOfRequestedAdditionalVectors = (int)ais.readInteger();
                                    break block0;
                                }
                                case 6: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendAuthenticationInfoRequest.additionalVectorsAreForEPS: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    ais.readNull();
                                    this.additionalVectorsAreForEPS = true;
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break;
                        }
                        if (ais.getTagClass() == 0) {
                            switch (tag) {
                                case 5: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendAuthenticationInfoRequest.segmentationProhibited: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    ais.readNull();
                                    this.segmentationProhibited = true;
                                    break block0;
                                }
                                case 16: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendAuthenticationInfoRequest.re-synchronisationInfo: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.reSynchronisationInfo = new ReSynchronisationInfoImpl();
                                    ((ReSynchronisationInfoImpl)this.reSynchronisationInfo).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break;
                        }
                        ais.advanceElement();
                    }
                }
                ++num;
            }
            if (num < 2) {
                throw new MAPParsingComponentException("Error while decoding SendAuthenticationInfoRequest: Needs at least 2 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
            }
        } else {
            this.imsi = new IMSIImpl();
            ((IMSIImpl)this.imsi).decodeData(ansIS, length);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SendAuthenticationInfoRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.mapProtocolVersion <= 2L) {
            if (this.imsi == null) {
                throw new MAPException("Imsi must not be null for MAP Version2");
            }
            ((IMSIImpl)this.imsi).encodeData(asnOs);
        } else {
            try {
                if (this.imsi == null) {
                    throw new MAPException("IMSI parameter must not be null for MAP Version3");
                }
                ((IMSIImpl)this.imsi).encodeAll(asnOs, 2, 0);
                asnOs.writeInteger((long)this.numberOfRequestedVectors);
                if (this.segmentationProhibited) {
                    asnOs.writeNull();
                }
                if (this.immediateResponsePreferred) {
                    asnOs.writeNull(2, 1);
                }
                if (this.reSynchronisationInfo != null) {
                    ((ReSynchronisationInfoImpl)this.reSynchronisationInfo).encodeAll(asnOs);
                }
                if (this.extensionContainer != null) {
                    ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
                }
                if (this.requestingNodeType != null) {
                    asnOs.writeInteger(2, 3, (long)this.requestingNodeType.getCode());
                }
                if (this.requestingPlmnId != null) {
                    ((PlmnIdImpl)this.requestingPlmnId).encodeAll(asnOs, 2, 4);
                }
                if (this.numberOfRequestedAdditionalVectors != null) {
                    asnOs.writeInteger(2, 5, (long)this.numberOfRequestedAdditionalVectors.intValue());
                }
                if (this.additionalVectorsAreForEPS) {
                    asnOs.writeNull(2, 6);
                }
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding SendAuthenticationInfoRequest: " + e.getMessage(), (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding SendAuthenticationInfoRequest: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.imsi != null) {
            sb.append("imsi=");
            sb.append(this.imsi.toString());
            sb.append(", ");
        }
        sb.append("numberOfRequestedVectors=");
        sb.append(this.numberOfRequestedVectors);
        sb.append(", ");
        if (this.segmentationProhibited) {
            sb.append("segmentationProhibited, ");
        }
        if (this.immediateResponsePreferred) {
            sb.append("immediateResponsePreferred, ");
        }
        if (this.reSynchronisationInfo != null) {
            sb.append("reSynchronisationInfo=");
            sb.append(this.reSynchronisationInfo.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.requestingNodeType != null) {
            sb.append("requestingNodeType=");
            sb.append(this.requestingNodeType.toString());
            sb.append(", ");
        }
        if (this.requestingPlmnId != null) {
            sb.append("requestingPlmnId=");
            sb.append(this.requestingPlmnId.toString());
            sb.append(", ");
        }
        if (this.numberOfRequestedAdditionalVectors != null) {
            sb.append("numberOfRequestedAdditionalVectors=");
            sb.append(this.numberOfRequestedAdditionalVectors.toString());
            sb.append(", ");
        }
        if (this.additionalVectorsAreForEPS) {
            sb.append("additionalVectorsAreForEPS, ");
        }
        sb.append("mapProtocolVersion=");
        sb.append(this.mapProtocolVersion);
        sb.append("]");
        return sb.toString();
    }
}

