/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.PlmnId;
import org.mobicents.protocols.ss7.map.api.service.lsm.RANTechnology;
import org.mobicents.protocols.ss7.map.api.service.lsm.ReportingPLMN;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.PlmnIdImpl;

public class ReportingPLMNImpl
implements ReportingPLMN,
MAPAsnPrimitive {
    public static final int _ID_plmn_Id = 0;
    public static final int _ID_ran_Technology = 1;
    public static final int _ID_ran_PeriodicLocationSupport = 2;
    public static final String _PrimitiveName = "ReportingPLMN";
    private PlmnId plmnId;
    private RANTechnology ranTechnology;
    private boolean ranPeriodicLocationSupport;

    public ReportingPLMNImpl() {
    }

    public ReportingPLMNImpl(PlmnId plmnId, RANTechnology ranTechnology, boolean ranPeriodicLocationSupport) {
        this.plmnId = plmnId;
        this.ranTechnology = ranTechnology;
        this.ranPeriodicLocationSupport = ranPeriodicLocationSupport;
    }

    public PlmnId getPlmnId() {
        return this.plmnId;
    }

    public RANTechnology getRanTechnology() {
        return this.ranTechnology;
    }

    public boolean getRanPeriodicLocationSupport() {
        return this.ranPeriodicLocationSupport;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportingPLMN: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportingPLMN: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportingPLMN: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportingPLMN: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.plmnId = null;
        this.ranTechnology = null;
        this.ranPeriodicLocationSupport = false;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ReportingPLMN plmnId: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.plmnId = new PlmnIdImpl();
                        ((PlmnIdImpl)this.plmnId).decodeAll(ais);
                        break;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ReportingPLMN ranTechnology: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.ranTechnology = RANTechnology.getInstance((int)i1);
                        break;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ReportingPLMN ranPeriodicLocationSupport: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.ranPeriodicLocationSupport = true;
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.plmnId == null) {
            throw new MAPParsingComponentException("Error while decoding ReportingPLMN: Parament plmnId is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ReportingPLMN: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.plmnId == null) {
            throw new MAPException("plmnId parameter must not be null");
        }
        try {
            ((PlmnIdImpl)this.plmnId).encodeAll(asnOs, 2, 0);
            if (this.ranTechnology != null) {
                asnOs.writeInteger(2, 1, (long)this.ranTechnology.getCode());
            }
            if (this.ranPeriodicLocationSupport) {
                asnOs.writeNull(2, 2);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding ReportingPLMN: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ReportingPLMN: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.plmnId != null) {
            sb.append("plmnId=");
            sb.append(this.plmnId.toString());
        }
        if (this.ranTechnology != null) {
            sb.append(", ranTechnology=");
            sb.append(this.ranTechnology.toString());
        }
        if (this.ranPeriodicLocationSupport) {
            sb.append(", ranPeriodicLocationSupport");
        }
        sb.append("]");
        return sb.toString();
    }
}

