/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSQoS;
import org.mobicents.protocols.ss7.map.api.service.lsm.ResponseTime;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.lsm.ResponseTimeImpl;

public class LCSQoSImpl
implements LCSQoS,
MAPAsnPrimitive {
    private static final int _TAG_HORIZONTAL_ACCURACY = 0;
    private static final int _TAG_VERTICAL_COORDINATE_REQUEST = 1;
    private static final int _TAG_VERTICAL_ACCURACY = 2;
    private static final int _TAG_RESPONSE_TIME = 3;
    private static final int _TAG_EXTENSION_CONTAINER = 4;
    public static final String _PrimitiveName = "LCSQoS";
    private Integer horizontalAccuracy;
    private Integer verticalAccuracy;
    private boolean verticalCoordinateRequest;
    private ResponseTime responseTime;
    private MAPExtensionContainer extensionContainer;

    public LCSQoSImpl() {
    }

    public LCSQoSImpl(Integer horizontalAccuracy, Integer verticalAccuracy, boolean verticalCoordinateRequest, ResponseTime responseTime, MAPExtensionContainer extensionContainer) {
        this.horizontalAccuracy = horizontalAccuracy;
        this.verticalAccuracy = verticalAccuracy;
        this.verticalCoordinateRequest = verticalCoordinateRequest;
        this.responseTime = responseTime;
        this.extensionContainer = extensionContainer;
    }

    public Integer getHorizontalAccuracy() {
        return this.horizontalAccuracy;
    }

    public boolean getVerticalCoordinateRequest() {
        return this.verticalCoordinateRequest;
    }

    public Integer getVerticalAccuracy() {
        return this.verticalAccuracy;
    }

    public ResponseTime getResponseTime() {
        return this.responseTime;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LCSQoS: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LCSQoS: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LCSQoS: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LCSQoS: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        this.horizontalAccuracy = null;
        this.verticalAccuracy = null;
        this.verticalCoordinateRequest = false;
        this.responseTime = null;
        this.extensionContainer = null;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Decoding LCSQoS failed. Error while decoding horizontal-accuracy [0] Horizontal-Accuracy: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        byte[] buf = ais.readOctetString();
                        if (buf.length != 1) {
                            throw new MAPParsingComponentException("Decoding LCSQoS failed. Error while decoding horizontal-accuracy [0] Horizontal-Accuracy: the field length must be equal 1, found: " + buf.length, MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.horizontalAccuracy = new Integer(buf[0]);
                        break;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Decoding LCSQoS failed. Error while decoding verticalCoordinateRequest: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.verticalCoordinateRequest = true;
                        break;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Decoding LCSQoS failed. Error while decoding vertical-accuracy [2] Vertical-Accuracy: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        byte[] buf = ais.readOctetString();
                        if (buf.length != 1) {
                            throw new MAPParsingComponentException("Decoding LCSQoS failed. Error while decoding verticalAccuracy: the field length must be equal 1, found: " + buf.length, MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.verticalAccuracy = new Integer(buf[0]);
                        break;
                    }
                    case 3: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Decoding LCSQoS failed. Error while decoding responseTime [3] ResponseTime: is not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.responseTime = new ResponseTimeImpl();
                        ((ResponseTimeImpl)this.responseTime).decodeAll(ais);
                        break;
                    }
                    case 4: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Decoding LCSQoS failed. Error while decoding extensionContainer: is not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding LCSQoS: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.horizontalAccuracy != null) {
            try {
                asnOs.writeOctetString(2, 0, new byte[]{this.horizontalAccuracy.byteValue()});
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding parameter horizontalAccuracy: ", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding parameter horizontalAccuracy: ", (Throwable)e);
            }
        }
        if (this.verticalCoordinateRequest) {
            try {
                asnOs.writeNull(2, 1);
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding parameter verticalCoordinateRequest: ", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("IOException when encoding parameter verticalCoordinateRequest: ", (Throwable)e);
            }
        }
        if (this.verticalAccuracy != null) {
            try {
                asnOs.writeOctetString(2, 2, new byte[]{this.verticalAccuracy.byteValue()});
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding parameter verticalAccuracy: ", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding parameter verticalAccuracy: ", (Throwable)e);
            }
        }
        if (this.responseTime != null) {
            ((ResponseTimeImpl)this.responseTime).encodeAll(asnOs, 2, 3);
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 4);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.extensionContainer == null ? 0 : this.extensionContainer.hashCode());
        result = 31 * result + (this.horizontalAccuracy == null ? 0 : this.horizontalAccuracy.hashCode());
        result = 31 * result + (this.responseTime == null ? 0 : this.responseTime.hashCode());
        result = 31 * result + (this.verticalAccuracy == null ? 0 : this.verticalAccuracy.hashCode());
        result = 31 * result + (this.verticalCoordinateRequest ? 0 : 1);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LCSQoSImpl other = (LCSQoSImpl)obj;
        if (this.extensionContainer == null ? other.extensionContainer != null : !this.extensionContainer.equals(other.extensionContainer)) {
            return false;
        }
        if (this.horizontalAccuracy == null ? other.horizontalAccuracy != null : !this.horizontalAccuracy.equals(other.horizontalAccuracy)) {
            return false;
        }
        if (this.responseTime == null ? other.responseTime != null : !this.responseTime.equals(other.responseTime)) {
            return false;
        }
        if (this.verticalAccuracy == null ? other.verticalAccuracy != null : !this.verticalAccuracy.equals(other.verticalAccuracy)) {
            return false;
        }
        return this.verticalCoordinateRequest == other.verticalCoordinateRequest;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.horizontalAccuracy != null) {
            sb.append("horizontalAccuracy=");
            sb.append(this.horizontalAccuracy);
        }
        if (this.verticalAccuracy != null) {
            sb.append(", verticalAccuracy=");
            sb.append(this.verticalAccuracy.toString());
        }
        if (this.verticalCoordinateRequest) {
            sb.append(", verticalCoordinateRequest");
        }
        if (this.responseTime != null) {
            sb.append(", responseTime=");
            sb.append(this.responseTime.toString());
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

