/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.datacoding.CBSDataCodingScheme;
import org.mobicents.protocols.ss7.map.api.primitives.USSDString;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSCodeword;
import org.mobicents.protocols.ss7.map.datacoding.CBSDataCodingSchemeImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.USSDStringImpl;

public class LCSCodewordImpl
implements LCSCodeword,
MAPAsnPrimitive {
    private static final int _TAG_DATA_CODING_SCHEME = 0;
    private static final int _TAG_LCS_CODE_WORD_STRING = 1;
    public static final String _PrimitiveName = "LCSCodeword";
    private CBSDataCodingScheme dataCodingScheme;
    private USSDString lcsCodewordString;

    public LCSCodewordImpl() {
    }

    public LCSCodewordImpl(CBSDataCodingScheme dataCodingScheme, USSDString lcsCodewordString) {
        this.dataCodingScheme = dataCodingScheme;
        this.lcsCodewordString = lcsCodewordString;
    }

    public CBSDataCodingScheme getDataCodingScheme() {
        return this.dataCodingScheme;
    }

    public USSDString getLCSCodewordString() {
        return this.lcsCodewordString;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LCSCodeword: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LCSCodeword: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LCSCodeword: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LCSCodeword: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.dataCodingScheme = null;
        this.lcsCodewordString = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding LCSCodeword: Parameter 0[dataCodingScheme [0] USSD-DataCodingScheme] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int length1 = ais.readLength();
        this.dataCodingScheme = new CBSDataCodingSchemeImpl(ais.readOctetStringData(length1)[0]);
        tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 1) {
            throw new MAPParsingComponentException("Error while decoding LCSCodeword: Parameter 1[lcsCodewordString [1] LCSCodewordString] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.lcsCodewordString = new USSDStringImpl(this.dataCodingScheme);
        ((USSDStringImpl)this.lcsCodewordString).decodeAll(ais);
        while (ais.available() != 0) {
            switch (ais.readTag()) {
                default: 
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding LCSCodeword: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.lcsCodewordString == null) {
            throw new MAPException("lcsCodewordString must not be null");
        }
        try {
            asnOs.writeOctetString(2, 0, new byte[]{(byte)this.dataCodingScheme.getCode()});
            ((USSDStringImpl)this.lcsCodewordString).encodeAll(asnOs, 2, 1);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding LCSClientName", (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding LCSClientName", (Throwable)e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dataCodingScheme.getCode();
        result = 31 * result + (this.lcsCodewordString == null ? 0 : this.lcsCodewordString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LCSCodewordImpl other = (LCSCodewordImpl)obj;
        if (this.dataCodingScheme.getCode() != other.dataCodingScheme.getCode()) {
            return false;
        }
        return !(this.lcsCodewordString == null ? other.lcsCodewordString != null : !this.lcsCodewordString.equals(other.lcsCodewordString));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        sb.append("dataCodingScheme=");
        sb.append(this.dataCodingScheme);
        if (this.lcsCodewordString != null) {
            sb.append(", lcsCodewordString=");
            sb.append(this.lcsCodewordString.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

