/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSClientExternalID;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSClientID;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSClientInternalID;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSClientName;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSClientType;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSRequestorID;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.APN;
import org.mobicents.protocols.ss7.map.primitives.AddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.lsm.LCSClientExternalIDImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LCSClientNameImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LCSRequestorIDImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.APNImpl;

public class LCSClientIDImpl
implements LCSClientID,
MAPAsnPrimitive {
    private static final int _TAG_LCS_CLIENT_TYPE = 0;
    private static final int _TAG_LCS_CLIENT_EXTERNAL_ID = 1;
    private static final int _TAG_LCS_CLIENT_DIALED_BY_MS = 2;
    private static final int _TAG_LCS_CLIENT_INTERNAL_ID = 3;
    private static final int _TAG_LCS_CLIENT_NAME = 4;
    private static final int _TAG_LCS_APN = 5;
    private static final int _TAG_LCS_REQUESTOR_ID = 6;
    public static final String _PrimitiveName = "LCSClientID";
    private LCSClientType lcsClientType;
    private LCSClientExternalID lcsClientExternalID;
    private LCSClientInternalID lcsClientInternalID;
    private LCSClientName lcsClientName;
    private AddressString lcsClientDialedByMS;
    private APN lcsAPN;
    private LCSRequestorID lcsRequestorID;

    public LCSClientIDImpl(LCSClientType lcsClientType, LCSClientExternalID lcsClientExternalID, LCSClientInternalID lcsClientInternalID, LCSClientName lcsClientName, AddressString lcsClientDialedByMS, APN lcsAPN, LCSRequestorID lcsRequestorID) {
        this.lcsClientType = lcsClientType;
        this.lcsClientExternalID = lcsClientExternalID;
        this.lcsClientInternalID = lcsClientInternalID;
        this.lcsClientName = lcsClientName;
        this.lcsClientDialedByMS = lcsClientDialedByMS;
        this.lcsAPN = lcsAPN;
        this.lcsRequestorID = lcsRequestorID;
    }

    public LCSClientIDImpl() {
    }

    public LCSClientType getLCSClientType() {
        return this.lcsClientType;
    }

    public LCSClientExternalID getLCSClientExternalID() {
        return this.lcsClientExternalID;
    }

    public AddressString getLCSClientDialedByMS() {
        return this.lcsClientDialedByMS;
    }

    public LCSClientInternalID getLCSClientInternalID() {
        return this.lcsClientInternalID;
    }

    public LCSClientName getLCSClientName() {
        return this.lcsClientName;
    }

    public APN getLCSAPN() {
        return this.lcsAPN;
    }

    public LCSRequestorID getLCSRequestorID() {
        return this.lcsRequestorID;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LCSClientID: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LCSClientID: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LCSClientID: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LCSClientID: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.lcsClientType = null;
        this.lcsClientExternalID = null;
        this.lcsClientInternalID = null;
        this.lcsClientName = null;
        this.lcsClientDialedByMS = null;
        this.lcsAPN = null;
        this.lcsRequestorID = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding LCSClientID: Parameter 0[lcsClientType [0] LCSClientType] bad tag class, tag or not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int lcsCltType = (int)ais.readInteger();
        this.lcsClientType = LCSClientType.getLCSClientType((int)lcsCltType);
        block8: while (ais.available() != 0) {
            tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding LCSClientExternalID: not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.lcsClientExternalID = new LCSClientExternalIDImpl();
                        ((LCSClientExternalIDImpl)this.lcsClientExternalID).decodeAll(ais);
                        continue block8;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding lcsClientDialedByMS: not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.lcsClientDialedByMS = new AddressStringImpl();
                        ((AddressStringImpl)this.lcsClientDialedByMS).decodeAll(ais);
                        continue block8;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding lcsClientInternalID: not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.lcsClientInternalID = LCSClientInternalID.getLCSClientInternalID((int)i1);
                        continue block8;
                    }
                    case 4: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding lcsClientName: not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.lcsClientName = new LCSClientNameImpl();
                        ((LCSClientNameImpl)this.lcsClientName).decodeAll(ais);
                        continue block8;
                    }
                    case 5: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding lcsAPN: not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.lcsAPN = new APNImpl();
                        ((APNImpl)this.lcsAPN).decodeAll(ais);
                        continue block8;
                    }
                    case 6: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding lcsRequestorID: not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.lcsRequestorID = new LCSRequestorIDImpl();
                        ((LCSRequestorIDImpl)this.lcsRequestorID).decodeAll(ais);
                        continue block8;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding LCSClientID: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.lcsClientType == null) {
            throw new MAPException("lcsClientType must not be null");
        }
        try {
            asnOs.writeInteger(2, 0, (long)this.lcsClientType.getType());
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding parameter lcsClientType: ", (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding parameter lcsClientType: ", (Throwable)e);
        }
        if (this.lcsClientExternalID != null) {
            ((LCSClientExternalIDImpl)this.lcsClientExternalID).encodeAll(asnOs, 2, 1);
        }
        if (this.lcsClientDialedByMS != null) {
            ((AddressStringImpl)this.lcsClientDialedByMS).encodeAll(asnOs, 2, 2);
        }
        if (this.lcsClientInternalID != null) {
            try {
                asnOs.writeInteger(2, 3, (long)this.lcsClientInternalID.getId());
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding parameter lcsClientInternalID: ", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding parameter lcsClientInternalID: ", (Throwable)e);
            }
        }
        if (this.lcsClientName != null) {
            ((LCSClientNameImpl)this.lcsClientName).encodeAll(asnOs, 2, 4);
        }
        if (this.lcsAPN != null) {
            ((APNImpl)this.lcsAPN).encodeAll(asnOs, 2, 5);
        }
        if (this.lcsRequestorID != null) {
            ((LCSRequestorIDImpl)this.lcsRequestorID).encodeAll(asnOs, 2, 6);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lcsAPN == null ? 0 : this.lcsAPN.hashCode());
        result = 31 * result + (this.lcsClientDialedByMS == null ? 0 : this.lcsClientDialedByMS.hashCode());
        result = 31 * result + (this.lcsClientExternalID == null ? 0 : this.lcsClientExternalID.hashCode());
        result = 31 * result + (this.lcsClientInternalID == null ? 0 : this.lcsClientInternalID.hashCode());
        result = 31 * result + (this.lcsClientName == null ? 0 : this.lcsClientName.hashCode());
        result = 31 * result + (this.lcsClientType == null ? 0 : this.lcsClientType.hashCode());
        result = 31 * result + (this.lcsRequestorID == null ? 0 : this.lcsRequestorID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LCSClientIDImpl other = (LCSClientIDImpl)obj;
        if (this.lcsAPN == null ? other.lcsAPN != null : !this.lcsAPN.equals(other.lcsAPN)) {
            return false;
        }
        if (this.lcsClientDialedByMS == null ? other.lcsClientDialedByMS != null : !this.lcsClientDialedByMS.equals(other.lcsClientDialedByMS)) {
            return false;
        }
        if (this.lcsClientExternalID == null ? other.lcsClientExternalID != null : !this.lcsClientExternalID.equals(other.lcsClientExternalID)) {
            return false;
        }
        if (this.lcsClientInternalID != other.lcsClientInternalID) {
            return false;
        }
        if (this.lcsClientName == null ? other.lcsClientName != null : !this.lcsClientName.equals(other.lcsClientName)) {
            return false;
        }
        if (this.lcsClientType != other.lcsClientType) {
            return false;
        }
        return !(this.lcsRequestorID == null ? other.lcsRequestorID != null : !this.lcsRequestorID.equals(other.lcsRequestorID));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.lcsClientType != null) {
            sb.append("lcsClientType=");
            sb.append(this.lcsClientType.toString());
        }
        if (this.lcsClientExternalID != null) {
            sb.append(", lcsClientExternalID=");
            sb.append(this.lcsClientExternalID.toString());
        }
        if (this.lcsClientInternalID != null) {
            sb.append(", lcsClientInternalID=");
            sb.append(this.lcsClientInternalID.toString());
        }
        if (this.lcsClientName != null) {
            sb.append(", lcsClientName=");
            sb.append(this.lcsClientName.toString());
        }
        if (this.lcsClientDialedByMS != null) {
            sb.append(", lcsClientDialedByMS=");
            sb.append(this.lcsClientDialedByMS.toString());
        }
        if (this.lcsAPN != null) {
            sb.append(", lcsAPN=");
            sb.append(this.lcsAPN.toString());
        }
        if (this.lcsRequestorID != null) {
            sb.append(", lcsRequestorID=");
            sb.append(this.lcsRequestorID.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

