/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.service.lsm.ExtGeographicalInformation;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.TypeOfShape;
import org.mobicents.protocols.ss7.map.primitives.OctetStringBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.GeographicalInformationImpl;

public class ExtGeographicalInformationImpl
extends OctetStringBase
implements ExtGeographicalInformation {
    public ExtGeographicalInformationImpl() {
        super(1, 20, "ExtGeographicalInformation");
    }

    protected ExtGeographicalInformationImpl(int minLength, int maxLength, String _PrimitiveName) {
        super(minLength, maxLength, _PrimitiveName);
    }

    public ExtGeographicalInformationImpl(byte[] data) {
        super(1, 20, "ExtGeographicalInformation", data);
    }

    protected ExtGeographicalInformationImpl(int minLength, int maxLength, String _PrimitiveName, byte[] data) {
        super(minLength, maxLength, _PrimitiveName, data);
    }

    public ExtGeographicalInformationImpl(TypeOfShape typeOfShape, double latitude, double longitude, double uncertainty, double uncertaintySemiMajorAxis, double uncertaintySemiMinorAxis, double angleOfMajorAxis, int confidence, int altitude, double uncertaintyAltitude, int innerRadius, double uncertaintyRadius, double offsetAngle, double includedAngle) throws MAPException {
        super(1, 20, "ExtGeographicalInformation");
        this.initData(typeOfShape, latitude, longitude, uncertainty, uncertaintySemiMajorAxis, uncertaintySemiMinorAxis, angleOfMajorAxis, confidence, altitude, uncertaintyAltitude, innerRadius, uncertaintyRadius, offsetAngle, includedAngle);
    }

    protected void initData(TypeOfShape typeOfShape, double latitude, double longitude, double uncertainty, double uncertaintySemiMajorAxis, double uncertaintySemiMinorAxis, double angleOfMajorAxis, int confidence, int altitude, double uncertaintyAltitude, int innerRadius, double uncertaintyRadius, double offsetAngle, double includedAngle) throws MAPException {
        if (typeOfShape == null) {
            throw new MAPException("typeOfShape parameter is null");
        }
        switch (typeOfShape) {
            case EllipsoidPointWithUncertaintyCircle: {
                this.initData(8, typeOfShape, latitude, longitude);
                this.data[7] = (byte)GeographicalInformationImpl.encodeUncertainty(uncertainty);
                break;
            }
            case EllipsoidPointWithUncertaintyEllipse: {
                this.initData(11, typeOfShape, latitude, longitude);
                this.data[7] = (byte)GeographicalInformationImpl.encodeUncertainty(uncertaintySemiMajorAxis);
                this.data[8] = (byte)GeographicalInformationImpl.encodeUncertainty(uncertaintySemiMinorAxis);
                this.data[9] = (byte)(angleOfMajorAxis / 2.0);
                this.data[10] = (byte)confidence;
                break;
            }
            case EllipsoidPointWithAltitudeAndUncertaintyEllipsoid: {
                this.initData(14, typeOfShape, latitude, longitude);
                boolean negativeSign = false;
                if (altitude < 0) {
                    negativeSign = true;
                    altitude = -altitude;
                }
                if (altitude > Short.MAX_VALUE) {
                    altitude = Short.MAX_VALUE;
                }
                if (negativeSign) {
                    altitude |= 0x8000;
                }
                this.data[7] = (byte)((altitude & 0xFF00) >> 8);
                this.data[8] = (byte)(altitude & 0xFF);
                this.data[9] = (byte)GeographicalInformationImpl.encodeUncertainty(uncertaintySemiMajorAxis);
                this.data[10] = (byte)GeographicalInformationImpl.encodeUncertainty(uncertaintySemiMinorAxis);
                this.data[11] = (byte)(angleOfMajorAxis / 2.0);
                this.data[12] = (byte)GeographicalInformationImpl.encodeUncertainty(uncertaintyAltitude);
                this.data[13] = (byte)confidence;
                break;
            }
            case EllipsoidArc: {
                this.initData(13, typeOfShape, latitude, longitude);
                if (innerRadius > Short.MAX_VALUE) {
                    innerRadius = Short.MAX_VALUE;
                }
                this.data[7] = (byte)((innerRadius & 0xFF00) >> 8);
                this.data[8] = (byte)(innerRadius & 0xFF);
                this.data[9] = (byte)GeographicalInformationImpl.encodeUncertainty(uncertaintyRadius);
                this.data[10] = (byte)(offsetAngle / 2.0);
                this.data[11] = (byte)(includedAngle / 2.0);
                this.data[12] = (byte)confidence;
                break;
            }
            case EllipsoidPoint: {
                this.initData(7, typeOfShape, latitude, longitude);
                break;
            }
            default: {
                throw new MAPException("typeOfShape parameter has bad value");
            }
        }
    }

    private void initData(int len, TypeOfShape typeOfShape, double latitude, double longitude) {
        this.data = new byte[len];
        this.data[0] = (byte)(typeOfShape.getCode() << 4);
        GeographicalInformationImpl.encodeLatitude(this.data, 1, latitude);
        GeographicalInformationImpl.encodeLongitude(this.data, 4, longitude);
    }

    public byte[] getData() {
        return this.data;
    }

    public TypeOfShape getTypeOfShape() {
        if (this.data == null || this.data.length < 1) {
            return null;
        }
        return TypeOfShape.getInstance((int)((this.data[0] & 0xFF) >> 4));
    }

    public double getLatitude() {
        if (this.data == null || this.data.length < 7) {
            return 0.0;
        }
        return GeographicalInformationImpl.decodeLatitude(this.data, 1);
    }

    public double getLongitude() {
        if (this.data == null || this.data.length < 7) {
            return 0.0;
        }
        return GeographicalInformationImpl.decodeLongitude(this.data, 4);
    }

    public double getUncertainty() {
        if (this.getTypeOfShape() != TypeOfShape.EllipsoidPointWithUncertaintyCircle || this.data == null || this.data.length != 8) {
            return 0.0;
        }
        return GeographicalInformationImpl.decodeUncertainty(this.data[7]);
    }

    public double getUncertaintySemiMajorAxis() {
        TypeOfShape typeOfShape = this.getTypeOfShape();
        if (typeOfShape != null) {
            switch (typeOfShape) {
                case EllipsoidPointWithUncertaintyEllipse: {
                    if (this.data == null || this.data.length != 11) {
                        return 0.0;
                    }
                    return GeographicalInformationImpl.decodeUncertainty(this.data[7]);
                }
                case EllipsoidPointWithAltitudeAndUncertaintyEllipsoid: {
                    if (this.data == null || this.data.length != 14) {
                        return 0.0;
                    }
                    return GeographicalInformationImpl.decodeUncertainty(this.data[9]);
                }
            }
        }
        return 0.0;
    }

    public double getUncertaintySemiMinorAxis() {
        TypeOfShape typeOfShape = this.getTypeOfShape();
        if (typeOfShape != null) {
            switch (typeOfShape) {
                case EllipsoidPointWithUncertaintyEllipse: {
                    if (this.data == null || this.data.length != 11) {
                        return 0.0;
                    }
                    return GeographicalInformationImpl.decodeUncertainty(this.data[8]);
                }
                case EllipsoidPointWithAltitudeAndUncertaintyEllipsoid: {
                    if (this.data == null || this.data.length != 14) {
                        return 0.0;
                    }
                    return GeographicalInformationImpl.decodeUncertainty(this.data[10]);
                }
            }
        }
        return 0.0;
    }

    public double getAngleOfMajorAxis() {
        TypeOfShape typeOfShape = this.getTypeOfShape();
        if (typeOfShape != null) {
            switch (typeOfShape) {
                case EllipsoidPointWithUncertaintyEllipse: {
                    if (this.data == null || this.data.length != 11) {
                        return 0.0;
                    }
                    return (this.data[9] & 0xFF) * 2;
                }
                case EllipsoidPointWithAltitudeAndUncertaintyEllipsoid: {
                    if (this.data == null || this.data.length != 14) {
                        return 0.0;
                    }
                    return (this.data[11] & 0xFF) * 2;
                }
            }
        }
        return 0.0;
    }

    public int getConfidence() {
        TypeOfShape typeOfShape = this.getTypeOfShape();
        if (typeOfShape != null) {
            switch (typeOfShape) {
                case EllipsoidPointWithUncertaintyEllipse: {
                    if (this.data == null || this.data.length != 11) {
                        return 0;
                    }
                    return this.data[10];
                }
                case EllipsoidPointWithAltitudeAndUncertaintyEllipsoid: {
                    if (this.data == null || this.data.length != 14) {
                        return 0;
                    }
                    return this.data[13];
                }
                case EllipsoidArc: {
                    if (this.data == null || this.data.length != 13) {
                        return 0;
                    }
                    return this.data[12];
                }
            }
        }
        return 0;
    }

    public int getAltitude() {
        if (this.getTypeOfShape() != TypeOfShape.EllipsoidPointWithAltitudeAndUncertaintyEllipsoid || this.data == null || this.data.length != 14) {
            return 0;
        }
        int i1 = ((this.data[7] & 0xFF) << 8) + (this.data[8] & 0xFF);
        int sign = 1;
        if ((i1 & 0x8000) != 0) {
            sign = -1;
            i1 &= Short.MAX_VALUE;
        }
        return i1 * sign;
    }

    public double getUncertaintyAltitude() {
        if (this.getTypeOfShape() != TypeOfShape.EllipsoidPointWithAltitudeAndUncertaintyEllipsoid || this.data == null || this.data.length != 14) {
            return 0.0;
        }
        return GeographicalInformationImpl.decodeUncertainty(this.data[12]);
    }

    public int getInnerRadius() {
        if (this.getTypeOfShape() != TypeOfShape.EllipsoidArc || this.data == null || this.data.length != 13) {
            return 0;
        }
        int i1 = ((this.data[7] & 0xFF) << 8) + (this.data[8] & 0xFF);
        return i1;
    }

    public double getUncertaintyRadius() {
        if (this.getTypeOfShape() != TypeOfShape.EllipsoidArc || this.data == null || this.data.length != 13) {
            return 0.0;
        }
        return GeographicalInformationImpl.decodeUncertainty(this.data[9]);
    }

    public double getOffsetAngle() {
        if (this.getTypeOfShape() != TypeOfShape.EllipsoidArc || this.data == null || this.data.length != 13) {
            return 0.0;
        }
        return (this.data[10] & 0xFF) * 2;
    }

    public double getIncludedAngle() {
        if (this.getTypeOfShape() != TypeOfShape.EllipsoidArc || this.data == null || this.data.length != 13) {
            return 0.0;
        }
        return (this.data[11] & 0xFF) * 2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        sb.append("TypeOfShape=");
        sb.append(this.getTypeOfShape());
        sb.append(", Latitude=");
        sb.append(this.getLatitude());
        sb.append(", Longitude=");
        sb.append(this.getLongitude());
        if (this.getTypeOfShape() == TypeOfShape.EllipsoidPointWithUncertaintyCircle) {
            sb.append(", Uncertainty=");
            sb.append(this.getUncertainty());
        }
        if (this.getTypeOfShape() == TypeOfShape.EllipsoidPointWithUncertaintyEllipse || this.getTypeOfShape() == TypeOfShape.EllipsoidPointWithAltitudeAndUncertaintyEllipsoid) {
            sb.append(", UncertaintySemiMajorAxis=");
            sb.append(this.getUncertaintySemiMajorAxis());
            sb.append(", UncertaintySemiMinorAxis=");
            sb.append(this.getUncertaintySemiMinorAxis());
            sb.append(", AngleOfMajorAxis=");
            sb.append(this.getAngleOfMajorAxis());
        }
        if (this.getTypeOfShape() == TypeOfShape.EllipsoidPointWithAltitudeAndUncertaintyEllipsoid) {
            sb.append(", Altitude=");
            sb.append(this.getAltitude());
            sb.append(", UncertaintyAltitude=");
            sb.append(this.getUncertaintyAltitude());
        }
        if (this.getTypeOfShape() == TypeOfShape.EllipsoidArc) {
            sb.append(", InnerRadius=");
            sb.append(this.getInnerRadius());
            sb.append(", UncertaintyRadius=");
            sb.append(this.getUncertaintyRadius());
            sb.append(", OffsetAngle=");
            sb.append(this.getOffsetAngle());
            sb.append(", IncludedAngle=");
            sb.append(this.getIncludedAngle());
        }
        if (this.getTypeOfShape() == TypeOfShape.EllipsoidPointWithUncertaintyEllipse || this.getTypeOfShape() == TypeOfShape.EllipsoidPointWithAltitudeAndUncertaintyEllipsoid || this.getTypeOfShape() == TypeOfShape.EllipsoidArc) {
            sb.append(", Confidence=");
            sb.append(this.getConfidence());
        }
        sb.append("]");
        return sb.toString();
    }
}

