/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.callhandling;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.callhandling.ProvideRoamingNumberResponse;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.callhandling.CallHandlingMessageImpl;

public class ProvideRoamingNumberResponseImpl
extends CallHandlingMessageImpl
implements ProvideRoamingNumberResponse {
    public ISDNAddressString roamingNumber;
    public MAPExtensionContainer extensionContainer;
    public boolean releaseResourcesSupported;
    public ISDNAddressString vmscAddress;
    private long mapProtocolVersion;
    public static final String _PrimitiveName = "ProvideRoamingNumberResponse";

    public ProvideRoamingNumberResponseImpl(ISDNAddressString roamingNumber, MAPExtensionContainer extensionContainer, boolean releaseResourcesSupported, ISDNAddressString vmscAddress, long mapProtocolVersion) {
        this.roamingNumber = roamingNumber;
        this.extensionContainer = extensionContainer;
        this.releaseResourcesSupported = releaseResourcesSupported;
        this.vmscAddress = vmscAddress;
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public ProvideRoamingNumberResponseImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.privideRoamingNumber_Response;
    }

    public int getOperationCode() {
        return 4;
    }

    public int getTag() throws MAPException {
        if (this.mapProtocolVersion >= 3L) {
            return 16;
        }
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return this.mapProtocolVersion < 3L;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MAPParsingComponentException("IOException when decoding ProvideRoamingNumberResponse: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            e.printStackTrace();
            throw new MAPParsingComponentException("AsnException when decoding ProvideRoamingNumberResponse: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MAPParsingComponentException("AsnException when decoding ProvideRoamingNumberResponse: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MAPParsingComponentException("IOException when decoding ProvideRoamingNumberResponse: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            e.printStackTrace();
            throw new MAPParsingComponentException("AsnException when decoding ProvideRoamingNumberResponse: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.roamingNumber = null;
        this.extensionContainer = null;
        this.releaseResourcesSupported = false;
        this.vmscAddress = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        if (this.mapProtocolVersion >= 3L) {
            int num = 0;
            while (ais.available() != 0) {
                int tag = ais.readTag();
                if (num == 0) {
                    if (ais.getTagClass() != 0 && tag != 4 && !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding  ProvideRoamingNumberResponse .roamingNumber: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.roamingNumber = new ISDNAddressStringImpl();
                    ((ISDNAddressStringImpl)this.roamingNumber).decodeAll(ais);
                    ++num;
                    continue;
                }
                if (ais.getTagClass() == 0) {
                    if (tag == 4) {
                        this.vmscAddress = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.vmscAddress).decodeAll(ais);
                        continue;
                    }
                    if (tag == 16) {
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue;
                    }
                    if (tag == 5) {
                        ais.readNull();
                        this.releaseResourcesSupported = true;
                        continue;
                    }
                    ais.advanceElement();
                    continue;
                }
                ais.advanceElement();
            }
        } else {
            this.roamingNumber = new ISDNAddressStringImpl();
            ((ISDNAddressStringImpl)this.roamingNumber).decodeData(ais, length);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        try {
            this.encodeAll(asnOs, this.getTagClass(), this.getTag());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MAPException((Throwable)e);
        }
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ProvideRoamingNumberResponse : " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.roamingNumber == null) {
            throw new MAPException("roamingNumber parameter must not be null");
        }
        try {
            if (this.mapProtocolVersion >= 3L) {
                ((ISDNAddressStringImpl)this.roamingNumber).encodeAll(asnOs);
                if (this.extensionContainer != null) {
                    ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
                }
                if (this.releaseResourcesSupported) {
                    asnOs.writeNull();
                }
                if (this.vmscAddress != null) {
                    ((ISDNAddressStringImpl)this.vmscAddress).encodeAll(asnOs);
                }
            } else {
                ((ISDNAddressStringImpl)this.roamingNumber).encodeData(asnOs);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding ProvideRoamingNumberResponse " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ProvideRoamingNumberResponse " + e.getMessage(), (Throwable)e);
        }
    }

    public ISDNAddressString getRoamingNumber() {
        return this.roamingNumber;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public boolean getReleaseResourcesSupported() {
        return this.releaseResourcesSupported;
    }

    public ISDNAddressString getVmscAddress() {
        return this.vmscAddress;
    }

    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.roamingNumber != null) {
            sb.append("roamingNumber=");
            sb.append(this.roamingNumber.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.releaseResourcesSupported) {
            sb.append("releaseResourcesSupported, ");
        }
        if (this.vmscAddress != null) {
            sb.append("vmscAddress=");
            sb.append(this.vmscAddress.toString());
            sb.append(", ");
        }
        sb.append("mapProtocolVersion=");
        sb.append(this.mapProtocolVersion);
        sb.append("]");
        return sb.toString();
    }
}

