/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public abstract class OctetStringLength1Base
implements MAPAsnPrimitive {
    protected int data;
    protected String _PrimitiveName;

    public OctetStringLength1Base(String _PrimitiveName) {
        this._PrimitiveName = _PrimitiveName;
    }

    public OctetStringLength1Base(String _PrimitiveName, int data) {
        this(_PrimitiveName);
        this.data = data;
    }

    public int getTag() throws MAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException {
        if (length != 1) {
            throw new MAPParsingComponentException("Error decoding " + this._PrimitiveName + ": the field must contain 1 octet. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.data = ansIS.read() & 0xFF;
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        asnOs.write(this.data);
    }

    public int hashCode() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OctetStringLength1Base other = (OctetStringLength1Base)obj;
        return this.data == other.data;
    }

    public String toString() {
        return this._PrimitiveName + " [Data=" + this.data + "]";
    }
}

