/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.primitives.NAEACIC;
import org.mobicents.protocols.ss7.map.api.primitives.NetworkIdentificationPlanValue;
import org.mobicents.protocols.ss7.map.api.primitives.NetworkIdentificationTypeValue;
import org.mobicents.protocols.ss7.map.primitives.OctetStringBase;
import org.mobicents.protocols.ss7.map.primitives.TbcdString;

public class NAEACICImpl
extends OctetStringBase
implements NAEACIC {
    protected static final int NETWORK_IND_PLAN_MASK = 15;
    protected static final int NETWORK_IND_TYPE_MASK = 112;
    protected static final int THREE_OCTET_CARRIER_CODE_MASK = 15;

    public NAEACICImpl() {
        super(3, 3, "NAEACIC");
    }

    public NAEACICImpl(byte[] data) {
        super(3, 3, "NAEACIC", data);
    }

    public NAEACICImpl(String carrierCode, NetworkIdentificationPlanValue networkIdentificationPlanValue, NetworkIdentificationTypeValue networkIdentificationTypeValue) throws MAPException {
        super(3, 3, "NAEACIC");
        this.setParameters(carrierCode, networkIdentificationPlanValue, networkIdentificationTypeValue);
    }

    public byte[] getData() {
        return this.data;
    }

    public String getCarrierCode() {
        if (this.data == null || this.data.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream stm = new ByteArrayInputStream(this.data);
            stm.read();
            String address = TbcdString.decodeString(stm, this.data.length - 1);
            if (address.length() == 4 && this.getNetworkIdentificationPlanValue().equals((Object)NetworkIdentificationPlanValue.threeDigitCarrierIdentification)) {
                return address.substring(0, 3);
            }
            return address;
        }
        catch (MAPParsingComponentException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public NetworkIdentificationPlanValue getNetworkIdentificationPlanValue() {
        if (this.data == null || this.data.length == 0) {
            return null;
        }
        byte planValue = this.data[0];
        return NetworkIdentificationPlanValue.getInstance((int)(planValue & 0xF));
    }

    public NetworkIdentificationTypeValue getNetworkIdentificationTypeValue() {
        if (this.data == null || this.data.length == 0) {
            return null;
        }
        int typeValue = this.data[0];
        typeValue = (typeValue & 0x70) >> 4;
        return NetworkIdentificationTypeValue.getInstance((int)typeValue);
    }

    private void setParameters(String carrierCode, NetworkIdentificationPlanValue networkIdentificationPlanValue, NetworkIdentificationTypeValue networkIdentificationTypeValue) throws MAPException {
        if (carrierCode == null || networkIdentificationPlanValue == null || networkIdentificationTypeValue == null) {
            throw new MAPException("Error when encoding " + this._PrimitiveName + ": carrierCode, networkIdentificationPlanValue or networkIdentificationTypeValue is empty");
        }
        if (carrierCode.length() != 3 && carrierCode.length() != 4) {
            throw new MAPException("Error when encoding " + this._PrimitiveName + ": carrierCode lenght should be 3 or 4");
        }
        ByteArrayOutputStream stm = new ByteArrayOutputStream();
        int octOne = 0;
        octOne |= networkIdentificationTypeValue.getCode() << 4;
        stm.write(octOne |= networkIdentificationPlanValue.getCode());
        try {
            TbcdString.encodeString(stm, carrierCode);
        }
        catch (MAPException e) {
            throw new MAPException((Throwable)e);
        }
        this.data = stm.toByteArray();
        if (carrierCode.length() == 3) {
            this.data[2] = (byte)(this.data[2] & 0xF);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.getNetworkIdentificationPlanValue() != null) {
            sb.append("NetworkIdentificationPlanValue=");
            sb.append(this.getNetworkIdentificationPlanValue());
        }
        if (this.getNetworkIdentificationTypeValue() != null) {
            sb.append(", NetworkIdentificationTypeValue=");
            sb.append(this.getNetworkIdentificationTypeValue());
        }
        if (this.getCarrierCode() != null) {
            sb.append(", CarrierCode=");
            sb.append(this.getCarrierCode());
        }
        sb.append("]");
        return sb.toString();
    }
}

