/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.primitives.GlobalCellId;
import org.mobicents.protocols.ss7.map.primitives.OctetStringBase;
import org.mobicents.protocols.ss7.map.primitives.TbcdString;

public class GlobalCellIdImpl
extends OctetStringBase
implements GlobalCellId {
    private static final String MCC = "mcc";
    private static final String MNC = "mnc";
    private static final String LAC = "lac";
    private static final String CELL_ID = "cellId";
    private static final int DEFAULT_INT_VALUE = 0;
    protected static final XMLFormat<GlobalCellIdImpl> GLOBAL_CELL_ID_XML = new XMLFormat<GlobalCellIdImpl>(GlobalCellIdImpl.class){

        public void read(XMLFormat.InputElement xml, GlobalCellIdImpl globalCellId) throws XMLStreamException {
            int mcc = xml.getAttribute(GlobalCellIdImpl.MCC, 0);
            int mnc = xml.getAttribute(GlobalCellIdImpl.MNC, 0);
            int lac = xml.getAttribute(GlobalCellIdImpl.LAC, 0);
            int cellId = xml.getAttribute(GlobalCellIdImpl.CELL_ID, 0);
            try {
                globalCellId.setData(mcc, mnc, lac, cellId);
            }
            catch (MAPException e) {
                throw new XMLStreamException("MAPException when deserializing GlobalCellId", (Throwable)e);
            }
        }

        public void write(GlobalCellIdImpl globalCellId, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                xml.setAttribute(GlobalCellIdImpl.MCC, globalCellId.getMcc());
                xml.setAttribute(GlobalCellIdImpl.MNC, globalCellId.getMnc());
                xml.setAttribute(GlobalCellIdImpl.LAC, globalCellId.getLac());
                xml.setAttribute(GlobalCellIdImpl.CELL_ID, globalCellId.getCellId());
            }
            catch (MAPException e) {
                throw new XMLStreamException("MAPException when serializing GlobalCellId", (Throwable)e);
            }
        }
    };

    public GlobalCellIdImpl() {
        super(5, 7, "GlobalCellId");
    }

    public GlobalCellIdImpl(byte[] data) {
        super(5, 7, "GlobalCellId", data);
    }

    public GlobalCellIdImpl(int mcc, int mnc, int lac, int cellId) throws MAPException {
        super(5, 7, "GlobalCellId");
        this.setData(mcc, mnc, lac, cellId);
    }

    public void setData(int mcc, int mnc, int lac, int cellId) throws MAPException {
        if (mcc < 1 || mcc > 999) {
            throw new MAPException("Bad mcc value");
        }
        if (mnc < 0 || mnc > 999) {
            throw new MAPException("Bad mnc value");
        }
        this.data = new byte[7];
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        if (mcc < 100) {
            sb.append("0");
        }
        if (mcc < 10) {
            sb.append("0");
        }
        sb.append(mcc);
        if (mnc < 100) {
            if (mnc < 10) {
                sb2.append("0");
            }
            sb2.append(mnc);
        } else {
            sb.append(mnc % 10);
            sb2.append(mnc / 10);
        }
        AsnOutputStream asnOs = new AsnOutputStream();
        TbcdString.encodeString((OutputStream)asnOs, sb.toString());
        System.arraycopy(asnOs.toByteArray(), 0, this.data, 0, 2);
        asnOs = new AsnOutputStream();
        TbcdString.encodeString((OutputStream)asnOs, sb2.toString());
        System.arraycopy(asnOs.toByteArray(), 0, this.data, 2, 1);
        this.data[3] = (byte)(lac / 256);
        this.data[4] = (byte)(lac % 256);
        this.data[5] = (byte)(cellId / 256);
        this.data[6] = (byte)(cellId % 256);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getMcc() throws MAPException {
        if (this.data == null) {
            throw new MAPException("Data must not be empty");
        }
        if (this.data.length < 5 || this.data.length > 7) {
            throw new MAPException("Data length must be between 5-7");
        }
        AsnInputStream ansIS = new AsnInputStream(this.data);
        String res = null;
        try {
            res = TbcdString.decodeString((InputStream)ansIS, 3);
        }
        catch (IOException e) {
            throw new MAPException("IOException when decoding GlobalCellId: " + e.getMessage(), (Throwable)e);
        }
        catch (MAPParsingComponentException e) {
            throw new MAPException("MAPParsingComponentException when decoding GlobalCellId: " + e.getMessage(), (Throwable)e);
        }
        if (res.length() < 5 || res.length() > 6) {
            throw new MAPException("Decoded TbcdString must be equal 5 or 6");
        }
        String sMcc = res.substring(0, 3);
        return Integer.parseInt(sMcc);
    }

    public int getMnc() throws MAPException {
        if (this.data == null) {
            throw new MAPException("Data must not be empty");
        }
        if (this.data.length < 5 || this.data.length > 7) {
            throw new MAPException("Data length must be between 5-7");
        }
        AsnInputStream ansIS = new AsnInputStream(this.data);
        String res = null;
        try {
            res = TbcdString.decodeString((InputStream)ansIS, 3);
        }
        catch (IOException e) {
            throw new MAPException("IOException when decoding GlobalCellId: " + e.getMessage(), (Throwable)e);
        }
        catch (MAPParsingComponentException e) {
            throw new MAPException("MAPParsingComponentException when decoding GlobalCellId: " + e.getMessage(), (Throwable)e);
        }
        if (res.length() < 5 || res.length() > 6) {
            throw new MAPException("Decoded TbcdString must be equal 5 or 6");
        }
        String sMnc = res.length() == 5 ? res.substring(3) : res.substring(4) + res.substring(3, 4);
        return Integer.parseInt(sMnc);
    }

    public int getLac() throws MAPException {
        if (this.data == null) {
            throw new MAPException("Data must not be empty");
        }
        if (this.data.length < 5 || this.data.length > 7) {
            throw new MAPException("Data length must be between 5-7");
        }
        int res = (this.data[3] & 0xFF) * 256 + (this.data[4] & 0xFF);
        return res;
    }

    public int getCellId() throws MAPException {
        if (this.data == null) {
            throw new MAPException("Data must not be empty");
        }
        if (this.data.length < 5 || this.data.length > 7) {
            throw new MAPException("Data length must be between 5-7");
        }
        int res = 0;
        if (this.data.length == 7) {
            res = (this.data[5] & 0xFF) * 256 + (this.data[6] & 0xFF);
        }
        return res;
    }

    public String toString() {
        int mcc = 0;
        int mnc = 0;
        int lac = 0;
        int cellId = 0;
        boolean goodData = false;
        try {
            mcc = this.getMcc();
            mnc = this.getMnc();
            lac = this.getLac();
            cellId = this.getCellId();
            goodData = true;
        }
        catch (MAPException e) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (goodData) {
            sb.append("MCC=");
            sb.append(mcc);
            sb.append(", MNC=");
            sb.append(mnc);
            sb.append(", Lac=");
            sb.append(lac);
            sb.append(", CellId=");
            sb.append(cellId);
        } else {
            sb.append("Data=");
            sb.append(this.printDataArr());
        }
        sb.append("]");
        return sb.toString();
    }
}

