/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.map.api.primitives.AlertingCategory;
import org.mobicents.protocols.ss7.map.api.primitives.AlertingLevel;
import org.mobicents.protocols.ss7.map.api.primitives.AlertingPattern;
import org.mobicents.protocols.ss7.map.primitives.OctetStringLength1Base;

public class AlertingPatternImpl
extends OctetStringLength1Base
implements AlertingPattern {
    private static final String ALERTING_LEVEL = "alertingLevel";
    private static final String ALERTING_CATEGORY = "alertingCategory";
    private static final String DEVAULT_STRING_VALUE = null;
    protected static final XMLFormat<AlertingPatternImpl> ALERTING_PATTERN_XML = new XMLFormat<AlertingPatternImpl>(AlertingPatternImpl.class){

        public void read(XMLFormat.InputElement xml, AlertingPatternImpl alertingPattern) throws XMLStreamException {
            String str = xml.getAttribute(AlertingPatternImpl.ALERTING_LEVEL, DEVAULT_STRING_VALUE);
            if (str != null) {
                AlertingLevel al = Enum.valueOf(AlertingLevel.class, str);
                alertingPattern.data = al.getLevel();
            }
            if ((str = xml.getAttribute(AlertingPatternImpl.ALERTING_CATEGORY, DEVAULT_STRING_VALUE)) != null) {
                AlertingCategory cap = Enum.valueOf(AlertingCategory.class, str);
                alertingPattern.data = cap.getCategory();
            }
        }

        public void write(AlertingPatternImpl alertingPattern, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (alertingPattern.getAlertingLevel() != null) {
                xml.setAttribute(AlertingPatternImpl.ALERTING_LEVEL, alertingPattern.getAlertingLevel().toString());
            }
            if (alertingPattern.getAlertingCategory() != null) {
                xml.setAttribute(AlertingPatternImpl.ALERTING_CATEGORY, alertingPattern.getAlertingCategory().toString());
            }
        }
    };

    public AlertingPatternImpl() {
        super("AlertingPattern");
    }

    public AlertingPatternImpl(int data) {
        super("AlertingPattern", data);
    }

    public AlertingPatternImpl(AlertingLevel alertingLevel) {
        super("AlertingPattern", alertingLevel.getLevel());
    }

    public AlertingPatternImpl(AlertingCategory alertingCategory) {
        super("AlertingPattern", alertingCategory.getCategory());
    }

    public int getData() {
        return this.data;
    }

    public AlertingLevel getAlertingLevel() {
        return AlertingLevel.getInstance((int)this.data);
    }

    public AlertingCategory getAlertingCategory() {
        return AlertingCategory.getInstance((int)this.data);
    }

    public String toString() {
        AlertingCategory ac;
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        AlertingLevel al = this.getAlertingLevel();
        if (al != null) {
            sb.append("AlertingLevel=");
            sb.append(al);
        }
        if ((ac = this.getAlertingCategory()) != null) {
            sb.append(" AlertingCategory=");
            sb.append(ac);
        }
        sb.append("]");
        return sb.toString();
    }
}

