/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.errors;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageSsErrorStatus;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageImpl;

public class MAPErrorMessageSsErrorStatusImpl
extends MAPErrorMessageImpl
implements MAPErrorMessageSsErrorStatus {
    private static final String DATA = "data";
    private static final String Q_BIT = "qBit";
    private static final String P_BIT = "pBit";
    private static final String R_BIT = "rBit";
    private static final String A_BIT = "aBit";
    public static final int _mask_QBit = 8;
    public static final int _mask_PBit = 4;
    public static final int _mask_RBit = 2;
    public static final int _mask_ABit = 1;
    private int data;
    protected String _PrimitiveName = "MAPErrorMessageSsErrorStatus";
    protected static final XMLFormat<MAPErrorMessageSsErrorStatusImpl> MAP_ERROR_MESSAGE_SS_ERROR_STATUS_XML = new XMLFormat<MAPErrorMessageSsErrorStatusImpl>(MAPErrorMessageSsErrorStatusImpl.class){

        public void read(XMLFormat.InputElement xml, MAPErrorMessageSsErrorStatusImpl errorMessage) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.read(xml, (Object)errorMessage);
            errorMessage.data = (Integer)xml.get(MAPErrorMessageSsErrorStatusImpl.DATA, Integer.class);
            xml.get(MAPErrorMessageSsErrorStatusImpl.Q_BIT, Boolean.class);
            xml.get(MAPErrorMessageSsErrorStatusImpl.P_BIT, Boolean.class);
            xml.get(MAPErrorMessageSsErrorStatusImpl.R_BIT, Boolean.class);
            xml.get(MAPErrorMessageSsErrorStatusImpl.A_BIT, Boolean.class);
        }

        public void write(MAPErrorMessageSsErrorStatusImpl errorMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.write((Object)errorMessage, xml);
            xml.add((Object)errorMessage.data, MAPErrorMessageSsErrorStatusImpl.DATA, Integer.class);
            xml.add((Object)errorMessage.getQBit(), MAPErrorMessageSsErrorStatusImpl.Q_BIT, Boolean.class);
            xml.add((Object)errorMessage.getPBit(), MAPErrorMessageSsErrorStatusImpl.P_BIT, Boolean.class);
            xml.add((Object)errorMessage.getRBit(), MAPErrorMessageSsErrorStatusImpl.R_BIT, Boolean.class);
            xml.add((Object)errorMessage.getABit(), MAPErrorMessageSsErrorStatusImpl.A_BIT, Boolean.class);
        }
    };

    public MAPErrorMessageSsErrorStatusImpl(int data) {
        super(17L);
        this.data = data;
    }

    public MAPErrorMessageSsErrorStatusImpl(boolean qBit, boolean pBit, boolean rBit, boolean aBit) {
        super(17L);
        this.data = (qBit ? 8 : 0) + (pBit ? 4 : 0) + (rBit ? 2 : 0) + (aBit ? 1 : 0);
    }

    public MAPErrorMessageSsErrorStatusImpl() {
        super(17L);
    }

    public boolean isEmSsErrorStatus() {
        return true;
    }

    public MAPErrorMessageSsErrorStatus getEmSsErrorStatus() {
        return this;
    }

    public int getData() {
        return this.data;
    }

    public boolean getQBit() {
        return (this.data & 8) != 0;
    }

    public boolean getPBit() {
        return (this.data & 4) != 0;
    }

    public boolean getRBit() {
        return (this.data & 2) != 0;
    }

    public boolean getABit() {
        return (this.data & 1) != 0;
    }

    public void setData(int val) {
        this.data = val;
    }

    public void setQBit(boolean val) {
        this.data = val ? (this.data |= 8) : (this.data &= 0xF7);
    }

    public void setPBit(boolean val) {
        this.data = val ? (this.data |= 4) : (this.data &= 0xFB);
    }

    public void setRBit(boolean val) {
        this.data = val ? (this.data |= 2) : (this.data &= 0xFD);
    }

    public void setABit(boolean val) {
        this.data = val ? (this.data |= 1) : (this.data &= 0xFE);
    }

    public int getTag() throws MAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream localAis, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (localAis.getTagClass() != 0 || localAis.getTag() != 4 || !localAis.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error decoding " + this._PrimitiveName + ": bad tag class or tag or parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (length != 1) {
            throw new MAPParsingComponentException("Error decoding " + this._PrimitiveName + ": the field must contain 1 octet. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.data = localAis.read();
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        asnOs.write(this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.getQBit()) {
            sb.append("QBit");
            sb.append(", ");
        }
        if (this.getPBit()) {
            sb.append("PBit");
            sb.append(", ");
        }
        if (this.getRBit()) {
            sb.append("RBit");
            sb.append(", ");
        }
        if (this.getABit()) {
            sb.append("ABit");
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

