/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.errors;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.errors.CallBarringCause;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageCallBarred;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;

public class MAPErrorMessageCallBarredImpl
extends MAPErrorMessageImpl
implements MAPErrorMessageCallBarred {
    private static final String MAP_PROTOCOL_VERSION = "mapProtocolVersion";
    private static final String CALL_BARRING_CAUSE = "callBarringCause";
    private static final String UNAUTHORISED_MESSAGE_ORIGINATOR = "unauthorisedMessageOriginator";
    private static final String MAP_EXTENSION_CONTAINER = "mapExtensionContainer";
    public static final int unauthorisedMessageOriginator_TAG = 1;
    private long mapProtocolVersion;
    private CallBarringCause callBarringCause;
    private MAPExtensionContainer extensionContainer;
    private Boolean unauthorisedMessageOriginator;
    protected static final XMLFormat<MAPErrorMessageCallBarredImpl> MAP_ERROR_MESSAGE_CALL_BARRED_XML = new XMLFormat<MAPErrorMessageCallBarredImpl>(MAPErrorMessageCallBarredImpl.class){

        public void read(XMLFormat.InputElement xml, MAPErrorMessageCallBarredImpl errorMessage) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.read(xml, (Object)errorMessage);
            errorMessage.mapProtocolVersion = (Long)xml.get(MAPErrorMessageCallBarredImpl.MAP_PROTOCOL_VERSION, Long.class);
            String str = (String)xml.get(MAPErrorMessageCallBarredImpl.CALL_BARRING_CAUSE, String.class);
            if (str != null) {
                errorMessage.callBarringCause = Enum.valueOf(CallBarringCause.class, str);
            }
            errorMessage.unauthorisedMessageOriginator = (Boolean)xml.get(MAPErrorMessageCallBarredImpl.UNAUTHORISED_MESSAGE_ORIGINATOR, Boolean.class);
            errorMessage.extensionContainer = (MAPExtensionContainer)xml.get(MAPErrorMessageCallBarredImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }

        public void write(MAPErrorMessageCallBarredImpl errorMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.write((Object)errorMessage, xml);
            xml.add((Object)errorMessage.getMapProtocolVersion(), MAPErrorMessageCallBarredImpl.MAP_PROTOCOL_VERSION, Long.class);
            if (errorMessage.getCallBarringCause() != null) {
                xml.add((Object)errorMessage.getCallBarringCause().toString(), MAPErrorMessageCallBarredImpl.CALL_BARRING_CAUSE, String.class);
            }
            xml.add((Object)errorMessage.getUnauthorisedMessageOriginator(), MAPErrorMessageCallBarredImpl.UNAUTHORISED_MESSAGE_ORIGINATOR, Boolean.class);
            xml.add((Object)((MAPExtensionContainerImpl)errorMessage.extensionContainer), MAPErrorMessageCallBarredImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }
    };

    public MAPErrorMessageCallBarredImpl(long mapProtocolVersion, CallBarringCause callBarringCause, MAPExtensionContainer extensionContainer, Boolean unauthorisedMessageOriginator) {
        super(13L);
        this.mapProtocolVersion = mapProtocolVersion;
        this.callBarringCause = callBarringCause;
        this.extensionContainer = extensionContainer;
        this.unauthorisedMessageOriginator = unauthorisedMessageOriginator;
    }

    public MAPErrorMessageCallBarredImpl() {
        super(13L);
    }

    public boolean isEmCallBarred() {
        return true;
    }

    public MAPErrorMessageCallBarred getEmCallBarred() {
        return this;
    }

    public CallBarringCause getCallBarringCause() {
        return this.callBarringCause;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public Boolean getUnauthorisedMessageOriginator() {
        return this.unauthorisedMessageOriginator;
    }

    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    public void setCallBarringCause(CallBarringCause callBarringCause) {
        this.callBarringCause = callBarringCause;
    }

    public void setExtensionContainer(MAPExtensionContainer extensionContainer) {
        this.extensionContainer = extensionContainer;
    }

    public void setUnauthorisedMessageOriginator(Boolean unauthorisedMessageOriginator) {
        this.unauthorisedMessageOriginator = unauthorisedMessageOriginator;
    }

    public void setMapProtocolVersion(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public int getTag() throws MAPException {
        if (this.mapProtocolVersion < 3L) {
            return 10;
        }
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return this.mapProtocolVersion < 3L;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MAPErrorMessageCallBarred: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MAPErrorMessageCallBarred: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MAPErrorMessageCallBarred: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MAPErrorMessageCallBarred: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream localAis, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.callBarringCause = null;
        this.unauthorisedMessageOriginator = null;
        this.extensionContainer = null;
        if (localAis.getTagClass() != 0) {
            throw new MAPParsingComponentException("Error decoding MAPErrorMessageCallBarred: bad tag class", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (localAis.getTag()) {
            case 10: {
                if (!localAis.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageCallBarred: ENUMERATED tag but data is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                int code = (int)localAis.readIntegerData(length);
                this.callBarringCause = CallBarringCause.getInstance((int)code);
                if (this.callBarringCause == null) {
                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageCallBarred.callBarringCause: bad code value", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                this.mapProtocolVersion = 2L;
                break;
            }
            case 16: {
                if (localAis.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageCallBarred: SEQUENCE tag but data is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                AsnInputStream ais = localAis.readSequenceStreamData(length);
                block15: while (ais.available() != 0) {
                    int tag = ais.readTag();
                    switch (ais.getTagClass()) {
                        case 0: {
                            switch (tag) {
                                case 10: {
                                    int code = (int)ais.readInteger();
                                    this.callBarringCause = CallBarringCause.getInstance((int)code);
                                    if (this.callBarringCause != null) continue block15;
                                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageCallBarred.callBarringCause: bad code value", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                case 16: {
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    continue block15;
                                }
                            }
                            ais.advanceElement();
                            continue block15;
                        }
                        case 2: {
                            switch (tag) {
                                case 1: {
                                    ais.readNull();
                                    this.unauthorisedMessageOriginator = true;
                                    continue block15;
                                }
                            }
                            ais.advanceElement();
                            continue block15;
                        }
                    }
                    ais.advanceElement();
                }
                this.mapProtocolVersion = 3L;
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error decoding MAPErrorMessageCallBarred: bad tag", MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
        if (this.unauthorisedMessageOriginator == null) {
            this.unauthorisedMessageOriginator = false;
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        if (this.mapProtocolVersion < 3L) {
            this.encodeAll(asnOs, 0, 10);
        } else {
            this.encodeAll(asnOs, 0, 16);
        }
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            if (this.mapProtocolVersion < 3L) {
                asnOs.writeTag(tagClass, true, tag);
            } else {
                asnOs.writeTag(tagClass, false, tag);
            }
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MAPErrorMessageCallBarred: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws MAPException {
        if (!(this.callBarringCause != null || this.unauthorisedMessageOriginator != null && this.unauthorisedMessageOriginator.booleanValue() || this.extensionContainer != null)) {
            return;
        }
        if (this.callBarringCause == null && this.mapProtocolVersion < 3L) {
            return;
        }
        try {
            if (this.mapProtocolVersion < 3L) {
                aos.writeIntegerData((long)this.callBarringCause.getCode());
            } else {
                if (this.callBarringCause != null) {
                    aos.writeInteger(0, 10, (long)this.callBarringCause.getCode());
                }
                if (this.extensionContainer != null) {
                    ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(aos);
                }
                if (this.unauthorisedMessageOriginator != null && this.unauthorisedMessageOriginator.booleanValue()) {
                    aos.writeNull(2, 1);
                }
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding MAPErrorMessageCallBarred: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MAPErrorMessageCallBarred: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MAPErrorMessageCallBarred [");
        if (this.callBarringCause != null) {
            sb.append("callBarringCause=" + this.callBarringCause.toString());
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=" + this.extensionContainer.toString());
        }
        if (this.unauthorisedMessageOriginator != null && this.unauthorisedMessageOriginator.booleanValue()) {
            sb.append(", unauthorisedMessageOriginator=true");
        }
        sb.append("]");
        return sb.toString();
    }
}

