/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.AlertingPattern;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.USSDString;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSRequestIndication;
import org.mobicents.protocols.ss7.map.primitives.AlertingPatternImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.USSDStringImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.USSDMessageImpl;

public class UnstructuredSSRequestIndicationImpl
extends USSDMessageImpl
implements UnstructuredSSRequestIndication {
    private static final int _TAG_MSISDN = 0;
    private ISDNAddressString msisdnAddressString = null;
    private AlertingPattern alertingPattern = null;

    public UnstructuredSSRequestIndicationImpl() {
    }

    public UnstructuredSSRequestIndicationImpl(byte ussdDataCodingSch, USSDString ussdString, AlertingPattern alertingPattern, ISDNAddressString msisdnAddressString) {
        super(ussdDataCodingSch, ussdString);
        this.alertingPattern = alertingPattern;
        this.msisdnAddressString = msisdnAddressString;
    }

    public ISDNAddressString getMSISDNAddressString() {
        return this.msisdnAddressString;
    }

    public AlertingPattern getAlertingPattern() {
        return this.alertingPattern;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding UnstructuredSSRequestIndication: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding UnstructuredSSRequestIndication: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding UnstructuredSSRequestIndication: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding UnstructuredSSRequestIndication: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding UnstructuredSSRequestIndication: Parameter ussd-DataCodingScheme bad tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int length1 = ais.readLength();
        this.ussdDataCodingSch = ais.readOctetStringData(length1)[0];
        tag = ais.readTag();
        if (ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding UnstructuredSSRequestIndication: Parameter ussd-String bad tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.ussdString = new USSDStringImpl();
        ((USSDStringImpl)this.ussdString).decodeAll(ais);
        block3: while (ais.available() != 0) {
            tag = ais.readTag();
            switch (tag) {
                case 0: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding UnstructuredSSRequestIndication: Parameter msisdn bad tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.msisdnAddressString = new ISDNAddressStringImpl();
                    ((ISDNAddressStringImpl)this.msisdnAddressString).decodeAll(ais);
                    continue block3;
                }
            }
            if (tag == 4 && ais.getTagClass() == 0 && ais.isTagPrimitive()) {
                this.alertingPattern = new AlertingPatternImpl();
                ((AlertingPatternImpl)this.alertingPattern).decodeAll(ais);
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ProcessUnstructuredSSRequestIndication", (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.ussdString == null) {
            throw new MAPException("ussdString must not be null");
        }
        try {
            asnOs.writeOctetString(new byte[]{this.ussdDataCodingSch});
            ((USSDStringImpl)this.ussdString).encodeAll(asnOs);
            if (this.alertingPattern != null) {
                ((AlertingPatternImpl)this.alertingPattern).encodeAll(asnOs);
            }
            if (this.msisdnAddressString != null) {
                ((ISDNAddressStringImpl)this.msisdnAddressString).encodeAll(asnOs, 2, 0);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding ProcessUnstructuredSSRequestIndication", (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ProcessUnstructuredSSRequestIndication", (Throwable)e);
        }
    }
}

