/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.sms;

import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.MAPServiceBaseImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.MAPServiceListener;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckResult;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.service.sms.AlertServiceCentreRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.sms.AlertServiceCentreResponseIndication;
import org.mobicents.protocols.ss7.map.api.service.sms.ForwardShortMessageRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.sms.ForwardShortMessageResponseIndication;
import org.mobicents.protocols.ss7.map.api.service.sms.InformServiceCentreRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPDialogSms;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPServiceSms;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPServiceSmsListener;
import org.mobicents.protocols.ss7.map.api.service.sms.MoForwardShortMessageRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.sms.MoForwardShortMessageResponseIndication;
import org.mobicents.protocols.ss7.map.api.service.sms.MtForwardShortMessageRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.sms.MtForwardShortMessageResponseIndication;
import org.mobicents.protocols.ss7.map.api.service.sms.ReportSMDeliveryStatusRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.sms.ReportSMDeliveryStatusResponseIndication;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMResponseIndication;
import org.mobicents.protocols.ss7.map.dialog.ServingCheckDataImpl;
import org.mobicents.protocols.ss7.map.service.sms.AlertServiceCentreRequestIndicationImpl;
import org.mobicents.protocols.ss7.map.service.sms.AlertServiceCentreResponseIndicationImpl;
import org.mobicents.protocols.ss7.map.service.sms.ForwardShortMessageRequestIndicationImpl;
import org.mobicents.protocols.ss7.map.service.sms.ForwardShortMessageResponseIndicationImpl;
import org.mobicents.protocols.ss7.map.service.sms.InformServiceCentreRequestIndicationImpl;
import org.mobicents.protocols.ss7.map.service.sms.MAPDialogSmsImpl;
import org.mobicents.protocols.ss7.map.service.sms.MoForwardShortMessageRequestIndicationImpl;
import org.mobicents.protocols.ss7.map.service.sms.MoForwardShortMessageResponseIndicationImpl;
import org.mobicents.protocols.ss7.map.service.sms.MtForwardShortMessageRequestIndicationImpl;
import org.mobicents.protocols.ss7.map.service.sms.MtForwardShortMessageResponseIndicationImpl;
import org.mobicents.protocols.ss7.map.service.sms.ReportSMDeliveryStatusRequestIndicationImpl;
import org.mobicents.protocols.ss7.map.service.sms.ReportSMDeliveryStatusResponseIndicationImpl;
import org.mobicents.protocols.ss7.map.service.sms.SendRoutingInfoForSMRequestIndicationImpl;
import org.mobicents.protocols.ss7.map.service.sms.SendRoutingInfoForSMResponseIndicationImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class MAPServiceSmsImpl
extends MAPServiceBaseImpl
implements MAPServiceSms {
    protected Logger loger = Logger.getLogger(MAPServiceSmsImpl.class);

    public MAPServiceSmsImpl(MAPProviderImpl mapProviderImpl) {
        super(mapProviderImpl);
    }

    public MAPDialogSms createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference) throws MAPException {
        if (!this.isActivated()) {
            throw new MAPException("Cannot create MAPDialogSms because MAPServiceSms is not activated");
        }
        Dialog tcapDialog = this.createNewTCAPDialog(origAddress, destAddress);
        MAPDialogSmsImpl dialog = new MAPDialogSmsImpl(appCntx, tcapDialog, this.mapProviderImpl, this, origReference, destReference);
        this.PutMADDialogIntoCollection(dialog);
        return dialog;
    }

    protected MAPDialogImpl createNewDialogIncoming(MAPApplicationContext appCntx, Dialog tcapDialog) {
        return new MAPDialogSmsImpl(appCntx, tcapDialog, this.mapProviderImpl, this, null, null);
    }

    public void addMAPServiceListener(MAPServiceSmsListener mapServiceListener) {
        super.addMAPServiceListener((MAPServiceListener)mapServiceListener);
    }

    public void removeMAPServiceListener(MAPServiceSmsListener mapServiceListener) {
        super.removeMAPServiceListener((MAPServiceListener)mapServiceListener);
    }

    public ServingCheckData isServingService(MAPApplicationContext dialogApplicationContext) {
        MAPApplicationContextName ctx = dialogApplicationContext.getApplicationContextName();
        int vers = dialogApplicationContext.getApplicationContextVersion().getVersion();
        switch (ctx) {
            case shortMsgAlertContext: {
                if (vers >= 1 && vers <= 2) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 2) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 2L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case shortMsgMORelayContext: 
            case shortMsgGatewayContext: {
                if (vers >= 1 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 2L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case shortMsgMTRelayContext: {
                if (vers >= 2 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 2L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
        }
        return new ServingCheckDataImpl(ServingCheckResult.AC_NotServing);
    }

    public MAPApplicationContext getMAPv1ApplicationContext(int operationCode, Invoke invoke) {
        switch (operationCode) {
            case 46: {
                return MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.shortMsgMORelayContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version1);
            }
            case 49: {
                return MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.shortMsgAlertContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version1);
            }
            case 45: {
                return MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.shortMsgGatewayContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version1);
            }
            case 47: {
                return MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.shortMsgGatewayContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version1);
            }
        }
        return null;
    }

    public void processComponent(ComponentType compType, OperationCode oc, Parameter parameter, MAPDialog mapDialog, Long invokeId, Long linkedId) throws MAPParsingComponentException {
        MAPDialogSmsImpl mapDialogSmsImpl = (MAPDialogSmsImpl)mapDialog;
        Long ocValue = oc.getLocalOperationCode();
        if (ocValue == null) {
            new MAPParsingComponentException("", MAPParsingComponentExceptionReason.UnrecognizedOperation);
        }
        MAPApplicationContextName acn = mapDialog.getApplicationContext().getApplicationContextName();
        int vers = mapDialog.getApplicationContext().getApplicationContextVersion().getVersion();
        int ocValueInt = (int)ocValue.longValue();
        switch (ocValueInt) {
            case 46: {
                if (acn != MAPApplicationContextName.shortMsgMORelayContext && (acn != MAPApplicationContextName.shortMsgMTRelayContext || vers != 2)) break;
                if (vers >= 3) {
                    if (compType == ComponentType.Invoke) {
                        this.moForwardShortMessageRequest(parameter, mapDialogSmsImpl, invokeId);
                        break;
                    }
                    this.moForwardShortMessageResponse(parameter, mapDialogSmsImpl, invokeId);
                    break;
                }
                if (compType == ComponentType.Invoke) {
                    this.forwardShortMessageRequest(parameter, mapDialogSmsImpl, invokeId);
                    break;
                }
                this.forwardShortMessageResponse(parameter, mapDialogSmsImpl, invokeId);
                break;
            }
            case 44: {
                if (acn != MAPApplicationContextName.shortMsgMTRelayContext || vers < 3) break;
                if (compType == ComponentType.Invoke) {
                    this.mtForwardShortMessageRequest(parameter, mapDialogSmsImpl, invokeId);
                    break;
                }
                this.mtForwardShortMessageResponse(parameter, mapDialogSmsImpl, invokeId);
                break;
            }
            case 45: {
                if (acn != MAPApplicationContextName.shortMsgGatewayContext) break;
                if (compType == ComponentType.Invoke) {
                    this.sendRoutingInfoForSMRequest(parameter, mapDialogSmsImpl, invokeId);
                    break;
                }
                this.sendRoutingInfoForSMResponse(parameter, mapDialogSmsImpl, invokeId);
                break;
            }
            case 47: {
                if (acn != MAPApplicationContextName.shortMsgGatewayContext) break;
                if (compType == ComponentType.Invoke) {
                    this.reportSMDeliveryStatusRequest(parameter, mapDialogSmsImpl, invokeId);
                    break;
                }
                this.reportSMDeliveryStatusResponse(parameter, mapDialogSmsImpl, invokeId);
                break;
            }
            case 63: {
                if (acn != MAPApplicationContextName.shortMsgGatewayContext || vers < 2 || compType != ComponentType.Invoke) break;
                this.informServiceCentreRequest(parameter, mapDialogSmsImpl, invokeId);
                break;
            }
            case 64: {
                if (acn != MAPApplicationContextName.shortMsgAlertContext || vers < 2) break;
                if (compType == ComponentType.Invoke) {
                    this.alertServiceCentreRequest(parameter, mapDialogSmsImpl, invokeId);
                    break;
                }
                this.alertServiceCentreResponse(parameter, mapDialogSmsImpl, invokeId);
                break;
            }
            case 49: {
                if (acn != MAPApplicationContextName.shortMsgAlertContext || vers != 1 || compType != ComponentType.Invoke) break;
                this.alertServiceCentreRequest(parameter, mapDialogSmsImpl, invokeId);
                break;
            }
            default: {
                new MAPParsingComponentException("", MAPParsingComponentExceptionReason.UnrecognizedOperation);
            }
        }
    }

    private void forwardShortMessageRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding forwardShortMessageRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding moForwardShortMessageRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ForwardShortMessageRequestIndicationImpl ind = new ForwardShortMessageRequestIndicationImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSmsListener)serLis).onForwardShortMessageIndication((ForwardShortMessageRequestIndication)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing forwardShortMessageRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void forwardShortMessageResponse(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        ForwardShortMessageResponseIndicationImpl ind = new ForwardShortMessageResponseIndicationImpl();
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSmsListener)serLis).onForwardShortMessageRespIndication((ForwardShortMessageResponseIndication)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing forwardShortMessageResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void moForwardShortMessageRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding moForwardShortMessageRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding moForwardShortMessageRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        MoForwardShortMessageRequestIndicationImpl ind = new MoForwardShortMessageRequestIndicationImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSmsListener)serLis).onMoForwardShortMessageIndication((MoForwardShortMessageRequestIndication)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing onMoForwardShortMessageIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void moForwardShortMessageResponse(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        MoForwardShortMessageResponseIndicationImpl ind = new MoForwardShortMessageResponseIndicationImpl();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding moForwardShortMessageResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSmsListener)serLis).onMoForwardShortMessageRespIndication((MoForwardShortMessageResponseIndication)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing onMoForwardShortMessageRespIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void mtForwardShortMessageRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding mtForwardShortMessageRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding mtForwardShortMessageRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        MtForwardShortMessageRequestIndicationImpl ind = new MtForwardShortMessageRequestIndicationImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSmsListener)serLis).onMtForwardShortMessageIndication((MtForwardShortMessageRequestIndication)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing onMtForwardShortMessageIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void mtForwardShortMessageResponse(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        MtForwardShortMessageResponseIndicationImpl ind = new MtForwardShortMessageResponseIndicationImpl();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding mtForwardShortMessageResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSmsListener)serLis).onMtForwardShortMessageRespIndication((MtForwardShortMessageResponseIndication)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing onMtForwardShortMessageRespIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void sendRoutingInfoForSMRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForSMRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForSMRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        SendRoutingInfoForSMRequestIndicationImpl ind = new SendRoutingInfoForSMRequestIndicationImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSmsListener)serLis).onSendRoutingInfoForSMIndication((SendRoutingInfoForSMRequestIndication)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing onSendRoutingInfoForSMIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void sendRoutingInfoForSMResponse(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        SendRoutingInfoForSMResponseIndicationImpl ind = new SendRoutingInfoForSMResponseIndicationImpl();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForSMResponse: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForSMResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSmsListener)serLis).onSendRoutingInfoForSMRespIndication((SendRoutingInfoForSMResponseIndication)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing onSendRoutingInfoForSMRespIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void reportSMDeliveryStatusRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForSMRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForSMRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ReportSMDeliveryStatusRequestIndicationImpl ind = new ReportSMDeliveryStatusRequestIndicationImpl(mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion());
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSmsListener)serLis).onReportSMDeliveryStatusIndication((ReportSMDeliveryStatusRequestIndication)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing onReportSMDeliveryStatusIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void reportSMDeliveryStatusResponse(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        ReportSMDeliveryStatusResponseIndicationImpl ind = new ReportSMDeliveryStatusResponseIndicationImpl();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding reportSMDeliveryStatusResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSmsListener)serLis).onReportSMDeliveryStatusRespIndication((ReportSMDeliveryStatusResponseIndication)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing onReportSMDeliveryStatusRespIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void informServiceCentreRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding informServiceCentreRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding informServiceCentreRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        InformServiceCentreRequestIndicationImpl ind = new InformServiceCentreRequestIndicationImpl();
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSmsListener)serLis).onInformServiceCentreIndication((InformServiceCentreRequestIndication)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing onInformServiceCentreIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void alertServiceCentreRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding alertServiceCentreRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding alertServiceCentreRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        AlertServiceCentreRequestIndicationImpl ind = new AlertServiceCentreRequestIndicationImpl();
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSmsListener)serLis).onAlertServiceCentreIndication((AlertServiceCentreRequestIndication)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing onAlertServiceCentreIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void alertServiceCentreResponse(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        AlertServiceCentreResponseIndicationImpl ind = new AlertServiceCentreResponseIndicationImpl();
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceSmsListener)serLis).onAlertServiceCentreRespIndication((AlertServiceCentreResponseIndication)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing onAlertServiceCentreRespIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

