/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.asn.BitSetStrictLength;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.lsm.SupportedLCSCapabilitySets;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class SupportedLCSCapabilitySetsImpl
implements SupportedLCSCapabilitySets,
MAPAsnPrimitive {
    private static final int _INDEX_LCS_CAPABILITY_SET1 = 0;
    private static final int _INDEX_LCS_CAPABILITY_SET2 = 1;
    private static final int _INDEX_LCS_CAPABILITY_SET3 = 2;
    private static final int _INDEX_LCS_CAPABILITY_SET4 = 3;
    private BitSetStrictLength bitString = new BitSetStrictLength(4);

    public SupportedLCSCapabilitySetsImpl() {
    }

    public SupportedLCSCapabilitySetsImpl(Boolean lcsCapabilitySet1, Boolean lcsCapabilitySet2, Boolean lcsCapabilitySet3, Boolean lcsCapabilitySet4) {
        if (lcsCapabilitySet1.booleanValue()) {
            this.bitString.set(0);
        }
        if (lcsCapabilitySet2.booleanValue()) {
            this.bitString.set(1);
        }
        if (lcsCapabilitySet3.booleanValue()) {
            this.bitString.set(2);
        }
        if (lcsCapabilitySet4.booleanValue()) {
            this.bitString.set(3);
        }
    }

    public int getTag() throws MAPException {
        return 3;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (length == 0 || length > 4) {
            throw new MAPParsingComponentException("Error decoding SupportedLCSCapabilitySets: the SupportedLCSCapabilitySets field must contain from 2 or 4 octets. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.bitString = ansIS.readBitStringData(length);
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 3);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MWStatus: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            asnOs.writeBitStringData(this.bitString);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding MWStatus: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MWStatus: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean getLcsCapabilitySet1() {
        return this.bitString.get(0);
    }

    public boolean getLcsCapabilitySet2() {
        return this.bitString.get(1);
    }

    public boolean getLcsCapabilitySet3() {
        return this.bitString.get(2);
    }

    public boolean getLcsCapabilitySet4() {
        return this.bitString.get(3);
    }
}

