/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.SubscriberLocationReportResponseIndication;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LsmMessageImpl;

public class SubscriberLocationReportResponseIndicationImpl
extends LsmMessageImpl
implements SubscriberLocationReportResponseIndication {
    private static final int _TAG_NA_ESRK = 0;
    private static final int _TAG_NA_ESRD = 1;
    private ISDNAddressString naEsrd = null;
    private ISDNAddressString naEsrk = null;
    private MAPExtensionContainer extensionContainer = null;

    public SubscriberLocationReportResponseIndicationImpl() {
    }

    public SubscriberLocationReportResponseIndicationImpl(ISDNAddressString naEsrd, ISDNAddressString naEsrk, MAPExtensionContainer extensionContainer) {
        this.naEsrd = naEsrd;
        this.naEsrk = naEsrk;
        this.extensionContainer = extensionContainer;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public AddressString getNaESRK() {
        return this.naEsrk;
    }

    public AddressString getNaESRD() {
        return this.naEsrd;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block7: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 16: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ReportSMDeliveryStatusResponse: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue block7;
                    }
                }
                ais.advanceElement();
                continue;
            }
            switch (tag) {
                case 0: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding SubscriberLocationReportResponseIndication: Parameter [na-ESRK [0] ISDN-AddressString] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.naEsrk = new ISDNAddressStringImpl();
                    ((ISDNAddressStringImpl)this.naEsrk).decodeAll(ais);
                    continue block7;
                }
                case 1: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding SubscriberLocationReportResponseIndication: Parameter [na-ESRD [1] ISDN-AddressString] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.naEsrd = new ISDNAddressStringImpl();
                    ((ISDNAddressStringImpl)this.naEsrd).decodeAll(ais);
                    continue block7;
                }
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ReportSMDeliveryStatusResponse: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
        }
        if (this.naEsrk != null) {
            ((ISDNAddressStringImpl)this.naEsrk).encodeAll(asnOs, 2, 0);
        }
        if (this.naEsrd != null) {
            ((ISDNAddressStringImpl)this.naEsrd).encodeAll(asnOs, 2, 1);
        }
    }
}

