/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSLocationInfo;
import org.mobicents.protocols.ss7.map.api.service.lsm.SendRoutingInfoForLCSResponseIndication;
import org.mobicents.protocols.ss7.map.api.service.lsm.SubscriberIdentity;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LCSLocationInfoImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LsmMessageImpl;
import org.mobicents.protocols.ss7.map.service.lsm.SubscriberIdentityImpl;

public class SendRoutingInfoForLCSResponseIndicationImpl
extends LsmMessageImpl
implements SendRoutingInfoForLCSResponseIndication {
    private static final int _TAG_TARGET_MS = 0;
    private static final int _TAG_LCS_LOCATION_INFO = 1;
    private static final int _TAG_EXTENSION_CONTAINER = 2;
    private static final int _TAG_V_GMLC_ADDRESS = 3;
    private static final int _TAG_H_GMLC_ADDRESS = 4;
    private static final int _TAG_PPR_ADDRESS = 5;
    private static final int _TAG_ADDITIONAL_V_GMLC_ADDRESS = 6;
    private SubscriberIdentity targetMS = null;
    private LCSLocationInfo lcsLocationInfo = null;
    private MAPExtensionContainer extensionContainer = null;
    private byte[] vgmlcAddress = null;
    private byte[] hGmlcAddress = null;
    private byte[] pprAddress = null;
    private byte[] additionalVGmlcAddress = null;

    public SendRoutingInfoForLCSResponseIndicationImpl() {
    }

    public SendRoutingInfoForLCSResponseIndicationImpl(SubscriberIdentity targetMS, LCSLocationInfo lcsLocationInfo, MAPExtensionContainer extensionContainer, byte[] vgmlcAddress, byte[] hGmlcAddress, byte[] pprAddress, byte[] additionalVGmlcAddress) {
        this.targetMS = targetMS;
        this.lcsLocationInfo = lcsLocationInfo;
        this.extensionContainer = extensionContainer;
        this.vgmlcAddress = vgmlcAddress;
        this.hGmlcAddress = hGmlcAddress;
        this.pprAddress = pprAddress;
        this.additionalVGmlcAddress = additionalVGmlcAddress;
    }

    public SubscriberIdentity getTargetMS() {
        return this.targetMS;
    }

    public LCSLocationInfo getLCSLocationInfo() {
        return this.lcsLocationInfo;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public byte[] getVgmlcAddress() {
        return this.vgmlcAddress;
    }

    public byte[] getHGmlcAddress() {
        return this.hGmlcAddress;
    }

    public byte[] getPprAddress() {
        return this.pprAddress;
    }

    public byte[] getAdditionalVGmlcAddress() {
        return this.additionalVGmlcAddress;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 2 || ais.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInforForLCSResponseIndication: Parameter [targetMS [0] SubscriberIdentity] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int length1 = ais.readLength();
        tag = ais.readTag();
        this.targetMS = new SubscriberIdentityImpl();
        ((SubscriberIdentityImpl)this.targetMS).decodeAll(ais);
        tag = ais.readTag();
        if (ais.getTagClass() != 2 || ais.isTagPrimitive() || tag != 1) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInforForLCSResponseIndication: Parameter [lcsLocationInfo [1] LCSLocationInfo] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.lcsLocationInfo = new LCSLocationInfoImpl();
        ((LCSLocationInfoImpl)this.lcsLocationInfo).decodeAll(ais);
        block7: while (ais.available() != 0) {
            tag = ais.readTag();
            switch (tag) {
                case 2: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding SendRoutingInforForLCSResponseIndication: Parameter [extensionContainer [2] ExtensionContainer] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.extensionContainer = new MAPExtensionContainerImpl();
                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                    continue block7;
                }
                case 3: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding SendRoutingInforForLCSResponseIndication: Parameter [v-gmlc-Address [3] GSN-Address] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    length1 = ais.readLength();
                    this.vgmlcAddress = ais.readOctetStringData(length1);
                    continue block7;
                }
                case 4: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding SendRoutingInforForLCSResponseIndication: Parameter [h-gmlc-Address [4] GSN-Address] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    length1 = ais.readLength();
                    this.hGmlcAddress = ais.readOctetStringData(length1);
                    continue block7;
                }
                case 5: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding SendRoutingInforForLCSResponseIndication: Parameter [ppr-Address [5] GSN-Address] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    length1 = ais.readLength();
                    this.pprAddress = ais.readOctetStringData(length1);
                    continue block7;
                }
                case 6: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding SendRoutingInforForLCSResponseIndication: Parameter [additional-v-gmlc-Address [6] GSN-Address] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    length1 = ais.readLength();
                    this.additionalVGmlcAddress = ais.readOctetStringData(length1);
                    continue block7;
                }
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MWStatus: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.targetMS == null) {
            throw new MAPException("Encoding of SendRoutingInforForLCSResponseIndication failed. Manadatory parameter targetMS [0] SubscriberIdentity is not set");
        }
        if (this.lcsLocationInfo == null) {
            throw new MAPException("Encoding of SendRoutingInforForLCSResponseIndication failed. Manadatory parameter lcsLocationInfo [1] LCSLocationInfo is not set");
        }
        try {
            asnOs.writeTag(2, false, 0);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException while encoding parameter targetMS [0] SubscriberIdentity");
        }
        int pos = asnOs.StartContentDefiniteLength();
        ((SubscriberIdentityImpl)this.targetMS).encodeAll(asnOs, 2, ((SubscriberIdentityImpl)this.targetMS).getTag());
        asnOs.FinalizeContent(pos);
        ((LCSLocationInfoImpl)this.lcsLocationInfo).encodeAll(asnOs, 2, 1);
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 2);
        }
        if (this.vgmlcAddress != null) {
            try {
                asnOs.writeOctetString(2, 3, this.vgmlcAddress);
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding parameter v-gmlc-Address");
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding parameter v-gmlc-Address");
            }
        }
        if (this.hGmlcAddress != null) {
            try {
                asnOs.writeOctetString(2, 4, this.hGmlcAddress);
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding parameter hGmlcAddress");
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding parameter hGmlcAddress");
            }
        }
        if (this.pprAddress != null) {
            try {
                asnOs.writeOctetString(2, 5, this.pprAddress);
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding parameter pprAddress");
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding parameter pprAddress");
            }
        }
        if (this.additionalVGmlcAddress != null) {
            try {
                asnOs.writeOctetString(2, 6, this.additionalVGmlcAddress);
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding parameter additionalVGmlcAddress");
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding parameter additionalVGmlcAddress");
            }
        }
    }
}

