/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.SendRoutingInfoForLCSRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.lsm.SubscriberIdentity;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LsmMessageImpl;
import org.mobicents.protocols.ss7.map.service.lsm.SubscriberIdentityImpl;

public class SendRoutingInfoForLCSRequestIndicationImpl
extends LsmMessageImpl
implements SendRoutingInfoForLCSRequestIndication {
    private static final int _TAG_MLC_NUMBER = 0;
    private static final int _TAG_TARGET_MS = 1;
    private static final int _TAG_EXTENSION_CONTAINER = 2;
    private MAPExtensionContainer extensionContainer = null;
    private SubscriberIdentity targetMS = null;
    private ISDNAddressString mlcNumber = null;

    public SendRoutingInfoForLCSRequestIndicationImpl() {
    }

    public SendRoutingInfoForLCSRequestIndicationImpl(ISDNAddressString mlcNumber, SubscriberIdentity targetMS) {
        this.targetMS = targetMS;
        this.mlcNumber = mlcNumber;
    }

    public SendRoutingInfoForLCSRequestIndicationImpl(ISDNAddressString mlcNumber, SubscriberIdentity targetMS, MAPExtensionContainer extensionContainer) {
        this(mlcNumber, targetMS);
        this.extensionContainer = extensionContainer;
    }

    public ISDNAddressString getMLCNumber() {
        return this.mlcNumber;
    }

    public SubscriberIdentity getTargetMS() {
        return this.targetMS;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProvideSubscriberLocationRequestIndication: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInforForLCSRequestIndication: Parameter [mlcNumber [0] ISDN-AddressString] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.mlcNumber = new ISDNAddressStringImpl();
        ((ISDNAddressStringImpl)this.mlcNumber).decodeAll(ais);
        tag = ais.readTag();
        if (ais.getTagClass() != 2 || ais.isTagPrimitive() || tag != 1) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInforForLCSRequestIndication: Parameter [targetMS [1] SubscriberIdentity] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int length1 = ais.readLength();
        tag = ais.readTag();
        this.targetMS = new SubscriberIdentityImpl();
        ((SubscriberIdentityImpl)this.targetMS).decodeAll(ais);
        block3: while (ais.available() != 0) {
            tag = ais.readTag();
            switch (tag) {
                case 2: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding SendRoutingInforForLCSRequestIndication: Parameter [extensionContainer [2] ExtensionContainer] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.extensionContainer = new MAPExtensionContainerImpl();
                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                    continue block3;
                }
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MWStatus: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.mlcNumber == null) {
            throw new MAPException("Encoding of SendRoutingInforForLCSRequestIndication failed. Manadatory parameter mlcNumber [0] ISDN-AddressString is not set");
        }
        if (this.targetMS == null) {
            throw new MAPException("Encoding of SendRoutingInforForLCSRequestIndication failed. Manadatory parameter targetMS [1] SubscriberIdentity is not set");
        }
        ((ISDNAddressStringImpl)this.mlcNumber).encodeAll(asnOs, 2, 0);
        try {
            asnOs.writeTag(2, false, 1);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException while encoding parameter targetMS [1] SubscriberIdentity");
        }
        int pos = asnOs.StartContentDefiniteLength();
        ((SubscriberIdentityImpl)this.targetMS).encodeAll(asnOs, 2, ((SubscriberIdentityImpl)this.targetMS).getTag());
        asnOs.FinalizeContent(pos);
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 2);
        }
    }
}

