/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.MAPServiceBaseImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.MAPServiceListener;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckResult;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.service.lsm.MAPDialogLsm;
import org.mobicents.protocols.ss7.map.api.service.lsm.MAPServiceLsm;
import org.mobicents.protocols.ss7.map.api.service.lsm.MAPServiceLsmListener;
import org.mobicents.protocols.ss7.map.api.service.lsm.ProvideSubscriberLocationRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.lsm.ProvideSubscriberLocationResponseIndication;
import org.mobicents.protocols.ss7.map.api.service.lsm.SendRoutingInfoForLCSRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.lsm.SendRoutingInfoForLCSResponseIndication;
import org.mobicents.protocols.ss7.map.api.service.lsm.SubscriberLocationReportRequestIndication;
import org.mobicents.protocols.ss7.map.api.service.lsm.SubscriberLocationReportResponseIndication;
import org.mobicents.protocols.ss7.map.dialog.ServingCheckDataImpl;
import org.mobicents.protocols.ss7.map.service.lsm.MAPDialogLsmImpl;
import org.mobicents.protocols.ss7.map.service.lsm.ProvideSubscriberLocationRequestIndicationImpl;
import org.mobicents.protocols.ss7.map.service.lsm.ProvideSubscriberLocationResponseIndicationImpl;
import org.mobicents.protocols.ss7.map.service.lsm.SendRoutingInfoForLCSRequestIndicationImpl;
import org.mobicents.protocols.ss7.map.service.lsm.SendRoutingInfoForLCSResponseIndicationImpl;
import org.mobicents.protocols.ss7.map.service.lsm.SubscriberLocationReportRequestIndicationImpl;
import org.mobicents.protocols.ss7.map.service.lsm.SubscriberLocationReportResponseIndicationImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class MAPServiceLsmImpl
extends MAPServiceBaseImpl
implements MAPServiceLsm {
    public MAPServiceLsmImpl(MAPProviderImpl mapProviderImpl) {
        super(mapProviderImpl);
    }

    public ServingCheckData isServingService(MAPApplicationContext dialogApplicationContext) {
        int vers = dialogApplicationContext.getApplicationContextVersion().getVersion();
        switch (dialogApplicationContext.getApplicationContextName()) {
            case locationSvcEnquiryContext: 
            case locationSvcGatewayContext: {
                if (vers == 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
        }
        return new ServingCheckDataImpl(ServingCheckResult.AC_NotServing);
    }

    public void processComponent(ComponentType compType, OperationCode oc, Parameter parameter, MAPDialog mapDialog, Long invokeId, Long linkedId) throws MAPParsingComponentException {
        MAPDialogLsmImpl mAPDialogLsmImpl = (MAPDialogLsmImpl)mapDialog;
        Long ocValue = oc.getLocalOperationCode();
        if (ocValue == null) {
            new MAPParsingComponentException("", MAPParsingComponentExceptionReason.UnrecognizedOperation);
        }
        long ocValueInt = ocValue;
        int ocValueInt2 = (int)ocValueInt;
        switch (ocValueInt2) {
            case 83: {
                if (compType == ComponentType.Invoke) {
                    this.provideSubscriberLocationReq(parameter, mAPDialogLsmImpl, invokeId);
                    break;
                }
                this.provideSubscriberLocationRes(parameter, mAPDialogLsmImpl, invokeId);
                break;
            }
            case 86: {
                if (compType == ComponentType.Invoke) {
                    this.subscriberLocationReportReq(parameter, mAPDialogLsmImpl, invokeId);
                    break;
                }
                this.subscriberLocationReportRes(parameter, mAPDialogLsmImpl, invokeId);
                break;
            }
            case 85: {
                if (compType == ComponentType.Invoke) {
                    this.sendRoutingInfoForLCSReq(parameter, mAPDialogLsmImpl, invokeId);
                    break;
                }
                this.sendRoutingInfoForLCSRes(parameter, mAPDialogLsmImpl, invokeId);
                break;
            }
            default: {
                new MAPParsingComponentException("", MAPParsingComponentExceptionReason.UnrecognizedOperation);
            }
        }
    }

    private void provideSubscriberLocationReq(Parameter param, MAPDialogLsmImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (param == null) {
            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = param.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ProvideSubscriberLocationRequestIndicationImpl provideSubsLoctReqInd = new ProvideSubscriberLocationRequestIndicationImpl();
        provideSubsLoctReqInd.decodeAll(ais);
        provideSubsLoctReqInd.setInvokeId(invokeId);
        provideSubsLoctReqInd.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            ((MAPServiceLsmListener)serLis).onProvideSubscriberLocationRequestIndication((ProvideSubscriberLocationRequestIndication)provideSubsLoctReqInd);
        }
    }

    private void provideSubscriberLocationRes(Parameter param, MAPDialogLsmImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (param == null) {
            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = param.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ProvideSubscriberLocationResponseIndicationImpl provideSubsLoctResInd = new ProvideSubscriberLocationResponseIndicationImpl();
        provideSubsLoctResInd.decodeAll(ais);
        provideSubsLoctResInd.setInvokeId(invokeId);
        provideSubsLoctResInd.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            ((MAPServiceLsmListener)serLis).onProvideSubscriberLocationResponseIndication((ProvideSubscriberLocationResponseIndication)provideSubsLoctResInd);
        }
    }

    private void subscriberLocationReportReq(Parameter parameter, MAPDialogLsmImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding subscriberLocationReport: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        SubscriberLocationReportRequestIndicationImpl reqInd = new SubscriberLocationReportRequestIndicationImpl();
        reqInd.decodeAll(ais);
        reqInd.setInvokeId(invokeId);
        reqInd.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            ((MAPServiceLsmListener)serLis).onSubscriberLocationReportRequestIndication((SubscriberLocationReportRequestIndication)reqInd);
        }
    }

    private void subscriberLocationReportRes(Parameter parameter, MAPDialogLsmImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding subscriberLocationReport: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        SubscriberLocationReportResponseIndicationImpl resInd = new SubscriberLocationReportResponseIndicationImpl();
        resInd.decodeAll(ais);
        resInd.setInvokeId(invokeId);
        resInd.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            ((MAPServiceLsmListener)serLis).onSubscriberLocationReportResponseIndication((SubscriberLocationReportResponseIndication)resInd);
        }
    }

    private void sendRoutingInfoForLCSReq(Parameter parameter, MAPDialogLsmImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForLCS: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        SendRoutingInfoForLCSRequestIndicationImpl reqInd = new SendRoutingInfoForLCSRequestIndicationImpl();
        reqInd.decodeAll(ais);
        reqInd.setInvokeId(invokeId);
        reqInd.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            ((MAPServiceLsmListener)serLis).onSendRoutingInforForLCSRequestIndication((SendRoutingInfoForLCSRequestIndication)reqInd);
        }
    }

    private void sendRoutingInfoForLCSRes(Parameter parameter, MAPDialogLsmImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForLCS: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        SendRoutingInfoForLCSResponseIndicationImpl resInd = new SendRoutingInfoForLCSResponseIndicationImpl();
        resInd.decodeAll(ais);
        resInd.setInvokeId(invokeId);
        resInd.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            ((MAPServiceLsmListener)serLis).onSendRoutingInforForLCSResponseIndication((SendRoutingInfoForLCSResponseIndication)resInd);
        }
    }

    public MAPDialogLsm createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference) throws MAPException {
        if (!this.isActivated()) {
            throw new MAPException("Cannot create MAPDialogLsm because MAPServiceLsm is not activated");
        }
        Dialog tcapDialog = this.createNewTCAPDialog(origAddress, destAddress);
        MAPDialogLsmImpl dialog = new MAPDialogLsmImpl(appCntx, tcapDialog, this.mapProviderImpl, this, origReference, destReference);
        this.PutMADDialogIntoCollection(dialog);
        return dialog;
    }

    public void addMAPServiceListener(MAPServiceLsmListener mapServiceListener) {
        super.addMAPServiceListener((MAPServiceListener)mapServiceListener);
    }

    public void removeMAPServiceListener(MAPServiceLsmListener mapServiceListener) {
        super.removeMAPServiceListener((MAPServiceListener)mapServiceListener);
    }

    protected MAPDialogImpl createNewDialogIncoming(MAPApplicationContext appCntx, Dialog tcapDialog) {
        return new MAPDialogLsmImpl(appCntx, tcapDialog, this.mapProviderImpl, this, null, null);
    }
}

