/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSQoS;
import org.mobicents.protocols.ss7.map.api.service.lsm.ResponseTime;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.lsm.ResponseTimeImpl;

public class LCSQoSImpl
implements LCSQoS,
MAPAsnPrimitive {
    private static final int _TAG_HORIZONTAL_ACCURACY = 0;
    private static final int _TAG_VERTICAL_COORDINATE_REQUEST = 1;
    private static final int _TAG_VERTICAL_ACCURACY = 2;
    private static final int _TAG_RESPONSE_TIME = 3;
    private static final int _TAG_EXTENSION_CONTAINER = 4;
    private Integer horizontalAccuracy = null;
    private Integer verticalAccuracy = null;
    private Boolean verticalCoordinateRequest = false;
    private ResponseTime responseTime = null;
    private MAPExtensionContainer extensionContainer = null;

    public LCSQoSImpl() {
    }

    public LCSQoSImpl(Integer horizontalAccuracy, Integer verticalAccuracy, Boolean verticalCoordinateRequest, ResponseTime responseTime, MAPExtensionContainer extensionContainer) {
        this.horizontalAccuracy = horizontalAccuracy;
        this.verticalAccuracy = verticalAccuracy;
        this.verticalCoordinateRequest = verticalCoordinateRequest;
        this.responseTime = responseTime;
        this.extensionContainer = extensionContainer;
    }

    public Integer getHorizontalAccuracy() {
        return this.horizontalAccuracy;
    }

    public Boolean getVerticalCoordinateRequest() {
        return this.verticalCoordinateRequest;
    }

    public Integer getVerticalAccuracy() {
        return this.verticalAccuracy;
    }

    public ResponseTime getResponseTime() {
        return this.responseTime;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 2;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MWStatus: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block7: while (ais.available() != 0) {
            switch (ais.readTag()) {
                case 0: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Decoding LCSQoS failed. Error while decoding horizontal-accuracy [0] Horizontal-Accuracy: bad tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int length1 = ais.readLength();
                    this.horizontalAccuracy = new Integer(ais.readOctetStringData(length1)[0]);
                    continue block7;
                }
                case 1: {
                    int length1 = ais.readLength();
                    this.verticalCoordinateRequest = true;
                    continue block7;
                }
                case 2: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Decoding LCSQoS failed. Error while decoding vertical-accuracy [2] Vertical-Accuracy: bad tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int length1 = ais.readLength();
                    this.verticalAccuracy = new Integer(ais.readOctetStringData(length1)[0]);
                    continue block7;
                }
                case 3: {
                    if (ais.getTagClass() != 2 || ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Decoding LCSQoS failed. Error while decoding responseTime [3] ResponseTime: bad tag class, tag or not constructed", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.responseTime = new ResponseTimeImpl();
                    ((ResponseTimeImpl)this.responseTime).decodeAll(ais);
                    continue block7;
                }
                case 4: {
                    this.extensionContainer = new MAPExtensionContainerImpl();
                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                    continue block7;
                }
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding InformServiceCentreRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.horizontalAccuracy != null) {
            try {
                asnOs.writeOctetString(2, 0, new byte[]{this.horizontalAccuracy.byteValue()});
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding parameter horizontalAccuracy: ", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding parameter horizontalAccuracy: ", (Throwable)e);
            }
        }
        if (this.verticalCoordinateRequest != null) {
            try {
                asnOs.writeNull(2, 1);
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding parameter verticalCoordinateRequest: ", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("IOException when encoding parameter verticalCoordinateRequest: ", (Throwable)e);
            }
        }
        if (this.verticalAccuracy != null) {
            try {
                asnOs.writeOctetString(2, 2, new byte[]{this.verticalAccuracy.byteValue()});
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding parameter verticalAccuracy: ", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding parameter verticalAccuracy: ", (Throwable)e);
            }
        }
        if (this.responseTime != null) {
            ((ResponseTimeImpl)this.responseTime).encodeAll(asnOs, 2, 3);
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 4);
        }
    }
}

