/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.LMSI;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.AdditionalNumber;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSLocationInfo;
import org.mobicents.protocols.ss7.map.api.service.lsm.SupportedLCSCapabilitySets;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.LMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.lsm.AdditionalNumberImpl;
import org.mobicents.protocols.ss7.map.service.lsm.SupportedLCSCapabilitySetsImpl;

public class LCSLocationInfoImpl
implements LCSLocationInfo,
MAPAsnPrimitive {
    private static final int _TAG_LMSI = 0;
    private static final int _TAG_EXTENSION_CONTAINER = 1;
    private static final int _TAG_GPRS_NODE_IND = 2;
    private static final int _TAG_ADDITIONAL_NUMBER = 3;
    private static final int _TAG_SUPPORTED_LCS_CAPBILITY_SET = 4;
    private static final int _TAG_ADDITIONAL_LCS_CAPBILITY_SET = 5;
    private ISDNAddressString networkNodeNumber = null;
    private LMSI lmsi = null;
    private MAPExtensionContainer extensionContainer = null;
    private Boolean gprsNodeIndicator = null;
    private AdditionalNumber additionalNumber = null;
    private SupportedLCSCapabilitySets supportedLCSCapabilitySets = null;
    private SupportedLCSCapabilitySets additionalLCSCapabilitySets = null;

    public LCSLocationInfoImpl() {
    }

    public LCSLocationInfoImpl(ISDNAddressString networkNodeNumber, LMSI lmsi, MAPExtensionContainer extensionContainer, Boolean gprsNodeIndicator, AdditionalNumber additionalNumber, SupportedLCSCapabilitySets supportedLCSCapabilitySets, SupportedLCSCapabilitySets additionalLCSCapabilitySets) {
        this.networkNodeNumber = networkNodeNumber;
        this.lmsi = lmsi;
        this.extensionContainer = extensionContainer;
        this.gprsNodeIndicator = gprsNodeIndicator;
        this.additionalNumber = additionalNumber;
        this.supportedLCSCapabilitySets = supportedLCSCapabilitySets;
        this.additionalLCSCapabilitySets = additionalLCSCapabilitySets;
    }

    public ISDNAddressString getNetworkNodeNumber() {
        return this.networkNodeNumber;
    }

    public LMSI getLMSI() {
        return this.lmsi;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public Boolean getGprsNodeIndicator() {
        return this.gprsNodeIndicator;
    }

    public AdditionalNumber getAdditionalNumber() {
        return this.additionalNumber;
    }

    public SupportedLCSCapabilitySets getSupportedLCSCapabilitySets() {
        return this.supportedLCSCapabilitySets;
    }

    public SupportedLCSCapabilitySets getAdditionalLCSCapabilitySets() {
        return this.additionalLCSCapabilitySets;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
            throw new MAPParsingComponentException("Error while decoding LCSLocationInfo: Parameter [networkNode-Number ISDN-AddressString] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.networkNodeNumber = new ISDNAddressStringImpl();
        ((ISDNAddressStringImpl)this.networkNodeNumber).decodeAll(ais);
        block8: while (ais.available() != 0) {
            tag = ais.readTag();
            switch (tag) {
                case 0: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding LCSLocationInfo: Parameter [lmsi [0] LMSI ] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.lmsi = new LMSIImpl();
                    ((LMSIImpl)this.lmsi).decodeAll(ais);
                    continue block8;
                }
                case 1: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding LCSLocationInfo: Parameter [extensionContainer [1] ExtensionContainer ] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.extensionContainer = new MAPExtensionContainerImpl();
                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                    continue block8;
                }
                case 2: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding LCSLocationInfo: Parameter [gprsNodeIndicator [2] NULL ] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.gprsNodeIndicator = true;
                    continue block8;
                }
                case 3: {
                    if (ais.getTagClass() != 2 || ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding LCSLocationInfo: Parameter [additional-Number [3] Additional-Number] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int lenhth1 = ais.readLength();
                    tag = ais.readTag();
                    this.additionalNumber = new AdditionalNumberImpl();
                    ((AdditionalNumberImpl)this.additionalNumber).decodeAll(ais);
                    continue block8;
                }
                case 4: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding LCSLocationInfo: Parameter [supportedLCS-CapabilitySets [4] SupportedLCS-CapabilitySets] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.supportedLCSCapabilitySets = new SupportedLCSCapabilitySetsImpl();
                    ((SupportedLCSCapabilitySetsImpl)this.supportedLCSCapabilitySets).decodeAll(ais);
                    continue block8;
                }
                case 5: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding LCSLocationInfo: Parameter [additional-LCS-CapabilitySets [5] SupportedLCS-CapabilitySets] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.additionalLCSCapabilitySets = new SupportedLCSCapabilitySetsImpl();
                    ((SupportedLCSCapabilitySetsImpl)this.additionalLCSCapabilitySets).decodeAll(ais);
                    continue block8;
                }
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding InformServiceCentreRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.networkNodeNumber == null) {
            throw new MAPException("Error while encoding LCSLocationInfo the mandatory parameter networkNode-Number ISDN-AddressString is not defined");
        }
        ((ISDNAddressStringImpl)this.networkNodeNumber).encodeAll(asnOs);
        if (this.lmsi != null) {
            ((LMSIImpl)this.lmsi).encodeAll(asnOs, 2, 0);
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 1);
        }
        if (this.gprsNodeIndicator != null && this.gprsNodeIndicator.booleanValue()) {
            try {
                asnOs.writeNull(2, 2);
            }
            catch (IOException e) {
                throw new MAPException("Error while encoding LCSLocationInfo the optional parameter gprsNodeIndicator encoding failed ", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("Error while encoding LCSLocationInfo the optional parameter gprsNodeIndicator encoding failed ", (Throwable)e);
            }
        }
        if (this.additionalNumber != null) {
            try {
                asnOs.writeTag(2, false, 3);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding parameter additional-Number");
            }
            int pos = asnOs.StartContentDefiniteLength();
            ((AdditionalNumberImpl)this.additionalNumber).encodeAll(asnOs, 2, ((AdditionalNumberImpl)this.additionalNumber).getTag());
            asnOs.FinalizeContent(pos);
        }
        if (this.supportedLCSCapabilitySets != null) {
            ((SupportedLCSCapabilitySetsImpl)this.supportedLCSCapabilitySets).encodeAll(asnOs, 2, 4);
        }
        if (this.additionalLCSCapabilitySets != null) {
            ((SupportedLCSCapabilitySetsImpl)this.additionalLCSCapabilitySets).encodeAll(asnOs, 2, 5);
        }
    }
}

