/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.USSDString;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSCodeword;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.USSDStringImpl;

public class LCSCodewordImpl
implements LCSCodeword,
MAPAsnPrimitive {
    private static final int _TAG_DATA_CODING_SCHEME = 0;
    private static final int _TAG_LCS_CODE_WORD_STRING = 1;
    private byte dataCodingScheme;
    private USSDString lcsCodewordString = null;

    public LCSCodewordImpl() {
    }

    public LCSCodewordImpl(byte dataCodingScheme, USSDString lcsCodewordString) {
        this.dataCodingScheme = dataCodingScheme;
        this.lcsCodewordString = lcsCodewordString;
    }

    public byte getDataCodingScheme() {
        return this.dataCodingScheme;
    }

    public USSDString getLCSCodewordString() {
        return this.lcsCodewordString;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LCSClientName: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LCSClientName: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LCSCodeword: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LCSCodeword: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding LCSCodeword: Parameter 0[dataCodingScheme [0] USSD-DataCodingScheme] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int length1 = ais.readLength();
        this.dataCodingScheme = ais.readOctetStringData(length1)[0];
        tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 1) {
            throw new MAPParsingComponentException("Error while decoding LCSCodeword: Parameter 1[lcsCodewordString [1] LCSCodewordString] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.lcsCodewordString = new USSDStringImpl();
        ((USSDStringImpl)this.lcsCodewordString).decodeAll(ais);
        while (ais.available() != 0) {
            switch (ais.readTag()) {
                default: 
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding LCSClientName", (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.lcsCodewordString == null) {
            throw new MAPException("lcsCodewordString must not be null");
        }
        try {
            asnOs.writeOctetString(2, 0, new byte[]{this.dataCodingScheme});
            ((USSDStringImpl)this.lcsCodewordString).encodeAll(asnOs, 2, 1);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding LCSClientName", (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding LCSClientName", (Throwable)e);
        }
    }
}

