/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.lsm.DeferredLocationEventType;
import org.mobicents.protocols.ss7.map.api.service.lsm.DeferredmtlrData;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSLocationInfo;
import org.mobicents.protocols.ss7.map.api.service.lsm.TerminationCause;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.lsm.DeferredLocationEventTypeImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LCSLocationInfoImpl;

public class DeferredmtlrDataImpl
implements DeferredmtlrData,
MAPAsnPrimitive {
    private static final int _TAG_TERMINATION_CAUSE = 0;
    private static final int _TAG_LCS_LOCATION_INFO = 1;
    private DeferredLocationEventType deferredLocationEventType = null;
    private TerminationCause terminationCause = null;
    private LCSLocationInfo lcsLocationInfo = null;

    public DeferredmtlrDataImpl() {
    }

    public DeferredmtlrDataImpl(DeferredLocationEventType deferredLocationEventType, TerminationCause terminationCause, LCSLocationInfo lcsLocationInfo) {
        this.deferredLocationEventType = deferredLocationEventType;
        this.terminationCause = terminationCause;
        this.lcsLocationInfo = lcsLocationInfo;
    }

    public DeferredLocationEventType getDeferredLocationEventType() {
        return this.deferredLocationEventType;
    }

    public TerminationCause getTerminationCause() {
        return this.terminationCause;
    }

    public LCSLocationInfo getLCSLocationInfo() {
        return this.lcsLocationInfo;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 3) {
            throw new MAPParsingComponentException("Error while decoding DeferredmtlrData: Parameter [deferredLocationEventType DeferredLocationEventType] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.deferredLocationEventType = new DeferredLocationEventTypeImpl();
        ((DeferredLocationEventTypeImpl)this.deferredLocationEventType).decodeAll(ais);
        block4: while (ais.available() != 0) {
            tag = ais.readTag();
            switch (tag) {
                case 0: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Decoding of DeferredmtlrData failed. Decoding of parameter[terminationCause [0] TerminationCause] has Invalid Tag Class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int i1 = (int)ais.readInteger();
                    this.terminationCause = TerminationCause.getTerminationCause((int)i1);
                    continue block4;
                }
                case 1: {
                    if (ais.getTagClass() != 2 || ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Decoding of DeferredmtlrData failed. Decoding of parameter[lcsLocationInfo [1] LCSLocationInfo] has Invalid Tag Class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.lcsLocationInfo = new LCSLocationInfoImpl();
                    ((LCSLocationInfoImpl)this.lcsLocationInfo).decodeAll(ais);
                    continue block4;
                }
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding reportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.deferredLocationEventType == null) {
            throw new MAPException("Encdoing of DeferredmtlrData failed. Missing mandatory parameter deferredLocationEventType DeferredLocationEventType");
        }
        ((DeferredLocationEventTypeImpl)this.deferredLocationEventType).encodeAll(asnOs);
        try {
            if (this.terminationCause != null) {
                asnOs.writeInteger(2, 0, (long)this.terminationCause.getCause());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding Area: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding Area: " + e.getMessage(), (Throwable)e);
        }
        if (this.lcsLocationInfo != null) {
            ((LCSLocationInfoImpl)this.lcsLocationInfo).encodeAll(asnOs, 2, 1);
        }
    }
}

