/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.lsm.CellGlobalIdOrServiceAreaIdOrLAI;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class CellGlobalIdOrServiceAreaIdOrLAIImpl
implements CellGlobalIdOrServiceAreaIdOrLAI,
MAPAsnPrimitive {
    private static final int _TAG_CELL_GLOBAL_ID_OR_SERVICE_AREAR_ID = 0;
    private static final int _TAG_LAI = 1;
    private byte[] cellGlobalIdOrServiceAreaIdFixedLength = null;
    private byte[] laiFixedLength = null;

    public CellGlobalIdOrServiceAreaIdOrLAIImpl() {
    }

    public CellGlobalIdOrServiceAreaIdOrLAIImpl(byte[] cellGlobalIdOrServiceAreaIdFixedLength, byte[] laiFixedLength) throws MAPException {
        if (cellGlobalIdOrServiceAreaIdFixedLength != null && laiFixedLength != null) {
            throw new MAPException("Either cellGlobalIdOrServiceAreaIdFixedLength or laiFixedLength can be set. Not both");
        }
        this.cellGlobalIdOrServiceAreaIdFixedLength = cellGlobalIdOrServiceAreaIdFixedLength;
        this.laiFixedLength = laiFixedLength;
    }

    public byte[] getCellGlobalIdOrServiceAreaIdFixedLength() {
        return this.cellGlobalIdOrServiceAreaIdFixedLength;
    }

    public byte[] getLAIFixedLength() {
        return this.laiFixedLength;
    }

    public int getTag() throws MAPException {
        if (this.cellGlobalIdOrServiceAreaIdFixedLength != null) {
            return 0;
        }
        return 1;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_DA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (asnIS.getTagClass() != 2 || !asnIS.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding CellGlobalIdOrServiceAreaIdOrLAI: bad tag class or is not primitive: TagClass=" + asnIS.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (asnIS.getTag()) {
            case 0: {
                this.cellGlobalIdOrServiceAreaIdFixedLength = asnIS.readOctetStringData(length);
                break;
            }
            case 1: {
                this.laiFixedLength = asnIS.readOctetStringData(length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while decoding AdditionalNumber: Expexted msc-Number [0] ISDN-AddressString or sgsn-Number [1] ISDN-AddressString, but found " + asnIS.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 2, this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AdditionalNumber: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.cellGlobalIdOrServiceAreaIdFixedLength != null) {
            asnOs.write(this.cellGlobalIdOrServiceAreaIdFixedLength);
        } else {
            asnOs.write(this.laiFixedLength);
        }
    }
}

