/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.lsm.Area;
import org.mobicents.protocols.ss7.map.api.service.lsm.AreaList;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.lsm.AreaImpl;

public class AreaListImpl
implements AreaList,
MAPAsnPrimitive {
    private Area[] areas = null;

    public AreaListImpl() {
    }

    public AreaListImpl(Area[] areas) {
        this.areas = areas;
    }

    public Area[] getAreas() {
        return this.areas;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        ArrayList<AreaImpl> arealList = new ArrayList<AreaImpl>();
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() != 0 || ais.isTagPrimitive() || tag != 16) {
                throw new MAPParsingComponentException("Error while decoding AreaList: bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
            }
            AreaImpl a = new AreaImpl();
            a.decodeAll(ais);
            arealList.add(a);
        }
        this.areas = new Area[arealList.size()];
        this.areas = arealList.toArray(this.areas);
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding reportSMDeliveryStatusRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.areas == null || this.areas.length == 0) {
            throw new MAPException("Error while encoding AreaList the mandatory parameter[Area[]] is not defined");
        }
        for (int count = 0; count < this.areas.length; ++count) {
            ((AreaImpl)this.areas[count]).encodeAll(asnOs);
        }
    }
}

