/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.primitives.TbcdString;

public class AddressStringImpl
extends TbcdString
implements AddressString {
    protected int NO_EXTENSION_MASK = 128;
    protected int NATURE_OF_ADD_IND_MASK = 112;
    protected int NUMBERING_PLAN_IND_MASK = 15;
    protected AddressNature addressNature;
    protected NumberingPlan numberingPlan;
    protected String address;
    private boolean isExtension;

    public AddressStringImpl() {
    }

    public AddressStringImpl(AddressNature addressNature, NumberingPlan numberingPlan, String address) {
        this.addressNature = addressNature;
        this.numberingPlan = numberingPlan;
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public AddressNature getAddressNature() {
        return this.addressNature;
    }

    public NumberingPlan getNumberingPlan() {
        return this.numberingPlan;
    }

    public boolean isExtension() {
        return this.isExtension;
    }

    public int getTag() throws MAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AddressString: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AddressString: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    protected void _testLengthDecode(int length) throws MAPParsingComponentException {
        if (length > 20) {
            throw new MAPParsingComponentException("Error when decoding AddressString: mesage length must not exceed 20", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException {
        this._testLengthDecode(length);
        int nature = ansIS.read();
        this.isExtension = (nature & this.NO_EXTENSION_MASK) != 128;
        int natureOfAddInd = (nature & this.NATURE_OF_ADD_IND_MASK) >> 4;
        this.addressNature = AddressNature.getInstance((int)natureOfAddInd);
        int numbPlanInd = nature & this.NUMBERING_PLAN_IND_MASK;
        this.numberingPlan = NumberingPlan.getInstance((int)numbPlanInd);
        this.address = this.decodeString(ansIS, length - 1);
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 4);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AddressString: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void _testLengthEncode() throws MAPException {
        if (this.address.length() > 38) {
            throw new MAPException("Error when encoding AddressString: address length must not exceed 38 digits");
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.addressNature == null || this.numberingPlan == null || this.address == null) {
            throw new MAPException("Error when encoding AddressString: addressNature, numberingPlan or address is empty");
        }
        this._testLengthEncode();
        int nature = 1;
        if (this.isExtension) {
            nature = 0;
        }
        nature <<= 7;
        nature |= this.addressNature.getIndicator() << 4;
        asnOs.write(nature |= this.numberingPlan.getIndicator());
        this.encodeString(asnOs, this.address);
    }

    public String toString() {
        return "AddressString[AddressNature=" + this.addressNature.toString() + ", NumberingPlan=" + this.numberingPlan.toString() + ", Address=" + this.address + "]";
    }
}

