/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.errors;

import org.mobicents.protocols.ss7.map.api.errors.AbsentSubscriberReason;
import org.mobicents.protocols.ss7.map.api.errors.AdditionalNetworkResource;
import org.mobicents.protocols.ss7.map.api.errors.CallBarringCause;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageAbsentSubscriber;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageAbsentSubscriberSM;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageCallBarred;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageExtensionContainer;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageFacilityNotSup;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageFactory;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageParameterless;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessagePositionMethodFailure;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageSMDeliveryFailure;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageSubscriberBusyForMtSms;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageSystemFailure;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageUnauthorizedLCSClient;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageUnknownSubscriber;
import org.mobicents.protocols.ss7.map.api.errors.NetworkResource;
import org.mobicents.protocols.ss7.map.api.errors.PositionMethodFailureDiagnostic;
import org.mobicents.protocols.ss7.map.api.errors.SMEnumeratedDeliveryFailureCause;
import org.mobicents.protocols.ss7.map.api.errors.UnauthorizedLCSClientDiagnostic;
import org.mobicents.protocols.ss7.map.api.errors.UnknownSubscriberDiagnostic;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageAbsentSubscriberImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageAbsentSubscriberSMImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageCallBarredImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageFacilityNotSupImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageParameterlessImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessagePositionMethodFailureImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageSMDeliveryFailureImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageSubscriberBusyForMtSmsImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageSystemFailureImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageUnauthorizedLCSClientImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageUnknownSubscriberImpl;

public class MAPErrorMessageFactoryImpl
implements MAPErrorMessageFactory {
    public MAPErrorMessage createMessageFromErrorCode(Long errorCode) {
        long ec = errorCode;
        switch ((int)ec) {
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 33: 
            case 35: 
            case 36: 
            case 51: 
            case 52: 
            case 58: {
                return new MAPErrorMessageExtensionContainerImpl(errorCode);
            }
            case 32: {
                return new MAPErrorMessageSMDeliveryFailureImpl();
            }
            case 6: {
                return new MAPErrorMessageAbsentSubscriberSMImpl();
            }
            case 34: {
                return new MAPErrorMessageSystemFailureImpl();
            }
            case 13: {
                return new MAPErrorMessageCallBarredImpl();
            }
            case 21: {
                return new MAPErrorMessageFacilityNotSupImpl();
            }
            case 1: {
                return new MAPErrorMessageUnknownSubscriberImpl();
            }
            case 31: {
                return new MAPErrorMessageSubscriberBusyForMtSmsImpl();
            }
            case 27: {
                return new MAPErrorMessageAbsentSubscriberImpl();
            }
            case 53: {
                return new MAPErrorMessageUnauthorizedLCSClientImpl();
            }
            case 54: {
                return new MAPErrorMessagePositionMethodFailureImpl();
            }
        }
        return new MAPErrorMessageParameterlessImpl(errorCode);
    }

    public MAPErrorMessageParameterless createMAPErrorMessageParameterless(Long errorCode) {
        return new MAPErrorMessageParameterlessImpl(errorCode);
    }

    public MAPErrorMessageExtensionContainer createMAPErrorMessageExtensionContainer(Long errorCode, MAPExtensionContainer extensionContainer) {
        return new MAPErrorMessageExtensionContainerImpl(errorCode, extensionContainer);
    }

    public MAPErrorMessageSMDeliveryFailure createMAPErrorMessageSMDeliveryFailure(SMEnumeratedDeliveryFailureCause smEnumeratedDeliveryFailureCause, byte[] signalInfo, MAPExtensionContainer extensionContainer) {
        return new MAPErrorMessageSMDeliveryFailureImpl(smEnumeratedDeliveryFailureCause, signalInfo, extensionContainer);
    }

    public MAPErrorMessageFacilityNotSup createMAPErrorMessageFacilityNotSup(MAPExtensionContainer extensionContainer, Boolean shapeOfLocationEstimateNotSupported, Boolean neededLcsCapabilityNotSupportedInServingNode) {
        return new MAPErrorMessageFacilityNotSupImpl(extensionContainer, shapeOfLocationEstimateNotSupported, neededLcsCapabilityNotSupportedInServingNode);
    }

    public MAPErrorMessageSystemFailure createMAPErrorMessageSystemFailure(long mapVersion, NetworkResource networkResource, AdditionalNetworkResource additionalNetworkResource, MAPExtensionContainer extensionContainer) {
        return new MAPErrorMessageSystemFailureImpl(mapVersion, networkResource, additionalNetworkResource, extensionContainer);
    }

    public MAPErrorMessageUnknownSubscriber createMAPErrorMessageUnknownSubscriber(MAPExtensionContainer extensionContainer, UnknownSubscriberDiagnostic unknownSubscriberDiagnostic) {
        return new MAPErrorMessageUnknownSubscriberImpl(extensionContainer, unknownSubscriberDiagnostic);
    }

    public MAPErrorMessageAbsentSubscriberSM createMAPErrorMessageAbsentSubscriberSM(Integer absentSubscriberDiagnosticSM, MAPExtensionContainer extensionContainer, Integer additionalAbsentSubscriberDiagnosticSM) {
        return new MAPErrorMessageAbsentSubscriberSMImpl(absentSubscriberDiagnosticSM, extensionContainer, additionalAbsentSubscriberDiagnosticSM);
    }

    public MAPErrorMessageSubscriberBusyForMtSms createMAPErrorMessageSubscriberBusyForMtSms(MAPExtensionContainer extensionContainer, Boolean gprsConnectionSuspended) {
        return new MAPErrorMessageSubscriberBusyForMtSmsImpl(extensionContainer, gprsConnectionSuspended);
    }

    public MAPErrorMessageCallBarred createMAPErrorMessageCallBarred(Long mapVersion, CallBarringCause callBarringCause, MAPExtensionContainer extensionContainer, Boolean unauthorisedMessageOriginator) {
        return new MAPErrorMessageCallBarredImpl(mapVersion, callBarringCause, extensionContainer, unauthorisedMessageOriginator);
    }

    public MAPErrorMessageAbsentSubscriber createMAPErrorMessageAbsentSubscriber(MAPExtensionContainer extensionContainer, AbsentSubscriberReason absentSubscriberReason) {
        return new MAPErrorMessageAbsentSubscriberImpl(extensionContainer, absentSubscriberReason);
    }

    public MAPErrorMessageUnauthorizedLCSClient createMAPErrorMessageUnauthorizedLCSClient(UnauthorizedLCSClientDiagnostic unauthorizedLCSClientDiagnostic, MAPExtensionContainer extensionContainer) {
        return new MAPErrorMessageUnauthorizedLCSClientImpl(unauthorizedLCSClientDiagnostic, extensionContainer);
    }

    public MAPErrorMessagePositionMethodFailure createMAPErrorMessagePositionMethodFailure(PositionMethodFailureDiagnostic positionMethodFailureDiagnostic, MAPExtensionContainer extensionContainer) {
        return new MAPErrorMessagePositionMethodFailureImpl(positionMethodFailureDiagnostic, extensionContainer);
    }
}

