/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.mobicents.protocols.ss7.map.GSMCharset;

public class GSMCharsetDecoder
extends CharsetDecoder {
    byte[] mask = new byte[]{127, 63, 31, 15, 7, 3, 1};
    int bitpos = 0;
    byte leftOver;
    static final byte ESCAPE = 27;

    protected GSMCharsetDecoder(Charset cs, float averageCharsPerByte, float maxCharsPerByte) {
        super(cs, averageCharsPerByte, maxCharsPerByte);
        this.implReset();
    }

    protected void implReset() {
        this.bitpos = 0;
        this.leftOver = 0;
    }

    protected CoderResult implFlush(CharBuffer out) {
        return CoderResult.UNDERFLOW;
    }

    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        while (in.hasRemaining()) {
            byte data;
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            byte tempData = data = in.get();
            byte tempCurrHol = (byte)((data & 0xFF) >>> 7 - this.bitpos);
            data = (byte)(data & this.mask[this.bitpos]);
            if (this.bitpos != 0) {
                data = (byte)(data << this.bitpos);
                data = (byte)(data | this.leftOver);
                out.put((char)GSMCharset.BYTE_TO_CHAR[data]);
                if (this.bitpos == 6) {
                    data = (byte)((tempData & 0xFE) >>> 1);
                    out.put((char)GSMCharset.BYTE_TO_CHAR[data]);
                }
            } else {
                out.put((char)GSMCharset.BYTE_TO_CHAR[data]);
            }
            this.leftOver = tempCurrHol;
            ++this.bitpos;
            if (this.bitpos != 7) continue;
            this.bitpos = 0;
        }
        return CoderResult.UNDERFLOW;
    }
}

