/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPDialogueAS;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.dialog.AddressString;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.service.supplementary.USSDString;
import org.mobicents.protocols.ss7.map.dialog.AddressStringImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPOpenInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPUserAbortInfoImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPException;
import org.mobicents.protocols.ss7.tcap.api.TCAPSendException;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.TRPseudoState;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCBeginRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCContinueRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCEndRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUserAbortRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TerminationType;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.UserInformation;
import org.mobicents.protocols.ss7.tcap.asn.comp.Component;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class MAPDialogImpl
implements MAPDialog {
    private static final Logger logger = Logger.getLogger(MAPDialogImpl.class);
    private Dialog tcapDialog = null;
    private MAPProviderImpl mapProviderImpl = null;
    private MAPApplicationContext appCntx;
    private AddressString destReference;
    private AddressString origReference;
    private boolean mapAcceptInfoFired = false;

    protected MAPDialogImpl(MAPApplicationContext appCntx, Dialog tcapDialog, MAPProviderImpl mapProviderImpl) {
        this.appCntx = appCntx;
        this.tcapDialog = tcapDialog;
        this.mapProviderImpl = mapProviderImpl;
    }

    protected MAPDialogImpl(MAPApplicationContext appCntx, Dialog tcapDialog, MAPProviderImpl mapProviderImpl, AddressString origReference, AddressString destReference) {
        this(appCntx, tcapDialog, mapProviderImpl);
        this.destReference = destReference;
        this.origReference = origReference;
    }

    public Long getDialogId() {
        return this.tcapDialog.getDialogId();
    }

    public void abort(MAPUserAbortChoice mapUserAbortChoice) throws MAPException {
        TCUserAbortRequest tcUserAbort = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createUAbort(this.tcapDialog);
        MAPUserAbortInfoImpl mapUserAbortInfoImpl = new MAPUserAbortInfoImpl();
        mapUserAbortInfoImpl.setMAPUserAbortChoice(mapUserAbortChoice);
        AsnOutputStream localasnOs = new AsnOutputStream();
        try {
            mapUserAbortInfoImpl.encode(localasnOs);
        }
        catch (IOException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
        UserInformation userInformation = TcapFactory.createUserInformation();
        userInformation.setOid(true);
        userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
        userInformation.setAsn(true);
        userInformation.setEncodeType(localasnOs.toByteArray());
        tcUserAbort.setUserInformation(userInformation);
        try {
            this.tcapDialog.send(tcUserAbort);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    public void close(boolean prearrangedEnd) throws MAPException {
        if (this.tcapDialog.getState() == TRPseudoState.InitialReceived) {
            this.send();
        }
        if (this.tcapDialog.getState() == TRPseudoState.Active) {
            TCEndRequest endRequest = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createEnd(this.tcapDialog);
            if (!prearrangedEnd) {
                endRequest.setTermination(TerminationType.Basic);
            } else {
                endRequest.setTermination(TerminationType.PreArranged);
            }
            ApplicationContextName acn = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
            endRequest.setApplicationContextName(acn);
            try {
                this.tcapDialog.send(endRequest);
            }
            catch (TCAPSendException e) {
                throw new MAPException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void send() throws MAPException {
        if (this.tcapDialog.getState() == TRPseudoState.Idle) {
            TCBeginRequest tcBeginReq = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createBegin(this.tcapDialog);
            ApplicationContextName acn = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(MAPApplicationContext.networkUnstructuredSsContextV2.getOID());
            tcBeginReq.setApplicationContextName(acn);
            MAPOpenInfoImpl mapOpn = new MAPOpenInfoImpl();
            mapOpn.setDestReference(this.destReference);
            mapOpn.setOrigReference(this.origReference);
            AsnOutputStream localasnOs = new AsnOutputStream();
            try {
                mapOpn.encode(localasnOs);
            }
            catch (IOException e) {
                throw new MAPException(e.getMessage(), (Throwable)e);
            }
            UserInformation userInformation = TcapFactory.createUserInformation();
            userInformation.setOid(true);
            userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
            userInformation.setAsn(true);
            userInformation.setEncodeType(localasnOs.toByteArray());
            tcBeginReq.setUserInformation(userInformation);
            try {
                this.tcapDialog.send(tcBeginReq);
            }
            catch (TCAPSendException e) {
                throw new MAPException(e.getMessage(), (Throwable)e);
            }
        }
        if (this.tcapDialog.getState() == TRPseudoState.Active) {
            TCContinueRequest tcContinueReq = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createContinue(this.tcapDialog);
            try {
                this.tcapDialog.send(tcContinueReq);
            }
            catch (TCAPSendException e) {
                throw new MAPException(e.getMessage(), (Throwable)e);
            }
        }
        if (this.tcapDialog.getState() == TRPseudoState.InitialReceived) {
            TCContinueRequest tcContinueReq = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createContinue(this.tcapDialog);
            ApplicationContextName acn = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(MAPApplicationContext.networkUnstructuredSsContextV2.getOID());
            tcContinueReq.setApplicationContextName(acn);
            try {
                this.tcapDialog.send(tcContinueReq);
            }
            catch (TCAPSendException e) {
                throw new MAPException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addProcessUnstructuredSSRequest(byte ussdDataCodingScheme, USSDString ussdString, AddressString msisdn) throws MAPException {
        Invoke invoke = this.mapProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createTCInvokeRequest();
        try {
            invoke.setInvokeId(this.tcapDialog.getNewInvokeId());
            OperationCode oc = TcapFactory.createOperationCode((boolean)false, (Long)59L);
            invoke.setOperationCode(oc);
            Parameter p1 = TcapFactory.createParameter();
            p1.setTagClass(0);
            p1.setTag(4);
            p1.setData(new byte[]{ussdDataCodingScheme});
            ussdString.encode();
            Parameter p2 = TcapFactory.createParameter();
            p2.setTagClass(0);
            p2.setTag(4);
            p2.setData(ussdString.getEncodedString());
            Parameter p3 = null;
            if (msisdn != null) {
                AsnOutputStream asnOs = new AsnOutputStream();
                ((AddressStringImpl)msisdn).encode(asnOs);
                byte[] msisdndata = asnOs.toByteArray();
                p3 = TcapFactory.createParameter();
                p3.setTagClass(2);
                p3.setTag(0);
                p3.setData(msisdndata);
            }
            Parameter p = TcapFactory.createParameter();
            p.setTagClass(0);
            p.setTag(16);
            if (p3 != null) {
                p.setParameters(new Parameter[]{p1, p2, p3});
            } else {
                p.setParameters(new Parameter[]{p1, p2});
            }
            invoke.setParameter(p);
            this.tcapDialog.sendComponent((Component)invoke);
        }
        catch (TCAPException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    public void addProcessUnstructuredSSResponse(long invokeId, boolean lastResult, byte ussdDataCodingScheme, USSDString ussdString) throws MAPException {
        try {
            Object returnResult = null;
            returnResult = lastResult ? this.mapProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createTCResultLastRequest() : this.mapProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createTCResultRequest();
            returnResult.setInvokeId(Long.valueOf(invokeId));
            OperationCode oc = TcapFactory.createOperationCode((boolean)false, (Long)59L);
            returnResult.setOperationCode(oc);
            Parameter p1 = TcapFactory.createParameter();
            p1.setTagClass(0);
            p1.setTag(4);
            p1.setData(new byte[]{ussdDataCodingScheme});
            ussdString.encode();
            Parameter p2 = TcapFactory.createParameter();
            p2.setTagClass(0);
            p2.setTag(4);
            p2.setData(ussdString.getEncodedString());
            Parameter p = TcapFactory.createParameter();
            p.setTagClass(0);
            p.setTag(16);
            p.setParameters(new Parameter[]{p1, p2});
            returnResult.setParameter(p);
            this.tcapDialog.sendComponent((Component)returnResult);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    public void addUnstructuredSSRequest(byte ussdDataCodingScheme, USSDString ussdString) throws MAPException {
        Invoke invoke = this.mapProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createTCInvokeRequest();
        try {
            invoke.setInvokeId(this.tcapDialog.getNewInvokeId());
            OperationCode oc = TcapFactory.createOperationCode((boolean)false, (Long)60L);
            invoke.setOperationCode(oc);
            Parameter p1 = TcapFactory.createParameter();
            p1.setTagClass(0);
            p1.setTag(4);
            p1.setData(new byte[]{ussdDataCodingScheme});
            ussdString.encode();
            Parameter p2 = TcapFactory.createParameter();
            p2.setTagClass(0);
            p2.setTag(4);
            p2.setData(ussdString.getEncodedString());
            Parameter p = TcapFactory.createParameter();
            p.setTagClass(0);
            p.setTag(16);
            p.setParameters(new Parameter[]{p1, p2});
            invoke.setParameter(p);
            this.tcapDialog.sendComponent((Component)invoke);
        }
        catch (TCAPException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    public void addUnstructuredSSResponse(long invokeId, boolean lastResult, byte ussdDataCodingScheme, USSDString ussdString) throws MAPException {
        try {
            Object returnResult = null;
            returnResult = lastResult ? this.mapProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createTCResultLastRequest() : this.mapProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createTCResultRequest();
            returnResult.setInvokeId(Long.valueOf(invokeId));
            OperationCode oc = TcapFactory.createOperationCode((boolean)false, (Long)60L);
            returnResult.setOperationCode(oc);
            Parameter p1 = TcapFactory.createParameter();
            p1.setTagClass(0);
            p1.setTag(4);
            p1.setData(new byte[]{ussdDataCodingScheme});
            ussdString.encode();
            Parameter p2 = TcapFactory.createParameter();
            p2.setTagClass(0);
            p2.setTag(4);
            p2.setData(ussdString.getEncodedString());
            Parameter p = TcapFactory.createParameter();
            p.setTagClass(0);
            p.setTag(16);
            p.setParameters(new Parameter[]{p1, p2});
            returnResult.setParameter(p);
            this.tcapDialog.sendComponent((Component)returnResult);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    public MAPApplicationContext getAppCntx() {
        return this.appCntx;
    }

    public boolean isMapAcceptInfoFired() {
        return this.mapAcceptInfoFired;
    }

    public void setMapAcceptInfoFired(boolean mapAcceptInfoFired) {
        this.mapAcceptInfoFired = mapAcceptInfoFired;
    }
}

