/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.BitSet;
import org.mobicents.protocols.ss7.map.GSMCharset;

public class GSMCharsetEncoder
extends CharsetEncoder {
    int bitpos = 0;
    byte carryOver;
    byte[] mask = new byte[]{1, 2, 4, 8, 16, 32, 64};
    BitSet bitSet = new BitSet();
    static final byte ESCAPE = 27;
    byte rawData = 0;

    protected GSMCharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar) {
        super(cs, averageBytesPerChar, maxBytesPerChar);
        this.implReset();
    }

    protected void implReset() {
        this.bitpos = 0;
        this.carryOver = 0;
        this.bitSet.clear();
    }

    protected CoderResult implFlush(ByteBuffer out) {
        if (!out.hasRemaining()) {
            return CoderResult.OVERFLOW;
        }
        return CoderResult.UNDERFLOW;
    }

    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        block0: while (in.hasRemaining()) {
            char c = in.get();
            for (int i = 0; i < GSMCharset.BYTE_TO_CHAR.length; ++i) {
                if (GSMCharset.BYTE_TO_CHAR[i] != c) continue;
                this.rawData = (byte)i;
                for (int j = 0; j < this.mask.length; ++j) {
                    if ((this.rawData & this.mask[j]) == this.mask[j]) {
                        this.bitSet.set(this.bitpos);
                    }
                    ++this.bitpos;
                }
                continue block0;
            }
        }
        int b = 0;
        for (int count = 0; count < this.bitpos; ++count) {
            if (count > 0 && count % 8 == 0) {
                out.put((byte)(b & 0xFF));
                b = 0;
            }
            if (!this.bitSet.get(count)) continue;
            b |= 1 << count % 8;
        }
        if (this.bitpos % 8 != 0) {
            out.put((byte)(b & 0xFF));
        }
        return CoderResult.UNDERFLOW;
    }
}

