/*
 * Decompiled with CFR 0.152.
 */
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.indicator.NumberingPlan;
import org.mobicents.protocols.ss7.map.MAPStackImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPDialogListener;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.MAPServiceListener;
import org.mobicents.protocols.ss7.map.api.MAPStack;
import org.mobicents.protocols.ss7.map.api.MapServiceFactory;
import org.mobicents.protocols.ss7.map.api.dialog.AddressNature;
import org.mobicents.protocols.ss7.map.api.dialog.AddressString;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAcceptInfo;
import org.mobicents.protocols.ss7.map.api.dialog.MAPCloseInfo;
import org.mobicents.protocols.ss7.map.api.dialog.MAPOpenInfo;
import org.mobicents.protocols.ss7.map.api.dialog.MAPProviderAbortInfo;
import org.mobicents.protocols.ss7.map.api.dialog.MAPRefuseInfo;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortInfo;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSIndication;
import org.mobicents.protocols.ss7.map.api.service.supplementary.USSDString;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSIndication;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.SccpStack;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

public class MAPExample
implements MAPDialogListener,
MAPServiceListener {
    private MAPStack mapStack;
    private MAPProvider mapProvider;
    MapServiceFactory servFact;
    SccpAddress destAddress = null;
    AddressString destReference = this.servFact.createAddressString(AddressNature.international_number, org.mobicents.protocols.ss7.map.api.dialog.NumberingPlan.land_mobile, "204208300008002");
    SccpAddress origAddress = null;
    AddressString origReference = this.servFact.createAddressString(AddressNature.international_number, org.mobicents.protocols.ss7.map.api.dialog.NumberingPlan.ISDN, "31628968300");

    MAPExample(SccpProvider sccpPprovider, SccpAddress address, SccpAddress remoteAddress) {
        this.origAddress = address;
        this.destAddress = remoteAddress;
        this.mapStack = new MAPStackImpl(sccpPprovider, this.origAddress);
        this.mapProvider = this.mapStack.getMAPProvider();
        this.servFact = this.mapProvider.getMapServiceFactory();
        this.mapProvider.addMAPDialogListener((MAPDialogListener)this);
        this.mapProvider.addMAPServiceListener((MAPServiceListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SccpProvider getSccpProvider() throws NamingException {
        InitialContext ctx = new InitialContext();
        try {
            String providerJndiName = "/mobicents/ss7/sccp";
            SccpProvider sccpProvider = ((SccpStack)ctx.lookup(providerJndiName)).getSccpProvider();
            return sccpProvider;
        }
        finally {
            ctx.close();
        }
    }

    private static SccpAddress createLocalAddress() {
        GlobalTitle gt = GlobalTitle.getInstance((int)NatureOfAddress.NATIONAL.getValue(), (NumberingPlan)NumberingPlan.ISDN_MOBILE, (NatureOfAddress)NatureOfAddress.NATIONAL, (String)"1234");
        return new SccpAddress(gt, 0);
    }

    private static SccpAddress createRemoteAddress() {
        GlobalTitle gt = GlobalTitle.getInstance((int)NatureOfAddress.NATIONAL.getValue(), (NumberingPlan)NumberingPlan.ISDN_MOBILE, (NatureOfAddress)NatureOfAddress.NATIONAL, (String)"1572582");
        return new SccpAddress(gt, 0);
    }

    public void run() throws Exception {
        MAPDialog mapDialog = this.mapProvider.createNewDialog(MAPApplicationContext.networkUnstructuredSsContextV2, this.destAddress, this.destReference, this.origAddress, this.origReference);
        byte ussdDataCodingScheme = 15;
        USSDString ussdString = this.servFact.createUSSDString("*125*+31628839999#", null);
        AddressString msisdn = this.servFact.createAddressString(AddressNature.international_number, org.mobicents.protocols.ss7.map.api.dialog.NumberingPlan.ISDN, "31628838002");
        mapDialog.addProcessUnstructuredSSRequest(ussdDataCodingScheme, ussdString, msisdn);
        mapDialog.send();
    }

    public void onMAPAcceptInfo(MAPAcceptInfo mapAccptInfo) {
    }

    public void onMAPCloseInfo(MAPCloseInfo mapCloseInfo) {
    }

    public void onMAPOpenInfo(MAPOpenInfo mapOpenInfo) {
    }

    public void onMAPProviderAbortInfo(MAPProviderAbortInfo mapProviderAbortInfo) {
    }

    public void onMAPRefuseInfo(MAPRefuseInfo mapRefuseInfo) {
    }

    public void onMAPUserAbortInfo(MAPUserAbortInfo mapUserAbortInfo) {
    }

    public void onProcessUnstructuredSSIndication(ProcessUnstructuredSSIndication procUnstrInd) {
    }

    public void onUnstructuredSSIndication(UnstructuredSSIndication unstrInd) {
    }

    public static void main(String[] args) throws Exception {
        SccpProvider sccpProvider = MAPExample.getSccpProvider();
        SccpAddress localAddress = MAPExample.createLocalAddress();
        SccpAddress remoteAddress = MAPExample.createRemoteAddress();
        MAPExample example = new MAPExample(sccpProvider, localAddress, remoteAddress);
        example.run();
    }
}

