/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and/or its affiliates, and individual
 * contributors as indicated by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a full listing
 * of individual contributors.
 * 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU General Public License, v. 2.0.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License,
 * v. 2.0 along with this distribution; if not, write to the Free 
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */
package org.mobicents.protocols.ss7.map.api.primitives;

/**
 * @author amit bhayani
 * 
 */
public enum AlertingLevel {
	Level0((byte) 0), Level1((byte) 1), Level2((byte) 2);

	private final byte level;

	private AlertingLevel(byte level) {
		this.level = level;
	}

	public byte getLevel() {
		return this.level;
	}

	public static AlertingLevel getInstanc(byte level) {
		switch (level) {
		case 0:
			return Level0;
		case 1:
			return Level1;
		case 2:
			return Level2;
		default:
			return null;
		}
	}
}
