/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.service.xmppcomponent;

import java.util.Arrays;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.mobicents.slee.resource.xmpp.XmppResourceAdaptorSbbInterface;

public abstract class XMPPComponentSbb
implements Sbb {
    private SbbContext sbbContext;
    private XmppResourceAdaptorSbbInterface xmppSbbInterface;
    private final String componentPropertiesFile = "component.properties";
    private final String servicediscoveryPropertiesFile = "servicediscovery.properties";
    private Properties properties;
    private final Class[] packetsToListen = new Class[]{Message.class, Presence.class, IQ.class, DiscoverInfo.class, DiscoverItems.class};

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.xmppSbbInterface = (XmppResourceAdaptorSbbInterface)myEnv.lookup("slee/resources/xmpp/2.0/xmppinterface");
            this.properties = new Properties(System.getProperties());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    protected SbbContext getSbbContext() {
        return this.sbbContext;
    }

    public void onStartServiceEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            ServiceActivity sa = ((ServiceActivityFactory)myEnv.lookup("slee/serviceactivity/factory")).getActivity();
            if (sa.equals(aci.getActivity())) {
                this.properties.load(this.getClass().getResourceAsStream("component.properties"));
                System.setProperties(this.properties);
                this.xmppSbbInterface.connectComponent(this.properties.getProperty("org.mobicents.slee.service.xmppcomponent.CONNECTIONID"), this.properties.getProperty("org.mobicents.slee.service.xmppcomponent.SERVERHOST"), Integer.parseInt(this.properties.getProperty("org.mobicents.slee.service.xmppcomponent.SERVERPORT")), this.properties.getProperty("org.mobicents.slee.service.xmppcomponent.SERVICENAME"), this.properties.getProperty("org.mobicents.slee.service.xmppcomponent.COMPONENTNAME"), this.properties.getProperty("org.mobicents.slee.service.xmppcomponent.COMPONENTSECRET"), Arrays.asList(this.packetsToListen));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPresence(Presence packet, ActivityContextInterface aci) {
        if (packet.getTo().equalsIgnoreCase(this.properties.getProperty("org.mobicents.slee.service.xmppcomponent.COMPONENTNAME"))) {
            Presence reply = null;
            if (packet.getType() == Presence.Type.SUBSCRIBE) {
                reply = new Presence(Presence.Type.SUBSCRIBED);
            } else if (packet.getType() == Presence.Type.UNSUBSCRIBE) {
                reply = new Presence(Presence.Type.UNSUBSCRIBED);
            }
            if (packet.getType() == Presence.Type.AVAILABLE) {
                reply = new Presence(Presence.Type.AVAILABLE);
            }
            if (reply != null) {
                reply.setFrom(packet.getTo());
                reply.setTo(packet.getFrom());
                System.out.println("XMPP Component - sending PRESENCE reply with packet " + reply.toXML());
                this.xmppSbbInterface.sendPacket(this.properties.getProperty("org.mobicents.slee.service.xmppcomponent.CONNECTIONID"), (Packet)reply);
            }
        }
    }

    public void onDiscoverInfo(DiscoverInfo packet, ActivityContextInterface aci) {
        Properties p = new Properties();
        try {
            p.load(this.getClass().getResourceAsStream("servicediscovery.properties"));
            if (packet.getTo().equalsIgnoreCase(this.properties.getProperty("org.mobicents.slee.service.xmppcomponent.COMPONENTNAME")) && packet.getType().equals(IQ.Type.GET)) {
                String feature;
                String identityType;
                String identityCategory;
                String identityName;
                DiscoverInfo reply = new DiscoverInfo();
                int i = 1;
                while ((identityName = p.getProperty("org.mobicents.slee.service.xmppcomponent.IDENTITY." + i + ".NAME")) != null && (identityCategory = p.getProperty("org.mobicents.slee.service.xmppcomponent.IDENTITY." + i + ".CATEGORY")) != null && (identityType = p.getProperty("org.mobicents.slee.service.xmppcomponent.IDENTITY." + i + ".TYPE")) != null) {
                    DiscoverInfo.Identity identity = new DiscoverInfo.Identity(identityCategory, identityName);
                    identity.setType(identityType);
                    reply.addIdentity(identity);
                    ++i;
                }
                int i2 = 1;
                while ((feature = p.getProperty("org.mobicents.slee.service.xmppcomponent.FEATURE." + i2)) != null) {
                    reply.addFeature(feature);
                    ++i2;
                }
                reply.setTo(packet.getFrom());
                reply.setFrom(packet.getTo());
                reply.setType(IQ.Type.RESULT);
                reply.setPacketID(packet.getPacketID());
                System.out.println("XMPP Component - sending disco info with packet " + reply.toXML());
                this.xmppSbbInterface.sendPacket(this.properties.getProperty("org.mobicents.slee.service.xmppcomponent.CONNECTIONID"), (Packet)reply);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            ServiceActivity sa = ((ServiceActivityFactory)myEnv.lookup("slee/serviceactivity/factory")).getActivity();
            if (sa.equals(aci.getActivity())) {
                this.xmppSbbInterface.disconnect(this.properties.getProperty("org.mobicents.slee.service.xmppcomponent.CONNECTIONID"));
                Properties p = new Properties(System.getProperties());
                p.remove("org.mobicents.slee.service.xmppcomponent.CONNECTIONID");
                p.remove("org.mobicents.slee.service.xmppcomponent.SERVERHOST");
                p.remove("org.mobicents.slee.service.xmppcomponent.SERVERPORT");
                p.remove("org.mobicents.slee.service.xmppcomponent.SERVICENAME");
                p.remove("org.mobicents.slee.service.xmppcomponent.COMPONENTNAME");
                p.remove("org.mobicents.slee.service.xmppcomponent.COMPONENTSECRET");
                System.setProperties(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

