package org.mobicents.slee.training.example8.common;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.TransactionRolledbackLocalException;
import javax.slee.facilities.FacilityException;
import javax.slee.profile.AttributeNotIndexedException;
import javax.slee.profile.AttributeTypeMismatchException;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileID;
import javax.slee.profile.UnrecognizedAttributeException;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;

import org.apache.log4j.Logger;
import org.mobicents.slee.resource.lab.message.Message;
import org.mobicents.slee.resource.lab.ratype.MessageResourceAdaptorSbbInterface;
import org.mobicents.slee.training.example8.profile.EventControlProfileCMP;
import org.mobicents.slee.training.example8.profile.ProfileCreator;

/**
 * Base SBB offering profile lookup functionality
 * 
 * @author MoBitE info@mobite.co.in
 * 
 */
public abstract class SubscriptionProfileSbb implements Sbb {

	protected static Logger log = Logger
			.getLogger(SubscriptionProfileSbb.class);

	private MessageResourceAdaptorSbbInterface sbb2ra;

	public void setSbbContext(SbbContext context) {
		this.sbbContext = context;
		try {

			Context myEnv = (Context) new InitialContext()
					.lookup("java:comp/env");
			profileFacility = (ProfileFacility) myEnv
					.lookup("slee/facilities/profile");
			sbb2ra = (MessageResourceAdaptorSbbInterface) myEnv
					.lookup("slee/resources/raframe/1.0/sbb2ra");
		} catch (Exception ne) {
			log
					.error(
							"COULD NOT LOCATE RESOURCE IN JNDI: Check JNDI TREE or entity-binding for proper path!!!",
							ne);
		}
	}

	protected EventControlProfileCMP lookup(String activityId) {
		String profileTableName = new String();
		ProfileID profileID = null;
		EventControlProfileCMP event = null;
		try {
			profileTableName = "EventControl";

			// Looking for the ProfileID of the caller (address)
			profileID = getProfileFacility().getProfileByIndexedAttribute(
					profileTableName, "activityId", activityId);
			if (profileID != null) {

				event = getEventControlProfileCMP(profileID);
			} else {
				Message answer = getMessageResourceAdaptorSbbInterface()
						.getMessageFactory().createMessage("ERROR",
								" specified Activity Id Not Allowed !! ");
				// ... send it using the resource adaptor
				getMessageResourceAdaptorSbbInterface().send(answer);
			}
		} catch (NullPointerException e) {
			log.error(
					"Exception using the getProfileByIndexedAttribute method",
					e);
		} catch (UnrecognizedProfileTableNameException e) {
			log
					.error(
							"Exception in getting the Profile Specification in getControllerProfileCMP(profileID):"
									+ "The ProfileID object does not identify a Profile Table created from the Profile Specification",
							e);
		} catch (UnrecognizedProfileNameException e) {
			log
					.error(
							"Exception in getting the Profile Specification in getControllerProfileCMP(profileID):"
									+ "The ProfileID object does not identify a Profile within the Profile Table",
							e);
		} catch (TransactionRolledbackLocalException e) {
			log.error(e.getMessage(), e);
		} catch (FacilityException e) {
			log.error(e.getMessage(), e);
		} catch (UnrecognizedAttributeException e) {
			log.error(e.getMessage(), e);
		} catch (AttributeNotIndexedException e) {
			log.error(e.getMessage(), e);
		} catch (AttributeTypeMismatchException e) {
			log.error(e.getMessage(), e);
		}

		return event;
	}

	public void unsetSbbContext() {
		this.sbbContext = null;
	}

	public void sbbCreate() throws CreateException {
		ProfileCreator.createProfiles();
	}

	public void sbbPostCreate() throws CreateException {
	}

	public void sbbRemove() {
	}

	public void sbbPassivate() {
	}

	public void sbbActivate() {
	}

	public void sbbLoad() {
	}

	public void sbbStore() {
	}

	public void sbbExceptionThrown(Exception exception, Object event,
			ActivityContextInterface aci) {
	}

	public void sbbRolledBack(RolledBackContext context) {
	}

	protected final SbbContext getSbbContext() {
		return sbbContext;
	}

	protected final ProfileFacility getProfileFacility() {
		return profileFacility;
	}

	protected final SbbLocalObject getSbbLocalObject() {
		return sbbContext.getSbbLocalObject();
	}

	public abstract EventControlProfileCMP getEventControlProfileCMP(
			javax.slee.profile.ProfileID profileID)
			throws UnrecognizedProfileNameException,
			UnrecognizedProfileTableNameException;

	protected MessageResourceAdaptorSbbInterface getMessageResourceAdaptorSbbInterface() {
		return this.sbb2ra;
	}

	private SbbContext sbbContext;
	private ProfileFacility profileFacility;

	// public InitialEventSelector messageIDSelect(InitialEventSelector ies) {
	// Object event = ies.getEvent();
	// String messageId = null;
	//
	// if (event instanceof MessageEvent) {
	// // If request event, the convergence name to callId
	// messageId = ((MessageEvent) event).getMessage().getId();
	// if (messageId.equals("110")) {
	// System.out.println("The Message Id is " + messageId
	// + " and this is initial event");
	// ies.setInitialEvent(true);
	//
	// } else {
	// System.out.println("The Message Id is " + messageId
	// + " and this is NOT initial event");
	// ies.setInitialEvent(false);
	//
	// }
	// }
	//
	// return ies;
	// }

}
