/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.training.example6;

import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.facilities.TimerFacility;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.lab.message.Message;
import org.mobicents.slee.resource.lab.message.MessageEvent;
import org.mobicents.slee.resource.lab.ratype.MessageActivity;
import org.mobicents.slee.training.example6.BounceSbbUsage;
import org.mobicents.slee.training.example6.CommonSbb;

public abstract class BounceSbb
extends CommonSbb {
    private Logger logger = Logger.getLogger(BounceSbb.class);
    private TimerFacility timerFacility = null;

    public void sbbPostCreate() throws CreateException {
        super.sbbPostCreate();
        long currentTimeInSec = System.currentTimeMillis() / 1000L;
        this.setLastTimeAnyMessageReceived(currentTimeInSec);
    }

    public void onAnyEvent(MessageEvent event, ActivityContextInterface ac) {
        this.logger.info((Object)("BounceSbb: " + this + ": received an incoming Request. CallID = " + event.getMessage().getId() + ". Command = " + event.getMessage().getCommand()));
        try {
            MessageActivity activity = (MessageActivity)ac.getActivity();
            activity.anyReceived();
            this.logger.info((Object)("ANY Event: INIT:" + activity.getInitCounter() + " ANY:" + activity.getAnyCounter() + " END:" + activity.getEndCounter() + " Valid state: " + activity.isValid(event.getMessage().getCommandId())));
        }
        catch (Exception e) {
            this.logger.warn((Object)"Exception during onAnyEvent: ", (Throwable)e);
        }
        this.getDefaultSbbUsageParameterSet().incrementNumberOfAnyMessage(1L);
        long currentTimeInSec = System.currentTimeMillis() / 1000L;
        this.getDefaultSbbUsageParameterSet().sampleTimeBetweenAnyMessages(currentTimeInSec - this.getLastTimeAnyMessageReceived());
        this.setLastTimeAnyMessageReceived(currentTimeInSec);
        Message answer = this.getMessageResourceAdaptorSbbInterface().getMessageFactory().createMessage(event.getMessage().getId(), "Command bounced by BounceSbb: " + event.getMessage().getCommand());
        this.getMessageResourceAdaptorSbbInterface().send(answer);
    }

    public void onEndEvent(MessageEvent event, ActivityContextInterface ac) {
        this.logger.info((Object)("BounceSbb: " + this + ": received an incoming Request. CallID = " + event.getMessage().getId() + ". Command = " + event.getMessage().getCommand()));
        try {
            MessageActivity activity = (MessageActivity)ac.getActivity();
            activity.endReceived();
            this.logger.info((Object)("END Event: INIT:" + activity.getInitCounter() + " ANY:" + activity.getAnyCounter() + " END:" + activity.getEndCounter() + " Valid state: " + activity.isValid(event.getMessage().getCommandId())));
        }
        catch (Exception e) {
            this.logger.warn((Object)"Exception during onEndEvent: ", (Throwable)e);
        }
    }

    public void onInitEvent(MessageEvent event, ActivityContextInterface ac) {
        this.logger.info((Object)("BounceSbb: " + this + ": received an incoming Request. CallID = " + event.getMessage().getId() + ". Command = " + event.getMessage().getCommand()));
        try {
            MessageActivity activity = (MessageActivity)ac.getActivity();
            activity.initReceived();
            this.logger.info((Object)("INIT Event: INIT:" + activity.getInitCounter() + " ANY:" + activity.getAnyCounter() + " END:" + activity.getEndCounter() + " Valid state: " + activity.isValid(event.getMessage().getCommandId())));
        }
        catch (Exception e) {
            this.logger.warn((Object)"Exception during onInitEvent: ", (Throwable)e);
        }
    }

    public abstract BounceSbbUsage getDefaultSbbUsageParameterSet();

    public abstract long getLastTimeAnyMessageReceived();

    public abstract void setLastTimeAnyMessageReceived(long var1);
}

