/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.example.sip11.fork;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.FactoryException;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.DialogForkedEvent;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;
import org.apache.log4j.Logger;

public abstract class SimpleSip11ForkTestSbb
implements Sbb {
    private SipActivityContextInterfaceFactory sipActivityContextInterfaceFactory;
    private SleeSipProvider sipFactoryProvider;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private TimerFacility timerFacility;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private NullActivityFactory nullActivityFactory;
    private static final Logger logger = Logger.getLogger(SimpleSip11ForkTestSbb.class);
    private static final long MSG_2_INVITE = 5000L;
    private static final long ACK_2_BYE = 20000L;
    private String peerHost = "127.0.0.1";
    private int peerPort = 5070;
    private static ContactHeader contactHeader;
    private String transport = "udp";
    private SbbContext sbbContext;

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        logger.info((Object)" -- Starting Sip11 fork load test --");
        logger.info((Object)" -- Started Sip11 fork load test --");
    }

    public void onMessageRequest(RequestEvent event, ActivityContextInterface aci) {
        if (this.getServiceState() == null) {
            this.setServiceState(ServiceState.RECEIVED_MSG);
        }
        switch (this.getServiceState()) {
            case RECEIVED_MSG: {
                try {
                    Request request = event.getRequest();
                    ServerTransaction stt = event.getServerTransaction();
                    if (stt == null) {
                        stt = this.sipFactoryProvider.getNewServerTransaction(request);
                    }
                    stt.sendResponse(this.messageFactory.createResponse(200, request));
                    String content = null;
                    if (content != null && content.toLowerCase().contains("cancel")) {
                        this.setMakeCancel(new Boolean(true));
                    } else {
                        this.setMakeCancel(new Boolean(false));
                    }
                    this.setStoredRequest(request);
                    TimerOptions options = new TimerOptions();
                    options.setPersistent(true);
                    NullActivity timerBus = this.nullActivityFactory.createNullActivity();
                    ActivityContextInterface timerBusACI = this.nullACIFactory.getActivityContextInterface(timerBus);
                    timerBusACI.attach(this.sbbContext.getSbbLocalObject());
                    this.timerFacility.setTimer(timerBusACI, null, System.currentTimeMillis() + 5000L, options);
                    this.setServiceState(ServiceState.INVITE_TIMER);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                try {
                    Request request = event.getRequest();
                    ServerTransaction stt = event.getServerTransaction();
                    if (stt == null) {
                        stt = this.sipFactoryProvider.getNewServerTransaction(request);
                    }
                    stt.sendResponse(this.messageFactory.createResponse(200, request));
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void on1xxResponse(ResponseEvent event, ActivityContextInterface aci) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("  ---  1xx Activity: " + aci.getActivity() + " Event:\n" + event.getResponse()));
        }
    }

    public void on2xxResponse(ResponseEvent event, ActivityContextInterface aci) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("  ---  2xx Activity: " + aci.getActivity() + " Event:\n" + event.getResponse()));
        }
        String method = ((CSeqHeader)event.getResponse().getHeader("CSeq")).getMethod();
        DialogActivity da = (DialogActivity)aci.getActivity();
        switch (this.getServiceState()) {
            case SENT_INVITE: {
                if (!method.equals("INVITE")) break;
                try {
                    Request ack = da.createAck(((CSeqHeader)event.getResponse().getHeader("CSeq")).getSeqNumber());
                    da.sendAck(ack);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("SENT ACK:\n" + ack));
                    }
                    this.setServiceState(ServiceState.SENT_ACK);
                    TimerOptions options = new TimerOptions();
                    options.setPersistent(true);
                    NullActivity timerBus = this.nullActivityFactory.createNullActivity();
                    ActivityContextInterface timerBusACI = this.nullACIFactory.getActivityContextInterface(timerBus);
                    timerBusACI.attach(this.sbbContext.getSbbLocalObject());
                    this.timerFacility.setTimer(timerBusACI, null, System.currentTimeMillis() + 20000L, options);
                    this.setServiceState(ServiceState.BYE_TIMER);
                }
                catch (SipException e) {
                    e.printStackTrace();
                }
                catch (InvalidArgumentException e) {
                    e.printStackTrace();
                }
                catch (TransactionRequiredLocalException e) {
                    e.printStackTrace();
                }
                catch (FactoryException e) {
                    e.printStackTrace();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                catch (UnrecognizedActivityException e) {
                    e.printStackTrace();
                }
                break;
            }
            case BYE_TIMER: {
                if (!method.equals("INVITE")) break;
                try {
                    Request ack = da.createAck(((CSeqHeader)event.getResponse().getHeader("CSeq")).getSeqNumber());
                    da.sendAck(ack);
                    if (!logger.isInfoEnabled()) break;
                    logger.info((Object)("SENT ACK again!:\n" + ack));
                }
                catch (SipException e) {
                    e.printStackTrace();
                }
                catch (InvalidArgumentException e) {
                    e.printStackTrace();
                }
                catch (TransactionRequiredLocalException e) {
                    e.printStackTrace();
                }
                catch (FactoryException e) {
                    e.printStackTrace();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                break;
            }
            case SENT_ACK: {
                try {
                    TimerOptions options = new TimerOptions();
                    options.setPersistent(true);
                    NullActivity timerBus = this.nullActivityFactory.createNullActivity();
                    ActivityContextInterface timerBusACI = this.nullACIFactory.getActivityContextInterface(timerBus);
                    timerBusACI.attach(this.sbbContext.getSbbLocalObject());
                    this.timerFacility.setTimer(timerBusACI, null, System.currentTimeMillis() + 20000L, options);
                    this.setServiceState(ServiceState.BYE_TIMER);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void on4xxResponse(ResponseEvent event, ActivityContextInterface aci) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("  ---  4xx Activity: " + aci.getActivity() + " Event:\n" + event.getResponse()));
        }
    }

    public void onDialogForkEvent(DialogForkedEvent event, ActivityContextInterface aci) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("  ---  DialogForked Activity: " + aci.getActivity() + " Other: " + event.getForkedDialog() + " Event:\n" + event.getResponse()));
        }
        if (this.getServiceState() == ServiceState.SENT_INVITE) {
            try {
                DialogActivity da = (DialogActivity)event.getForkedDialog();
                ActivityContextInterface localAci = this.sipActivityContextInterfaceFactory.getActivityContextInterface(da);
                if (localAci.getActivity() != null) {
                    localAci.attach(this.getSbbContext().getSbbLocalObject());
                    this.setChildDialog(localAci);
                }
                if (this.getMakeCancel().booleanValue()) {
                    ClientTransaction inviteCt = event.getClientTransaction();
                    Request cancelR = inviteCt.createCancel();
                    ((ToHeader)cancelR.getHeader("To")).setTag(da.getRemoteTag());
                    ClientTransaction ct = this.sipFactoryProvider.getNewClientTransaction(cancelR);
                    ct.sendRequest();
                    da.sendRequest(cancelR);
                }
            }
            catch (FactoryException e) {
                e.printStackTrace();
            }
            catch (UnrecognizedActivityException e) {
            }
            catch (SipException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
    }

    public InitialEventSelector callIDSelect(InitialEventSelector ies) {
        Object event = ies.getEvent();
        String callId = null;
        if (event instanceof ResponseEvent) {
            ies.setInitialEvent(false);
            return ies;
        }
        if (event instanceof RequestEvent) {
            Request request = ((RequestEvent)event).getRequest();
            callId = !request.getMethod().equals("ACK") ? ((ViaHeader)request.getHeaders("Via").next()).getBranch() : ((ViaHeader)request.getHeaders("Via").next()).getBranch() + "_ACK";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting convergence name to: " + callId));
        }
        ies.setCustomName(callId);
        logger.info((Object)("IES: " + ies.getCustomName() + "  " + ies.isInitialEvent()));
        return ies;
    }

    public void onTimeEvent(TimerEvent event, ActivityContextInterface timerAci) {
        timerAci.detach(this.getSbbContext().getSbbLocalObject());
        switch (this.getServiceState()) {
            case INVITE_TIMER: {
                try {
                    Request request = this.getStoredRequest();
                    ContactHeader remoteContact = (ContactHeader)request.getHeader("Contact");
                    FromHeader inFromHeader = (FromHeader)request.getHeader("From");
                    ToHeader inToHeader = (ToHeader)request.getHeader("To");
                    SipURI requestURI = (SipURI)inFromHeader.getAddress().getURI();
                    FromHeader fromHeader = this.headerFactory.createFromHeader(inToHeader.getAddress(), "LoadTest_" + Math.random() * 100000.0);
                    ToHeader toHeader = this.headerFactory.createToHeader(inFromHeader.getAddress(), null);
                    ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
                    ViaHeader viaHeader = this.sipFactoryProvider.getLocalVia(this.transport, null);
                    viaHeaders.add(viaHeader);
                    ArrayList<RouteHeader> routeList = new ArrayList<RouteHeader>();
                    ListIterator rrLit = request.getHeaders("Record-Route");
                    while (rrLit.hasNext()) {
                        RecordRouteHeader rrh = (RecordRouteHeader)rrLit.next();
                        RouteHeader rh = this.sipFactoryProvider.getHeaderFactory().createRouteHeader(rrh.getAddress());
                        Iterator pIt = rrh.getParameterNames();
                        while (pIt.hasNext()) {
                            String pName = (String)pIt.next();
                            try {
                                rh.setParameter(pName, rrh.getParameter(pName));
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                        }
                        routeList.add(0, rh);
                    }
                    ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                    CallIdHeader callIdHeader = (CallIdHeader)request.getHeader("Call-ID");
                    CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(1L, "INVITE");
                    MaxForwardsHeader maxForwards = this.headerFactory.createMaxForwardsHeader(70);
                    Request inviteRequest = this.messageFactory.createRequest((URI)requestURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
                    SipURI contactURI = this.addressFactory.createSipURI(((SipURI)fromHeader.getAddress().getURI()).getUser(), this.sipFactoryProvider.getListeningPoints()[0].getIPAddress());
                    contactURI.setPort(this.sipFactoryProvider.getListeningPoint("udp").getPort());
                    Address contactAddress = this.addressFactory.createAddress((URI)contactURI);
                    contactAddress.setDisplayName(((SipURI)fromHeader.getAddress().getURI()).getUser());
                    contactHeader = this.headerFactory.createContactHeader(contactAddress);
                    inviteRequest.addHeader((Header)contactHeader);
                    for (RouteHeader h : routeList) {
                        inviteRequest.addLast((Header)h);
                    }
                    Header extensionHeader = this.headerFactory.createHeader("My-Header", "my header value");
                    inviteRequest.addHeader(extensionHeader);
                    String sdpData = "v=0\r\no=4855 13760799956958020 13760799956958020 IN IP4  129.6.55.78\r\ns=mysession session\r\np=+46 8 52018010\r\nc=IN IP4  129.6.55.78\r\nt=0 0\r\nm=audio 6022 RTP/AVP 0 4 18\r\na=rtpmap:0 PCMU/8000\r\na=rtpmap:4 G723/8000\r\na=rtpmap:18 G729A/8000\r\na=ptime:20\r\n";
                    byte[] contents = sdpData.getBytes();
                    inviteRequest.setContent((Object)contents, contentTypeHeader);
                    extensionHeader = this.headerFactory.createHeader("My-Other-Header", "my new header value ");
                    inviteRequest.addHeader(extensionHeader);
                    Header callInfoHeader = this.headerFactory.createHeader("Call-Info", "<http://www.antd.nist.gov>");
                    inviteRequest.addHeader(callInfoHeader);
                    ClientTransaction inviteTid = this.sipFactoryProvider.getNewClientTransaction(inviteRequest);
                    DialogActivity dialog = (DialogActivity)this.sipFactoryProvider.getNewDialog((Transaction)inviteTid);
                    ActivityContextInterface initialDialogAci = this.sipActivityContextInterfaceFactory.getActivityContextInterface(dialog);
                    initialDialogAci.attach(this.getSbbContext().getSbbLocalObject());
                    this.setOriginalDialog(initialDialogAci);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Sending INVITE: \n" + inviteRequest));
                    }
                    inviteTid.sendRequest();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                this.setServiceState(ServiceState.SENT_INVITE);
                break;
            }
            case BYE_TIMER: {
                ArrayList<DialogActivity> das = new ArrayList<DialogActivity>();
                for (ActivityContextInterface aci : this.getSbbContext().getActivities()) {
                    if (aci.getActivity() == null || !(aci.getActivity() instanceof DialogActivity)) continue;
                    das.add((DialogActivity)aci.getActivity());
                }
                for (DialogActivity da : das) {
                    try {
                        Request byeRequest = da.createRequest("BYE");
                        da.sendRequest(byeRequest);
                        if (!logger.isInfoEnabled()) continue;
                        logger.info((Object)("== SENDING BYE: " + da + "\n" + byeRequest));
                    }
                    catch (SipException e) {
                        e.printStackTrace();
                    }
                }
                this.setServiceState(ServiceState.SENT_BYE);
            }
        }
    }

    public void onActivityEndEvent(ActivityEndEvent end, ActivityContextInterface aci) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("  ---  ActivityEnd; Activity: " + aci.getActivity()));
            logger.debug((Object)("Original ACI:" + this.getOriginalDialog()));
            logger.debug((Object)("Original Activity:" + (this.getOriginalDialog() == null ? null : this.getOriginalDialog().getActivity())));
            logger.debug((Object)("Child ACI:" + this.getChildDialog()));
            logger.debug((Object)("Child Activity:" + (this.getChildDialog() == null ? null : this.getChildDialog().getActivity())));
        }
    }

    public abstract void setOriginalDialog(ActivityContextInterface var1);

    public abstract ActivityContextInterface getOriginalDialog();

    public abstract void setChildDialog(ActivityContextInterface var1);

    public abstract ActivityContextInterface getChildDialog();

    public abstract Boolean getMakeCancel();

    public abstract void setMakeCancel(Boolean var1);

    public abstract Request getStoredRequest();

    public abstract void setStoredRequest(Request var1);

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.sipActivityContextInterfaceFactory = (SipActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainsip/1.2/acifactory");
            this.sipFactoryProvider = (SleeSipProvider)ctx.lookup("slee/resources/jainsip/1.2/provider");
            this.addressFactory = this.sipFactoryProvider.getAddressFactory();
            this.headerFactory = this.sipFactoryProvider.getHeaderFactory();
            this.messageFactory = this.sipFactoryProvider.getMessageFactory();
            this.timerFacility = (TimerFacility)ctx.lookup("slee/facilities/timer");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)ctx.lookup("slee/nullactivity/activitycontextinterfacefactory");
            this.nullActivityFactory = (NullActivityFactory)ctx.lookup("slee/nullactivity/factory");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    protected SbbContext getSbbContext() {
        return this.sbbContext;
    }

    protected abstract ServiceState getServiceState();

    protected abstract void setServiceState(ServiceState var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServiceState {
        RECEIVED_MSG,
        INVITE_TIMER,
        SENT_INVITE,
        SENT_ACK,
        BYE_TIMER,
        SENT_BYE;

    }
}

