package org.mobicents.slee.example.sip11.fork;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.FactoryException;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.SbbContext;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;

import org.apache.log4j.Logger;

import net.java.slee.resource.sip.CancelRequestEvent;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.DialogForkedEvent;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;

public abstract class SimpleSip11ForkTestSbb implements javax.slee.Sbb {

	private SipActivityContextInterfaceFactory sipActivityContextInterfaceFactory;
	private SleeSipProvider sipFactoryProvider;
	private AddressFactory addressFactory;
	private HeaderFactory headerFactory;
	private MessageFactory messageFactory;
	private TimerFacility timerFacility;
	private NullActivityContextInterfaceFactory nullACIFactory;
	private NullActivityFactory nullActivityFactory;
	private static final Logger logger = Logger.getLogger(SimpleSip11ForkTestSbb.class);
	private static final long MSG_2_INVITE = 5000;
	private static final long ACK_2_BYE = 20000;
	// Proxy :)
	private String peerHost = "127.0.0.1";

	private int peerPort = 5070;

	private static ContactHeader contactHeader;

	private String transport = "udp";

	// Initial request
	public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
		// ACI is the server transaction activity
		logger.info(" -- Starting Sip11 fork load test --");
		if (false) {
			try {
				String fromName = "BigGuy";
				String fromSipAddress = "here.com";
				String fromDisplayName = "The Master Blaster";

				String toSipAddress = "there.com";
				String toUser = "LittleGuy";
				String toDisplayName = "The Little Blister";

				// create >From Header
				SipURI fromAddress = addressFactory.createSipURI(fromName, fromSipAddress);

				Address fromNameAddress = addressFactory.createAddress(fromAddress);
				fromNameAddress.setDisplayName(fromDisplayName);
				FromHeader fromHeader = headerFactory.createFromHeader(fromNameAddress, "12345");

				// create To Header
				SipURI toAddress = addressFactory.createSipURI(toUser, toSipAddress);
				Address toNameAddress = addressFactory.createAddress(toAddress);
				toNameAddress.setDisplayName(toDisplayName);
				ToHeader toHeader = headerFactory.createToHeader(toNameAddress, null);

				// create Request URI
				String peerHostPort = peerHost + ":" + peerPort;
				SipURI requestURI = addressFactory.createSipURI(toUser, peerHostPort);

				// Create ViaHeaders

				ArrayList viaHeaders = new ArrayList();
				ViaHeader viaHeader = this.sipFactoryProvider.getLocalVia(transport, null);

				// add via headers
				viaHeaders.add(viaHeader);

				SipURI sipuri = addressFactory.createSipURI(null, peerHost);
				sipuri.setPort(peerPort);
				sipuri.setLrParam();

				RouteHeader routeHeader = headerFactory.createRouteHeader(addressFactory.createAddress(sipuri));

				// Create ContentTypeHeader
				ContentTypeHeader contentTypeHeader = headerFactory.createContentTypeHeader("application", "sdp");

				// Create a new CallId header
				CallIdHeader callIdHeader = sipFactoryProvider.getNewCallId();

				// Create a new Cseq header
				CSeqHeader cSeqHeader = headerFactory.createCSeqHeader(1L, Request.INVITE);

				// Create a new MaxForwardsHeader
				MaxForwardsHeader maxForwards = headerFactory.createMaxForwardsHeader(70);

				// Create the request.
				Request request = messageFactory.createRequest(requestURI, Request.INVITE, callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
				// Create contact headers

				// Create the contact name address.
				SipURI contactURI = addressFactory.createSipURI(fromName, sipFactoryProvider.getListeningPoints()[0].getIPAddress());
				contactURI.setPort(sipFactoryProvider.getListeningPoint("udp").getPort());

				Address contactAddress = addressFactory.createAddress(contactURI);

				// Add the contact address.
				contactAddress.setDisplayName(fromName);

				contactHeader = headerFactory.createContactHeader(contactAddress);
				request.addHeader(contactHeader);

				// Dont use the Outbound Proxy. Use Lr instead.
				request.setHeader(routeHeader);

				// Add the extension header.
				Header extensionHeader = headerFactory.createHeader("My-Header", "my header value");
				request.addHeader(extensionHeader);

				String sdpData = "v=0\r\n" + "o=4855 13760799956958020 13760799956958020" + " IN IP4  129.6.55.78\r\n" + "s=mysession session\r\n" + "p=+46 8 52018010\r\n"
						+ "c=IN IP4  129.6.55.78\r\n" + "t=0 0\r\n" + "m=audio 6022 RTP/AVP 0 4 18\r\n" + "a=rtpmap:0 PCMU/8000\r\n" + "a=rtpmap:4 G723/8000\r\n"
						+ "a=rtpmap:18 G729A/8000\r\n" + "a=ptime:20\r\n";
				byte[] contents = sdpData.getBytes();

				request.setContent(contents, contentTypeHeader);

				extensionHeader = headerFactory.createHeader("My-Other-Header", "my new header value ");
				request.addHeader(extensionHeader);

				Header callInfoHeader = headerFactory.createHeader("Call-Info", "<http://www.antd.nist.gov>");
				request.addHeader(callInfoHeader);

				// Create the client transaction.
				ClientTransaction inviteTid = sipFactoryProvider.getNewClientTransaction(request);
				DialogActivity dialog = (DialogActivity) sipFactoryProvider.getNewDialog(inviteTid);
				ActivityContextInterface initialDialogAci = this.sipActivityContextInterfaceFactory.getActivityContextInterface(dialog);
				initialDialogAci.attach(getSbbContext().getSbbLocalObject());
				setOriginalDialog(initialDialogAci);
				// send the request out.

				logger.info(" -- Sending initial INVITE --");
				inviteTid.sendRequest();
				logger.info(" -- Sent initial INVITE --");
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			logger.info(" -- Started Sip11 fork load test --");
		}
	}

	public void onMessageRequest(RequestEvent event, ActivityContextInterface aci) {

		if (getServiceState() == null) {
			setServiceState(ServiceState.RECEIVED_MSG);
		}

		switch (getServiceState()) {
		case RECEIVED_MSG:
			try {
				Request request = event.getRequest();
				ServerTransaction stt = event.getServerTransaction();
				if (stt == null) {
					stt = sipFactoryProvider.getNewServerTransaction(request);
				}
				stt.sendResponse(messageFactory.createResponse(200, request));

				// setSentInvite(false);
				// String content = new String(request.getRawContent());
				String content = null;
				if (content != null && content.toLowerCase().contains("cancel"))
					setMakeCancel(new Boolean(true));
				else
					setMakeCancel(new Boolean(false));

				setStoredRequest(request);
				TimerOptions options = new TimerOptions();
				options.setPersistent(true);
				NullActivity timerBus = this.nullActivityFactory.createNullActivity();

				ActivityContextInterface timerBusACI = this.nullACIFactory.getActivityContextInterface(timerBus);
				timerBusACI.attach(sbbContext.getSbbLocalObject());
				this.timerFacility.setTimer(timerBusACI, null, System.currentTimeMillis() + MSG_2_INVITE, options);
				setServiceState(ServiceState.INVITE_TIMER);
			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		default:
			// This is rtr, our OK didnt make it, lets send ok and leave it as
			// it is
			try {
				Request request = event.getRequest();
				ServerTransaction stt = event.getServerTransaction();
				if (stt == null) {
					stt = sipFactoryProvider.getNewServerTransaction(request);
				}
				stt.sendResponse(messageFactory.createResponse(200, request));
			} catch (Exception e) {
				e.printStackTrace();
			}
			break;
		}
		// String method=event.getRequest().getMethod();
		// logger.error("MESSAGE r["+method+"]:["+((CallIdHeader)event.getRequest().getHeader(CallIdHeader.NAME)).getCallId()+"] "+System.currentTimeMillis());

	}

	// Responses
	public void on1xxResponse(ResponseEvent event, ActivityContextInterface aci) {
		if (logger.isInfoEnabled()) {
			logger.info("  ---  1xx Activity: " + aci.getActivity() + " Event:\n" + event.getResponse());
			
		}
		
	}

	public void on2xxResponse(ResponseEvent event, ActivityContextInterface aci) {
		if (logger.isInfoEnabled()) {
			logger.info("  ---  2xx Activity: " + aci.getActivity() + " Event:\n" + event.getResponse());
		}

		String method = ((CSeqHeader) event.getResponse().getHeader(CSeqHeader.NAME)).getMethod();
		DialogActivity da = (DialogActivity) aci.getActivity();
		switch (getServiceState()) {
		case SENT_INVITE:

			if (method.equals(Request.INVITE)) {

				try {
					Request ack = da.createAck(((CSeqHeader) event.getResponse().getHeader(CSeqHeader.NAME)).getSeqNumber());
					da.sendAck(ack);
					if (logger.isInfoEnabled()) {
						logger.info("SENT ACK:\n" + ack);
					}
					setServiceState(ServiceState.SENT_ACK);
					// logger.error("MESSAGE R["+_method+"]["+getServiceState()+"]:["+((CallIdHeader)event.getResponse().getHeader(CallIdHeader.NAME)).getCallId()+"] "+System.currentTimeMillis());
					TimerOptions options = new TimerOptions();
					options.setPersistent(true);
					NullActivity timerBus = this.nullActivityFactory.createNullActivity();

					ActivityContextInterface timerBusACI = this.nullACIFactory.getActivityContextInterface(timerBus);
					timerBusACI.attach(sbbContext.getSbbLocalObject());
					this.timerFacility.setTimer(timerBusACI, null, System.currentTimeMillis() + ACK_2_BYE, options);

					setServiceState(ServiceState.BYE_TIMER);
				} catch (SipException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InvalidArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (TransactionRequiredLocalException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (FactoryException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (NullPointerException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (UnrecognizedActivityException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}

			break;

		case BYE_TIMER:
			// This is rtr?
			if (method.equals(Request.INVITE))
				try {
					Request ack = da.createAck(((CSeqHeader) event.getResponse().getHeader(CSeqHeader.NAME)).getSeqNumber());
					da.sendAck(ack);
					if (logger.isInfoEnabled()) {
						logger.info("SENT ACK again!:\n" + ack);
					}

				} catch (SipException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InvalidArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (TransactionRequiredLocalException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (FactoryException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (NullPointerException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			break;
		case SENT_ACK:
			try {
				TimerOptions options = new TimerOptions();
				options.setPersistent(true);
				NullActivity timerBus = this.nullActivityFactory.createNullActivity();

				ActivityContextInterface timerBusACI = this.nullACIFactory.getActivityContextInterface(timerBus);
				timerBusACI.attach(sbbContext.getSbbLocalObject());
				this.timerFacility.setTimer(timerBusACI, null, System.currentTimeMillis() + ACK_2_BYE, options);

				setServiceState(ServiceState.BYE_TIMER);
			} catch (Exception e) {
				e.printStackTrace();
			}
			break;
		}

	}

	public void on4xxResponse(ResponseEvent event, ActivityContextInterface aci) {
		if (logger.isInfoEnabled()) {
			logger.info("  ---  4xx Activity: " + aci.getActivity() + " Event:\n" + event.getResponse());
		}
		// /String
		// _method=((CSeqHeader)event.getResponse().getHeader(CSeqHeader.NAME)).getMethod();
		// logger.error("MESSAGE R["+_method+"]:["+((CallIdHeader)event.getResponse().getHeader(CallIdHeader.NAME)).getCallId()+"] "+System.currentTimeMillis());
	}

	public void onDialogForkEvent(DialogForkedEvent event, ActivityContextInterface aci) {
		if (logger.isInfoEnabled()) {
			logger.info("  ---  DialogForked Activity: " + aci.getActivity() + " Other: " + event.getForkedDialog() + " Event:\n" + event.getResponse());
		}

		if (getServiceState() == ServiceState.SENT_INVITE) {
			ActivityContextInterface localAci;

			try {
				DialogActivity da = (DialogActivity) event.getForkedDialog();
				localAci = sipActivityContextInterfaceFactory.getActivityContextInterface(da);
				if (localAci.getActivity() != null) {
					localAci.attach(this.getSbbContext().getSbbLocalObject());
					setChildDialog(localAci);
				}
				if (getMakeCancel()) {
					// We send cancel on this
					ClientTransaction inviteCt = event.getClientTransaction();

					Request cancelR = inviteCt.createCancel();
					((ToHeader) cancelR.getHeader(ToHeader.NAME)).setTag(da.getRemoteTag());

					ClientTransaction ct = sipFactoryProvider.getNewClientTransaction(cancelR);
					// localAci=sipActivityContextInterfaceFactory.getActivityContextInterface(ct);
					// localAci.attach(getSbbContext().getSbbLocalObject());
					ct.sendRequest();

					da.sendRequest(cancelR);
				}
			} catch (FactoryException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (UnrecognizedActivityException e) {
				// logger.error("ACTIVITY ERROR : "+e.getActivity());
				// e.printStackTrace();
				// This will happen if forked dialog dies before this event is
				// delivered.
			} catch (SipException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (NullPointerException npe) {
				npe.printStackTrace();
			}
		}
	}

	public InitialEventSelector callIDSelect(InitialEventSelector ies) {
		Object event = ies.getEvent();
		String callId = null;
		if (event instanceof ResponseEvent) {
			ies.setInitialEvent(false);
			return ies;
		} else if (event instanceof RequestEvent) {
			// If request event, the convergence name to callId
			Request request = ((RequestEvent) event).getRequest();
			if (!request.getMethod().equals(Request.ACK)) {
				callId = ((ViaHeader) request.getHeaders(ViaHeader.NAME).next()).getBranch();
			} else {
				callId = ((ViaHeader) request.getHeaders(ViaHeader.NAME).next()).getBranch() + "_ACK";
			}
		}
		// Set the convergence name
		if (logger.isDebugEnabled()) {
			logger.debug("Setting convergence name to: " + callId);
		}
		ies.setCustomName(callId);

		logger.info("IES: " + ies.getCustomName() + "  " + ies.isInitialEvent());
		return ies;
	}

	public void onTimeEvent(TimerEvent event, ActivityContextInterface timerAci) {

		timerAci.detach(getSbbContext().getSbbLocalObject());
		switch (getServiceState()) {
		case INVITE_TIMER:
			try {
				Request request = getStoredRequest();
				ContactHeader remoteContact = (ContactHeader) request.getHeader(ContactHeader.NAME);
				// SipURI requestURI = (SipURI)
				// remoteContact.getAddress().getURI();

				FromHeader inFromHeader = (FromHeader) request.getHeader(FromHeader.NAME);
				ToHeader inToHeader = (ToHeader) request.getHeader(ToHeader.NAME);
				SipURI requestURI = (SipURI) inFromHeader.getAddress().getURI();
				FromHeader fromHeader = headerFactory.createFromHeader(inToHeader.getAddress(), "LoadTest_" + (Math.random() * 100000));
				ToHeader toHeader = headerFactory.createToHeader(inFromHeader.getAddress(), null);
				ArrayList viaHeaders = new ArrayList();
				ViaHeader viaHeader = this.sipFactoryProvider.getLocalVia(transport, null);

				// add via headers
				viaHeaders.add(viaHeader);

				ArrayList<RouteHeader> routeList = new ArrayList<RouteHeader>();
				ListIterator rrLit = request.getHeaders(RecordRouteHeader.NAME);

				while (rrLit.hasNext()) {

					RecordRouteHeader rrh = (RecordRouteHeader) rrLit.next();

					RouteHeader rh = sipFactoryProvider.getHeaderFactory().createRouteHeader(rrh.getAddress());
					Iterator pIt = rrh.getParameterNames();
					while (pIt.hasNext()) {
						String pName = (String) pIt.next();
						try {
							rh.setParameter(pName, rrh.getParameter(pName));
						} catch (ParseException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}

					}
					routeList.add(0, rh);
				}

				// Create ContentTypeHeader
				ContentTypeHeader contentTypeHeader = headerFactory.createContentTypeHeader("application", "sdp");

				// Create a new CallId header
				CallIdHeader callIdHeader = (CallIdHeader) request.getHeader(CallIdHeader.NAME);

				// Create a new Cseq header
				CSeqHeader cSeqHeader = headerFactory.createCSeqHeader(1L, Request.INVITE);

				// Create a new MaxForwardsHeader
				MaxForwardsHeader maxForwards = headerFactory.createMaxForwardsHeader(70);

				// Create the request.
				Request inviteRequest = messageFactory.createRequest(requestURI, Request.INVITE, callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
				// Create contact headers

				// Create the contact name address.
				SipURI contactURI = addressFactory.createSipURI(((SipURI) fromHeader.getAddress().getURI()).getUser(), sipFactoryProvider.getListeningPoints()[0].getIPAddress());
				contactURI.setPort(sipFactoryProvider.getListeningPoint("udp").getPort());

				Address contactAddress = addressFactory.createAddress(contactURI);

				// Add the contact address.
				contactAddress.setDisplayName(((SipURI) fromHeader.getAddress().getURI()).getUser());

				contactHeader = headerFactory.createContactHeader(contactAddress);
				inviteRequest.addHeader(contactHeader);

				// Dont use the Outbound Proxy. Use Lr instead.
				// inviteRequest.setHeader(routeHeader);
				for (Header h : routeList)
					inviteRequest.addLast(h);

				// Add the extension header.
				Header extensionHeader = headerFactory.createHeader("My-Header", "my header value");
				inviteRequest.addHeader(extensionHeader);

				String sdpData = "v=0\r\n" + "o=4855 13760799956958020 13760799956958020" + " IN IP4  129.6.55.78\r\n" + "s=mysession session\r\n" + "p=+46 8 52018010\r\n"
						+ "c=IN IP4  129.6.55.78\r\n" + "t=0 0\r\n" + "m=audio 6022 RTP/AVP 0 4 18\r\n" + "a=rtpmap:0 PCMU/8000\r\n" + "a=rtpmap:4 G723/8000\r\n"
						+ "a=rtpmap:18 G729A/8000\r\n" + "a=ptime:20\r\n";
				byte[] contents = sdpData.getBytes();

				inviteRequest.setContent(contents, contentTypeHeader);

				extensionHeader = headerFactory.createHeader("My-Other-Header", "my new header value ");
				inviteRequest.addHeader(extensionHeader);

				Header callInfoHeader = headerFactory.createHeader("Call-Info", "<http://www.antd.nist.gov>");
				inviteRequest.addHeader(callInfoHeader);

				// Create the client transaction.
				ClientTransaction inviteTid = sipFactoryProvider.getNewClientTransaction(inviteRequest);
				DialogActivity dialog = (DialogActivity) sipFactoryProvider.getNewDialog(inviteTid);
				ActivityContextInterface initialDialogAci = this.sipActivityContextInterfaceFactory.getActivityContextInterface(dialog);
				initialDialogAci.attach(getSbbContext().getSbbLocalObject());
				setOriginalDialog(initialDialogAci);
				// send the request out.

				if (logger.isInfoEnabled()) {
					logger.info("Sending INVITE: \n" + inviteRequest);
				}
				inviteTid.sendRequest();
				// setSentInvite(true);
			} catch (Exception e) {
				logger.error(e);
			}
			setServiceState(ServiceState.SENT_INVITE);
			break;

		case BYE_TIMER:
			ArrayList<DialogActivity> das = new ArrayList<DialogActivity>();
			for (ActivityContextInterface aci : getSbbContext().getActivities()) {
				if (aci.getActivity() != null && aci.getActivity() instanceof DialogActivity)
					das.add((DialogActivity) aci.getActivity());
			}

			for (DialogActivity da : das) {
				// DialogActivity da = (DialogActivity) aci.getActivity();
				try {

					Request byeRequest = da.createRequest(Request.BYE);
					da.sendRequest(byeRequest);
					if (logger.isInfoEnabled()) {
						logger.info("== SENDING BYE: " + da + "\n" + byeRequest);
					}
				} catch (SipException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}

			setServiceState(ServiceState.SENT_BYE);
		}

	}

	public void onActivityEndEvent(ActivityEndEvent end, ActivityContextInterface aci) {
		if (logger.isDebugEnabled()) {
			logger.debug("  ---  ActivityEnd; Activity: " + aci.getActivity());

			logger.debug("Original ACI:" + getOriginalDialog());
			logger.debug("Original Activity:" + (getOriginalDialog() == null ? null : getOriginalDialog().getActivity()));
			logger.debug("Child ACI:" + getChildDialog());
			logger.debug("Child Activity:" + (getChildDialog() == null ? null : getChildDialog().getActivity()));
		}
	}

	// Other mid-dialog requests handled the same way as above
	// Helpers

	// other request handling methods
	// lifecycle methods
	// CMP field accessors for each Dialogs ACI
	public abstract void setOriginalDialog(ActivityContextInterface aci);

	public abstract ActivityContextInterface getOriginalDialog();

	public abstract void setChildDialog(ActivityContextInterface aci);

	public abstract ActivityContextInterface getChildDialog();

	public abstract Boolean getMakeCancel();

	public abstract void setMakeCancel(Boolean b);

	public abstract Request getStoredRequest();

	public abstract void setStoredRequest(Request b);

	public void setSbbContext(SbbContext context) {
		this.sbbContext = context;
		try {
			Context ctx = (Context) new InitialContext().lookup("java:comp/env");
			sipActivityContextInterfaceFactory = (SipActivityContextInterfaceFactory) ctx.lookup("slee/resources/jainsip/1.2/acifactory");
			sipFactoryProvider = (SleeSipProvider) ctx.lookup("slee/resources/jainsip/1.2/provider");
			addressFactory = sipFactoryProvider.getAddressFactory();
			headerFactory = sipFactoryProvider.getHeaderFactory();
			messageFactory = sipFactoryProvider.getMessageFactory();
			this.timerFacility = (TimerFacility) ctx.lookup("slee/facilities/timer");
			nullACIFactory = (NullActivityContextInterfaceFactory) ctx.lookup("slee/nullactivity/activitycontextinterfacefactory");
			nullActivityFactory = (NullActivityFactory) ctx.lookup("slee/nullactivity/factory");
		} catch (NamingException e) {
			e.printStackTrace();
		}
	}

	public void unsetSbbContext() {
		this.sbbContext = null;
	}

	public void sbbCreate() throws javax.slee.CreateException {
	}

	public void sbbPostCreate() throws javax.slee.CreateException {
	}

	public void sbbActivate() {
	}

	public void sbbPassivate() {
	}

	public void sbbRemove() {
	}

	public void sbbLoad() {
	}

	public void sbbStore() {
	}

	public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
	}

	public void sbbRolledBack(RolledBackContext context) {
	}

	/**
	 * Convenience method to retrieve the SbbContext object stored in
	 * setSbbContext.
	 * 
	 * TODO: If your SBB doesn't require the SbbContext object you may remove
	 * this method, the sbbContext variable and the variable assignment in
	 * setSbbContext().
	 * 
	 * @return this SBB's SbbContext object
	 */

	protected SbbContext getSbbContext() {
		return sbbContext;
	}

	private SbbContext sbbContext; // This SBB's SbbContext

	public enum ServiceState {
		RECEIVED_MSG, INVITE_TIMER, SENT_INVITE, SENT_ACK, BYE_TIMER, SENT_BYE;
	}

	protected abstract ServiceState getServiceState();

	protected abstract void setServiceState(ServiceState s);
}