/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.registrar;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.DateHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderAddress;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.SLEEException;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;
import org.apache.log4j.Logger;
import org.mobicents.slee.services.sip.location.LocationSbbLocalObject;
import org.mobicents.slee.services.sip.location.LocationServiceException;
import org.mobicents.slee.services.sip.location.RegistrationBinding;
import org.mobicents.slee.services.sip.registrar.mbean.RegistrarConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegistrarSbb
implements Sbb {
    private static Logger logger = Logger.getLogger(RegistrarSbb.class);
    private static final RegistrarConfigurator config = new RegistrarConfigurator();
    private SleeSipProvider provider = null;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private SipActivityContextInterfaceFactory acif;
    private SbbContext sbbContext;
    private Context sbbEnv;

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        try {
            this.sbbEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.provider = (SleeSipProvider)this.sbbEnv.lookup("slee/resources/jainsip/1.2/provider");
            this.messageFactory = this.provider.getMessageFactory();
            this.headerFactory = this.provider.getHeaderFactory();
            this.addressFactory = this.provider.getAddressFactory();
            this.acif = (SipActivityContextInterfaceFactory)this.sbbEnv.lookup("slee/resources/jainsip/1.2/acifactory");
        }
        catch (NamingException ne) {
            logger.error((Object)"Could not set SBB context: ", (Throwable)ne);
        }
    }

    public void onServiceStarted(ServiceStartedEvent serviceEvent, ActivityContextInterface aci) {
        try {
            ServiceActivity sa = ((ServiceActivityFactory)this.sbbEnv.lookup("slee/serviceactivity/factory")).getActivity();
            if (sa.equals(aci.getActivity())) {
                config.startService();
                logger.info((Object)"Registrar Configuration MBean started");
                this.getLocationSbb().init();
            } else {
                aci.detach(this.sbbContext.getSbbLocalObject());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        try {
            ServiceActivity sa = ((ServiceActivityFactory)this.sbbEnv.lookup("slee/serviceactivity/factory")).getActivity();
            if (sa.equals(aci.getActivity())) {
                config.stopService();
                this.getLocationSbb().shutdown();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void onRegisterEvent(RequestEvent event, ActivityContextInterface ac) {
        block28: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("onRegisterEvent:\n request=" + event.getRequest()));
            }
            ac.detach(this.sbbContext.getSbbLocalObject());
            try {
                LocationSbbLocalObject locationService = this.getLocationSbb();
                long maxExpires = config.getSipRegistrationMaxExpires();
                long minExpires = config.getSipRegistrationMinExpires();
                String sipAddressOfRecord = this.getCanonicalAddress((HeaderAddress)event.getRequest().getHeader("To"));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("onRegisterEvent: address-of-record from request= " + sipAddressOfRecord));
                }
                String sipAddress = this.getCanonicalAddress((HeaderAddress)event.getRequest().getHeader("To"));
                Map bindings = locationService.getBindings(sipAddress);
                if (event.getRequest().getHeader("Contact") == null) {
                    logger.info((Object)("query for bindings: sipAddress=" + sipAddress));
                    this.sendRegistrationOKResponse(event.getServerTransaction(), event.getRequest(), bindings);
                    return;
                }
                ArrayList newContacts = this.getContactHeaderList(event.getRequest().getHeaders("Contact"));
                String callId = ((CallIdHeader)event.getRequest().getHeader("Call-ID")).getCallId();
                long seq = ((CSeqHeader)event.getRequest().getHeader("CSeq")).getSeqNumber();
                ExpiresHeader expiresHeader = event.getRequest().getExpires();
                if (this.hasWildCard(newContacts)) {
                    if (expiresHeader == null || expiresHeader.getExpires() != 0 || newContacts.size() > 1) {
                        this.sendErrorResponse(400, event.getServerTransaction(), event.getRequest());
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Removing bindings");
                    }
                    Iterator it = bindings.values().iterator();
                    try {
                        while (it.hasNext()) {
                            RegistrationBinding binding = (RegistrationBinding)it.next();
                            if (callId.equals(binding.getCallId())) {
                                if (seq > binding.getCSeq()) {
                                    it.remove();
                                    locationService.removeBinding(sipAddressOfRecord, binding.getContactAddress());
                                    continue;
                                }
                                this.sendErrorResponse(400, event.getServerTransaction(), event.getRequest());
                                return;
                            }
                            it.remove();
                            locationService.removeBinding(sipAddressOfRecord, binding.getContactAddress());
                        }
                    }
                    catch (LocationServiceException lse) {
                        logger.error((Object)lse);
                        this.sendErrorResponse(500, event.getServerTransaction(), event.getRequest());
                        return;
                    }
                    this.sendRegistrationOKResponse(event.getServerTransaction(), event.getRequest(), bindings);
                    break block28;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Updating bindings");
                }
                ListIterator li = newContacts.listIterator();
                while (li.hasNext()) {
                    ContactHeader contact = (ContactHeader)li.next();
                    long requestedExpires = 0L;
                    requestedExpires = contact.getExpires() >= 0 ? (long)contact.getExpires() : (expiresHeader != null && expiresHeader.getExpires() >= 0 ? (long)expiresHeader.getExpires() : 3600L);
                    if (requestedExpires > maxExpires) {
                        requestedExpires = maxExpires;
                    } else if (requestedExpires > 0L && requestedExpires < minExpires) {
                        this.sendIntervalTooBriefResponse(event.getServerTransaction(), event.getRequest(), minExpires);
                        return;
                    }
                    float q = 0.0f;
                    if (contact.getQValue() != -1.0f) {
                        q = contact.getQValue();
                    }
                    if (q > 1.0f || q < 0.0f) {
                        this.sendErrorResponse(400, event.getServerTransaction(), event.getRequest());
                        return;
                    }
                    String contactAddress = contact.getAddress().getURI().toString();
                    RegistrationBinding binding = (RegistrationBinding)bindings.get(contactAddress);
                    if (binding != null) {
                        if (callId.equals(binding.getCallId()) && seq <= binding.getCSeq()) {
                            this.sendErrorResponse(400, event.getServerTransaction(), event.getRequest());
                            return;
                        }
                        if (requestedExpires == 0L) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Removing binding: " + sipAddressOfRecord + " -> " + contactAddress));
                            }
                            bindings.remove(contactAddress);
                            locationService.removeBinding(sipAddressOfRecord, binding.getContactAddress());
                            continue;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Updating binding: " + sipAddressOfRecord + " -> " + contactAddress));
                            logger.debug((Object)("contact: " + contact.toString()));
                        }
                        binding.setCallId(callId);
                        binding.setExpires(requestedExpires);
                        binding.setRegistrationDate(System.currentTimeMillis());
                        binding.setCSeq(seq);
                        binding.setQValue(q);
                        locationService.updateBinding(binding);
                        continue;
                    }
                    if (requestedExpires == 0L) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding new binding: " + sipAddressOfRecord + " -> " + contactAddress));
                        logger.debug((Object)contact.toString());
                    }
                    RegistrationBinding registrationBinding = locationService.addBinding(sipAddress, contactAddress, "", requestedExpires, System.currentTimeMillis(), q, callId, seq);
                    bindings.put(registrationBinding.getContactAddress(), registrationBinding);
                }
                this.sendRegistrationOKResponse(event.getServerTransaction(), event.getRequest(), bindings);
            }
            catch (Exception e) {
                logger.warn((Object)"Exception during request processing", (Throwable)e);
                try {
                    this.sendErrorResponse(500, event.getServerTransaction(), event.getRequest());
                }
                catch (Exception ex) {
                    logger.error((Object)e);
                }
            }
        }
    }

    private String getCanonicalAddress(HeaderAddress header) {
        String addr = header.getAddress().getURI().toString();
        int index = addr.indexOf(58);
        if ((index = addr.indexOf(58, index + 1)) != -1) {
            addr = addr.substring(0, index);
        }
        return addr;
    }

    private List<ContactHeader> getContactHeaders(Collection<RegistrationBinding> bindings) {
        if (bindings == null) {
            return null;
        }
        ArrayList<ContactHeader> contactHeaders = new ArrayList<ContactHeader>();
        for (RegistrationBinding binding : bindings) {
            try {
                Address contactAddress = this.addressFactory.createAddress(binding.getContactAddress());
                ContactHeader contactHeader = this.headerFactory.createContactHeader(contactAddress);
                contactHeader.setExpires((int)binding.getExpiresDelta());
                contactHeader.setQValue(binding.getQValue());
                contactHeaders.add(contactHeader);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to create contact headers", (Throwable)e);
            }
        }
        return contactHeaders;
    }

    private ArrayList getContactHeaderList(ListIterator it) {
        ArrayList l = new ArrayList();
        while (it.hasNext()) {
            l.add(it.next());
        }
        return l;
    }

    private void sendRegistrationOKResponse(ServerTransaction serverTransaction, Request request, Map<String, RegistrationBinding> bindings) throws ParseException, SipException, InvalidArgumentException {
        List<ContactHeader> contactHeaders = this.getContactHeaders(bindings.values());
        Response res = this.messageFactory.createResponse(200, request);
        if (contactHeaders != null && !contactHeaders.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding " + contactHeaders.size() + " headers"));
            }
            for (int i = 0; i < contactHeaders.size(); ++i) {
                ContactHeader hdr = contactHeaders.get(i);
                res.addHeader((Header)hdr);
            }
        }
        DateHeader dateHeader = this.headerFactory.createDateHeader((Calendar)new GregorianCalendar());
        res.setHeader((Header)dateHeader);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("sending response:\n" + res));
        }
        serverTransaction.sendResponse(res);
    }

    private void sendErrorResponse(int responseCode, ServerTransaction serverTransaction, Request request) throws ParseException, SipException, InvalidArgumentException {
        Response response = this.messageFactory.createResponse(responseCode, request);
        serverTransaction.sendResponse(response);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("sending response:\n" + response));
        }
    }

    private void sendIntervalTooBriefResponse(ServerTransaction serverTransaction, Request request, long minExpires) throws ParseException, SipException, InvalidArgumentException {
        Response res = this.messageFactory.createResponse(423, request);
        res.setHeader((Header)this.headerFactory.createDateHeader((Calendar)new GregorianCalendar()));
        res.addHeader(this.headerFactory.createHeader("Min-Expires", Long.toString(minExpires)));
        if (logger.isInfoEnabled()) {
            logger.info((Object)("sending response:\n" + res.toString()));
        }
        serverTransaction.sendResponse(res);
    }

    private boolean hasWildCard(ArrayList contactHeaders) {
        for (ContactHeader header : contactHeaders) {
            if (header.toString().indexOf(42) <= 0) continue;
            return true;
        }
        return false;
    }

    public abstract ChildRelation getLocationSbbChildRelation();

    public LocationSbbLocalObject getLocationSbb() throws TransactionRequiredLocalException, SLEEException, CreateException {
        return (LocationSbbLocalObject)this.getLocationSbbChildRelation().create();
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbPassivate() {
    }

    public void sbbActivate() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface aci) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }
}

