/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.registrar.mbean;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.services.sip.registrar.mbean.RegistrarConfiguratorMBean;

public class RegistrarConfigurator
implements RegistrarConfiguratorMBean {
    private String name = "v1RegistrarConf";
    private long minExpires = 150L;
    private long maxExpires = 3600L;

    public long getSipRegistrationMaxExpires() {
        return this.maxExpires;
    }

    public long getSipRegistrationMinExpires() {
        return this.minExpires;
    }

    public void setSipRegistrationMaxExpires(long maxExpires) {
        this.maxExpires = maxExpires <= 0L ? 3600L : maxExpires;
        if (this.maxExpires <= this.minExpires) {
            this.minExpires = this.maxExpires - 10L;
        }
    }

    public void setSipRegistrationMinExpires(long minExpires) {
        this.minExpires = minExpires <= 0L ? 60L : minExpires;
        if (this.maxExpires <= this.minExpires) {
            this.maxExpires = this.minExpires + 10L;
        }
    }

    public Object clone() {
        return new RegistrarConfigurator(this.minExpires, this.maxExpires);
    }

    public RegistrarConfigurator(long minExpires, long maxExpires) {
        this.minExpires = minExpires;
        this.maxExpires = maxExpires;
    }

    public RegistrarConfigurator() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean startService() {
        MBeanServer mbs = SleeContainer.lookupFromJndi().getMBeanServer();
        ObjectName on = null;
        try {
            on = new ObjectName("slee:sipregistrarconfigurator=" + this.name);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        try {
            if (mbs.getObjectInstance(on) != null) {
                mbs.unregisterMBean(on);
            }
        }
        catch (InstanceNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            mbs.registerMBean(this, on);
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            return false;
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            return false;
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

