/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.location.nonha;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.mobicents.slee.services.sip.location.LocationService;
import org.mobicents.slee.services.sip.location.LocationServiceException;
import org.mobicents.slee.services.sip.location.RegistrationBinding;
import org.mobicents.slee.services.sip.location.jmx.LocationServiceManagement;
import org.mobicents.slee.services.sip.location.nonha.RegistrationBindingImpl;
import org.mobicents.slee.services.sip.location.nonha.RegistrationBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonHALocationService
implements LocationService {
    private ConcurrentHashMap<String, RegistrationBindings> bindingsMap = new ConcurrentHashMap();
    private static final Logger logger = Logger.getLogger(LocationService.class);

    public Map<String, RegistrationBinding> getBindings(String sipAddress) throws LocationServiceException {
        RegistrationBindings bindings = this.bindingsMap.get(sipAddress);
        if (bindings != null) {
            HashMap<String, RegistrationBinding> resultMap = new HashMap<String, RegistrationBinding>();
            for (String key : bindings.getBindings().keySet()) {
                resultMap.put(key, bindings.getBindings().get(key));
            }
            return resultMap;
        }
        return new HashMap<String, RegistrationBinding>();
    }

    public RegistrationBinding addBinding(String sipAddress, String contactAddress, String comment, long expires, long registrationDate, float qValue, String callId, long cSeq) throws LocationServiceException {
        RegistrationBindings otherBindings;
        RegistrationBindingImpl registrationBinding = new RegistrationBindingImpl(sipAddress, contactAddress, expires, registrationDate, qValue, callId, cSeq, comment);
        RegistrationBindings bindings = this.bindingsMap.get(sipAddress);
        if (bindings == null && (otherBindings = this.bindingsMap.putIfAbsent(sipAddress, bindings = new RegistrationBindings())) != null) {
            bindings = otherBindings;
        }
        if (bindings.getBindings().putIfAbsent(contactAddress, registrationBinding) != null) {
            throw new LocationServiceException("Binding already exists");
        }
        return registrationBinding;
    }

    public void removeBinding(String sipAddress, String sipContact) throws LocationServiceException {
        RegistrationBindings bindings = this.bindingsMap.get(sipAddress);
        if (bindings != null) {
            bindings.getBindings().remove(sipContact);
            if (bindings.getBindings().isEmpty()) {
                this.bindingsMap.remove(sipAddress, bindings);
            }
        }
    }

    public void updateBinding(RegistrationBinding registrationBinding) throws LocationServiceException {
        RegistrationBindings bindings = this.bindingsMap.get(registrationBinding.getSipAddress());
        if (bindings != null) {
            bindings.getBindings().put(registrationBinding.getContactAddress(), registrationBinding);
        }
    }

    public Set<String> getRegisteredUsers() throws LocationServiceException {
        return this.bindingsMap.keySet();
    }

    public void init() {
        LocationServiceManagement.create((LocationService)this);
        logger.info((Object)"Non HA Location Service started.");
    }

    public void shutdown() {
        LocationServiceManagement.destroy();
        logger.info((Object)"Non HA Location Service shutdown.");
    }

    public Set<String> getContacts(String sipAddress) throws LocationServiceException {
        return this.getBindings(sipAddress).keySet();
    }

    public long getExpirationTime(String sipAddress, String contactAddress) throws LocationServiceException {
        RegistrationBindings bindings = this.bindingsMap.get(sipAddress);
        if (bindings != null) {
            for (String address : bindings.getBindings().keySet()) {
                if (!address.equals(contactAddress)) continue;
                return bindings.getBindings().get(address).getExpiresDelta();
            }
        }
        return -1L;
    }

    public int getRegisteredUserCount() throws LocationServiceException {
        return this.getRegisteredUsers().size();
    }
}

